/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.model.gml.geometry.primitives.PolygonProperty;

public class MultiPolygon
extends AbstractGeometricAggregate {
    private List<PolygonProperty> polygonMember;

    public MultiPolygon() {
    }

    public MultiPolygon(List<Polygon> polygons) {
        for (Polygon polygon : polygons) {
            this.addPolygonMember(new PolygonProperty(polygon));
        }
    }

    public MultiPolygon(Polygon ... polygons) {
        this(Arrays.asList(polygons));
    }

    public void addPolygonMember(PolygonProperty polygonMember) {
        this.getPolygonMember().add(polygonMember);
    }

    public List<PolygonProperty> getPolygonMember() {
        if (this.polygonMember == null) {
            this.polygonMember = new ChildList<PolygonProperty>(this);
        }
        return this.polygonMember;
    }

    public boolean isSetPolygonMember() {
        return this.polygonMember != null && !this.polygonMember.isEmpty();
    }

    public void setPolygonMember(List<PolygonProperty> polygonMember) {
        this.polygonMember = new ChildList<PolygonProperty>((ModelObject)this, polygonMember);
    }

    public void unsetPolygonMember() {
        this.polygonMember = ModelObjects.setNull(this.polygonMember);
    }

    public boolean unsetPolygonMember(PolygonProperty polygonMember) {
        return this.isSetPolygonMember() && this.polygonMember.remove(polygonMember);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        if (this.isSetPolygonMember()) {
            for (PolygonProperty polygonProperty : this.getPolygonMember()) {
                if (!polygonProperty.isSetPolygon()) continue;
                bbox.update(polygonProperty.getPolygon().calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_POLYGON;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiPolygon(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiPolygon copy = target == null ? new MultiPolygon() : (MultiPolygon)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetPolygonMember()) {
            for (PolygonProperty part : this.polygonMember) {
                PolygonProperty copyPart = (PolygonProperty)copyBuilder.copy(part);
                copy.addPolygonMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

