/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.primitives;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.basicTypes.Coordinates;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.Coord;
import org.citygml4j.model.gml.geometry.primitives.DirectPosition;
import org.citygml4j.model.gml.geometry.primitives.DirectPositionList;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.PointRep;
import org.citygml4j.model.gml.geometry.primitives.PosOrPointPropertyOrPointRepOrCoord;

public class LineString
extends AbstractCurve {
    private List<PosOrPointPropertyOrPointRepOrCoord> controlPoints;
    private DirectPositionList posList;
    private Coordinates coordinates;

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.LINE_STRING;
    }

    public void addCoord(Coord coord) {
        this.getPosOrPointPropertyOrPointRepOrCoord().add(new PosOrPointPropertyOrPointRepOrCoord(coord));
    }

    public void addPointProperty(PointProperty pointProperty) {
        this.getPosOrPointPropertyOrPointRepOrCoord().add(new PosOrPointPropertyOrPointRepOrCoord(pointProperty));
    }

    public void addPointRep(PointRep pointRep) {
        this.getPosOrPointPropertyOrPointRepOrCoord().add(new PosOrPointPropertyOrPointRepOrCoord(pointRep));
    }

    public void addPos(DirectPosition pos) {
        this.getPosOrPointPropertyOrPointRepOrCoord().add(new PosOrPointPropertyOrPointRepOrCoord(pos));
    }

    public void addControlPoint(PosOrPointPropertyOrPointRepOrCoord controlPoint) {
        this.getPosOrPointPropertyOrPointRepOrCoord().add(controlPoint);
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public DirectPositionList getPosList() {
        return this.posList;
    }

    public List<PosOrPointPropertyOrPointRepOrCoord> getPosOrPointPropertyOrPointRepOrCoord() {
        if (this.controlPoints == null) {
            this.controlPoints = new ChildList<PosOrPointPropertyOrPointRepOrCoord>(this);
        }
        return this.controlPoints;
    }

    public boolean isSetCoordinates() {
        return this.coordinates != null;
    }

    public boolean isSetPosList() {
        return this.posList != null;
    }

    public boolean isSetPosOrPointPropertyOrPointRepOrCoord() {
        return this.controlPoints != null && !this.controlPoints.isEmpty();
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = ModelObjects.setParent(coordinates, (ModelObject)this);
    }

    public void setPosList(DirectPositionList posList) {
        this.posList = ModelObjects.setParent(posList, (ModelObject)this);
    }

    public void setPosOrPointPropertyOrPointRepOrCoord(List<PosOrPointPropertyOrPointRepOrCoord> controlPoints) {
        this.controlPoints = new ChildList<PosOrPointPropertyOrPointRepOrCoord>((ModelObject)this, controlPoints);
    }

    @Override
    public List<Double> toList3d() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        if (this.isSetPosList()) {
            tmp.addAll(this.posList.toList3d());
        }
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            for (PosOrPointPropertyOrPointRepOrCoord controlPoint : this.controlPoints) {
                tmp.addAll(controlPoint.toList3d());
            }
        }
        if (this.isSetCoordinates()) {
            tmp.addAll(this.coordinates.toList3d());
        }
        return tmp;
    }

    public void unsetCoordinates() {
        this.coordinates = ModelObjects.setNull(this.coordinates);
    }

    public void unsetPosList() {
        this.posList = ModelObjects.setNull(this.posList);
    }

    public void unsetPosOrPointPropertyOrPointRepOrCoord() {
        this.controlPoints = ModelObjects.setNull(this.controlPoints);
    }

    public boolean unsetPosOrPointPropertyOrPointRepOrCoord(PosOrPointPropertyOrPointRepOrCoord controlPoint) {
        return this.isSetPosOrPointPropertyOrPointRepOrCoord() && this.controlPoints.remove(controlPoint);
    }

    public boolean unsetCoord(Coord coord) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            Iterator<PosOrPointPropertyOrPointRepOrCoord> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRepOrCoord controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getCoord().equals(coord)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    public boolean unsetPointProperty(PointProperty pointProperty) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            Iterator<PosOrPointPropertyOrPointRepOrCoord> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRepOrCoord controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPointProperty().equals(pointProperty)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    public boolean unsetPointRep(PointRep pointRep) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            Iterator<PosOrPointPropertyOrPointRepOrCoord> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRepOrCoord controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPointRep().equals(pointRep)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    public boolean unsetPos(DirectPosition pos) {
        boolean success = false;
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            Iterator<PosOrPointPropertyOrPointRepOrCoord> iter = this.controlPoints.iterator();
            while (iter.hasNext()) {
                PosOrPointPropertyOrPointRepOrCoord controlPoint = iter.next();
                if (controlPoint == null || !controlPoint.getPos().equals(pos)) continue;
                iter.remove();
                success = true;
                break;
            }
        }
        return success;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        LineString copy = target == null ? new LineString() : (LineString)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetPosOrPointPropertyOrPointRepOrCoord()) {
            for (PosOrPointPropertyOrPointRepOrCoord part : this.controlPoints) {
                PosOrPointPropertyOrPointRepOrCoord copyPart = (PosOrPointPropertyOrPointRepOrCoord)copyBuilder.copy(part);
                copy.addControlPoint(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetPosList()) {
            copy.setPosList((DirectPositionList)copyBuilder.copy(this.posList));
            if (copy.getPosList() == this.posList) {
                this.posList.setParent(this);
            }
        }
        if (this.isSetCoordinates()) {
            copy.setCoordinates((Coordinates)copyBuilder.copy(this.coordinates));
            if (copy.getCoordinates() == this.coordinates) {
                this.coordinates.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new LineString(), copyBuilder);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

