/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.module;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleType;
import org.citygml4j.model.module.ModuleVersion;

public class AbstractModuleConfiguration
implements Serializable {
    protected Module[] modules;

    public <T extends Module> AbstractModuleConfiguration(T[] modules) {
        this.modules = modules;
    }

    public AbstractModuleConfiguration(List<? extends Module> modules) {
        this.modules = (Module[])modules.toArray();
    }

    public List<? extends Module> getModules() {
        return Arrays.asList(this.modules);
    }

    public Module getModule(ModuleType type) {
        for (Module module : this.modules) {
            if (!module.getType().equals(type)) continue;
            return module;
        }
        return null;
    }

    public boolean contains(ModuleType type, ModuleVersion version) {
        for (Module module : this.modules) {
            if (!module.getType().equals(type)) continue;
            return module.getVersion().equals(version);
        }
        return false;
    }

    public boolean contains(Module module) {
        for (Module candidate : this.modules) {
            if (!candidate.equals(module)) continue;
            return true;
        }
        return false;
    }
}

