/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.citygml4j.CityGMLContext;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleType;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityGMLModuleType;
import org.citygml4j.model.module.citygml.CityGMLVersion;
import org.citygml4j.model.module.gml.GMLModule;
import org.citygml4j.model.module.gml.GMLModuleType;
import org.citygml4j.model.module.xal.XALModule;
import org.citygml4j.model.module.xal.XALModuleType;

public class ModuleContext {
    private CityGMLVersion version;
    private HashMap<ModuleType, Module> modules = new HashMap();
    private HashSet<ADEModule> adeModules;

    public ModuleContext() {
        this(CityGMLVersion.DEFAULT);
    }

    public ModuleContext(CityGMLVersion version) {
        this.version = version;
        for (Module module : version.getModules()) {
            this.modules.put(module.getType(), module);
        }
        this.addADEModules();
    }

    public ModuleContext(ModuleContext moduleContext) {
        this.version = moduleContext.version;
        this.modules = new HashMap<ModuleType, Module>(moduleContext.modules);
        if (moduleContext.adeModules != null) {
            this.adeModules = new HashSet<ADEModule>(moduleContext.adeModules);
        }
    }

    public Module getModule(CityGMLModuleType type) {
        return this.modules.get(type);
    }

    public Module getModule(GMLModuleType type) {
        return this.modules.get(type);
    }

    public Module getModule(XALModuleType type) {
        return this.modules.get(type);
    }

    public boolean contains(Module module) {
        if (!(module instanceof ADEModule)) {
            return this.modules.values().contains(module);
        }
        return this.adeModules != null && this.adeModules.contains(module);
    }

    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>(this.modules.values());
        if (this.adeModules != null) {
            modules.addAll(this.adeModules);
        }
        return modules;
    }

    public List<CityGMLModule> getCityGMLModules() {
        return this.getModules(CityGMLModule.class);
    }

    public List<GMLModule> getGMLModules() {
        return this.getModules(GMLModule.class);
    }

    public List<XALModule> getXALModules() {
        return this.getModules(XALModule.class);
    }

    public List<ADEModule> getADEModules() {
        return this.adeModules != null ? new ArrayList<ADEModule>(this.adeModules) : Collections.emptyList();
    }

    public CityGMLVersion getCityGMLVersion() {
        return this.version;
    }

    public void setCityGMLVersion(CityGMLVersion version) {
        this.version = version;
        this.modules = new HashMap();
        this.adeModules = null;
        for (Module module : version.getModules()) {
            this.modules.put(module.getType(), module);
        }
        this.addADEModules();
    }

    private void addADEModules() {
        CityGMLContext context = CityGMLContext.getInstance();
        if (context.hasADEContexts()) {
            for (ADEContext adeContext : context.getADEContexts()) {
                block1: for (ADEModule module : adeContext.getADEModules()) {
                    if (module.getCityGMLVersion() != this.version) continue;
                    for (Module dependency : module.getDependencies()) {
                        if (!this.contains(dependency)) continue;
                        if (this.adeModules == null) {
                            this.adeModules = new HashSet();
                        }
                        this.adeModules.add(module);
                        continue block1;
                    }
                }
            }
        }
    }

    private <T extends Module> List<T> getModules(Class<T> moduleClass) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : this.modules.values()) {
            if (!moduleClass.isInstance(module)) continue;
            result.add((Module)moduleClass.cast(module));
        }
        return result;
    }
}

