/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleType;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.ade.ADEModuleType;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.model.module.citygml.BridgeModule;
import org.citygml4j.model.module.citygml.BuildingModule;
import org.citygml4j.model.module.citygml.CityFurnitureModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityGMLModuleType;
import org.citygml4j.model.module.citygml.CityObjectGroupModule;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.model.module.citygml.GenericsModule;
import org.citygml4j.model.module.citygml.LandUseModule;
import org.citygml4j.model.module.citygml.ReliefModule;
import org.citygml4j.model.module.citygml.TexturedSurfaceModule;
import org.citygml4j.model.module.citygml.TransportationModule;
import org.citygml4j.model.module.citygml.TunnelModule;
import org.citygml4j.model.module.citygml.VegetationModule;
import org.citygml4j.model.module.citygml.WaterBodyModule;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.gml.GMLModule;
import org.citygml4j.model.module.gml.GMLModuleType;
import org.citygml4j.model.module.gml.XLinkModule;
import org.citygml4j.model.module.xal.XALCoreModule;
import org.citygml4j.model.module.xal.XALModule;
import org.citygml4j.model.module.xal.XALModuleType;

public class Modules {
    private static Map<String, Module> modules = new ConcurrentHashMap<String, Module>();

    private Modules() {
    }

    public static Module getModule(String namespaceURI) {
        return modules.get(namespaceURI);
    }

    public static List<Module> getModules() {
        return new ArrayList<Module>(modules.values());
    }

    public static List<CityGMLModule> getCityGMLModules() {
        return Modules.getModules(CityGMLModule.class);
    }

    public static CityGMLModule getCityGMLModule(String namespaceURI) {
        return Modules.getModule(CityGMLModule.class, namespaceURI);
    }

    public static List<CityGMLModule> getCityGMLModules(CityGMLModuleType type) {
        return Modules.getModules(CityGMLModule.class, type);
    }

    public static List<GMLModule> getGMLModules() {
        return Modules.getModules(GMLModule.class);
    }

    public static List<GMLModule> getGMLModules(GMLModuleType type) {
        return Modules.getModules(GMLModule.class, type);
    }

    public static List<XALModule> getXALModules() {
        return Modules.getModules(XALModule.class);
    }

    public static List<XALModule> getXALModules(XALModuleType type) {
        return Modules.getModules(XALModule.class, type);
    }

    public static void registerADEModule(ADEModule module) {
        modules.put(module.getNamespaceURI(), module);
    }

    public static void unregisterADEModule(ADEModule module) {
        modules.remove(module.getNamespaceURI());
    }

    public static List<ADEModule> getADEModules() {
        return Modules.getModules(ADEModule.class);
    }

    public static List<ADEModule> getADEModules(ADEModuleType type) {
        return Modules.getModules(ADEModule.class, type);
    }

    public static ADEModule getADEModule(String namespaceURI) {
        return Modules.getModule(ADEModule.class, namespaceURI);
    }

    public static boolean isCityGMLModuleNamespace(String namespaceURI) {
        return namespaceURI != null && namespaceURI.startsWith("http://www.opengis.net/citygml");
    }

    public static boolean isModuleNamespace(String namespaceURI, ModuleType type) {
        Module module = modules.get(namespaceURI);
        return module != null && module.getType().equals(type);
    }

    private static <T extends Module> T getModule(Class<T> moduleClass, String namespaceURI) {
        Module module = modules.get(namespaceURI);
        return (T)(moduleClass.isInstance(module) ? (Module)moduleClass.cast(module) : null);
    }

    private static <T extends Module> List<T> getModules(Class<T> moduleClass) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules.values()) {
            if (!moduleClass.isInstance(module)) continue;
            result.add((Module)moduleClass.cast(module));
        }
        return result;
    }

    private static <T extends Module> List<T> getModules(Class<T> moduleClass, ModuleType type) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules.values()) {
            if (!module.getType().equals(type) || !moduleClass.isInstance(module)) continue;
            result.add((Module)moduleClass.cast(module));
        }
        return result;
    }

    static {
        for (Module module : CoreModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : AppearanceModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : BridgeModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : BuildingModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : CityFurnitureModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : CityObjectGroupModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : GenericsModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : LandUseModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : ReliefModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : TransportationModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : TunnelModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : VegetationModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : WaterBodyModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : TexturedSurfaceModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : GMLCoreModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : XLinkModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
        for (Module module : XALCoreModule.getInstances()) {
            modules.put(module.getNamespaceURI(), module);
        }
    }
}

