/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.gmlid;

import java.util.UUID;
import java.util.regex.Pattern;
import org.citygml4j.util.gmlid.GMLIdManager;

public class DefaultGMLIdManager
implements GMLIdManager {
    private static final DefaultGMLIdManager instance = new DefaultGMLIdManager();
    private final String defaultPrefix = "UUID_";
    private final Pattern pattern = Pattern.compile("[_A-Za-z][-._A-Za-z0-9]*", 256);
    private String prefix = "UUID_";

    private DefaultGMLIdManager() {
    }

    public static DefaultGMLIdManager getInstance() {
        return instance;
    }

    @Override
    public String getDefaultPrefix() {
        return "UUID_";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        if (this.pattern.matcher(prefix).matches()) {
            this.prefix = prefix;
        }
    }

    public boolean isValidPrefix(String prefix) {
        return this.pattern.matcher(prefix).matches();
    }

    @Override
    public String generateUUID(String prefix) {
        if (!this.pattern.matcher(prefix).matches()) {
            prefix = "UUID_";
        }
        return prefix + UUID.randomUUID().toString();
    }

    @Override
    public String generateUUID() {
        return this.generateUUID(this.prefix);
    }
}

