/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.walker;

import java.util.ArrayList;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.texturedsurface._TexturedSurface;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.base.AssociationByRepOrRef;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryArrayProperty;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.InlineGeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurve;
import org.citygml4j.model.gml.geometry.aggregates.MultiGeometry;
import org.citygml4j.model.gml.geometry.aggregates.MultiLineString;
import org.citygml4j.model.gml.geometry.aggregates.MultiPoint;
import org.citygml4j.model.gml.geometry.aggregates.MultiPolygon;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolid;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.complexes.CompositeCurve;
import org.citygml4j.model.gml.geometry.complexes.CompositeSolid;
import org.citygml4j.model.gml.geometry.complexes.CompositeSurface;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplex;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.AbstractGeometricPrimitive;
import org.citygml4j.model.gml.geometry.primitives.AbstractRing;
import org.citygml4j.model.gml.geometry.primitives.AbstractRingProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractSolid;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurfacePatch;
import org.citygml4j.model.gml.geometry.primitives.Curve;
import org.citygml4j.model.gml.geometry.primitives.CurveProperty;
import org.citygml4j.model.gml.geometry.primitives.GeometricPrimitiveProperty;
import org.citygml4j.model.gml.geometry.primitives.LineString;
import org.citygml4j.model.gml.geometry.primitives.LineStringProperty;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.model.gml.geometry.primitives.OrientableCurve;
import org.citygml4j.model.gml.geometry.primitives.OrientableSurface;
import org.citygml4j.model.gml.geometry.primitives.Point;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.model.gml.geometry.primitives.PolygonPatch;
import org.citygml4j.model.gml.geometry.primitives.PolygonProperty;
import org.citygml4j.model.gml.geometry.primitives.Rectangle;
import org.citygml4j.model.gml.geometry.primitives.Ring;
import org.citygml4j.model.gml.geometry.primitives.Solid;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.gml.geometry.primitives.Surface;
import org.citygml4j.model.gml.geometry.primitives.SurfacePatchArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.Tin;
import org.citygml4j.model.gml.geometry.primitives.Triangle;
import org.citygml4j.model.gml.geometry.primitives.TriangulatedSurface;
import org.citygml4j.model.gml.grids.Grid;
import org.citygml4j.model.gml.grids.RectifiedGrid;
import org.citygml4j.util.walker.Walker;

public abstract class GeometryWalker
extends Walker
implements GeometryVisitor {
    public void visit(AbstractGeometry abstractGeometry) {
    }

    @Override
    public void visit(LodRepresentation lodRepresentation) {
        if (lodRepresentation != null) {
            for (int lod = 0; lod < 5; ++lod) {
                for (AssociationByRepOrRef<? extends AbstractGML> property : lodRepresentation.getRepresentation(lod)) {
                    this.visit(property);
                }
            }
        }
    }

    public void visit(AbstractGeometricPrimitive abstractGeometricPrimitive) {
        this.visit((AbstractGeometry)abstractGeometricPrimitive);
    }

    public void visit(AbstractGeometricAggregate abstractGeometricAggregate) {
        this.visit((AbstractGeometry)abstractGeometricAggregate);
    }

    public void visit(AbstractCurve abstractCurve) {
        this.visit((AbstractGeometricPrimitive)abstractCurve);
    }

    public void visit(AbstractSolid abstractSolid) {
        this.visit((AbstractGeometricPrimitive)abstractSolid);
    }

    public void visit(AbstractSurface abstractSurface) {
        this.visit((AbstractGeometricPrimitive)abstractSurface);
    }

    public void visit(AbstractRing abstractRing) {
        this.visit((AbstractGeometry)abstractRing);
    }

    public void visit(AbstractSurfacePatch surfacePatch) {
    }

    public void visit(Triangle triangle) {
        this.visit((AbstractSurfacePatch)triangle);
        if (triangle.isSetExterior()) {
            this.visit(triangle.getExterior());
        }
    }

    public void visit(Rectangle rectangle) {
        this.visit((AbstractSurfacePatch)rectangle);
        if (rectangle.isSetExterior()) {
            this.visit(rectangle.getExterior());
        }
    }

    public void visit(PolygonPatch polygonPatch) {
        this.visit((AbstractSurfacePatch)polygonPatch);
        if (polygonPatch.isSetExterior()) {
            this.visit(polygonPatch.getExterior());
        }
        if (polygonPatch.isSetInterior()) {
            for (AbstractRingProperty interior : new ArrayList<AbstractRingProperty>(polygonPatch.getInterior())) {
                this.visit(interior);
            }
        }
    }

    @Override
    public void visit(CompositeCurve compositeCurve) {
        this.visit((AbstractCurve)compositeCurve);
        for (CurveProperty curveProperty : new ArrayList<CurveProperty>(compositeCurve.getCurveMember())) {
            this.visit(curveProperty);
        }
    }

    @Override
    public void visit(CompositeSolid compositeSolid) {
        this.visit((AbstractSolid)compositeSolid);
        for (SolidProperty solidProperty : new ArrayList<SolidProperty>(compositeSolid.getSolidMember())) {
            this.visit(solidProperty);
        }
    }

    @Override
    public void visit(CompositeSurface compositeSurface) {
        this.visit((AbstractSurface)compositeSurface);
        for (SurfaceProperty surfaceProperty : new ArrayList<SurfaceProperty>(compositeSurface.getSurfaceMember())) {
            this.visit(surfaceProperty);
        }
    }

    @Override
    public void visit(Curve curve) {
        this.visit((AbstractCurve)curve);
    }

    @Override
    public void visit(GeometricComplex geometricComplex) {
        this.visit((AbstractGeometry)geometricComplex);
        if (geometricComplex.isSetElement()) {
            for (GeometricPrimitiveProperty geometricPrimitiveProperty : new ArrayList<GeometricPrimitiveProperty>(geometricComplex.getElement())) {
                this.visit(geometricPrimitiveProperty);
            }
        }
    }

    @Override
    public void visit(Grid grid) {
        this.visit((AbstractGeometry)grid);
    }

    @Override
    public void visit(LinearRing linearRing) {
        this.visit((AbstractRing)linearRing);
    }

    @Override
    public void visit(LineString lineString) {
        this.visit((AbstractCurve)lineString);
    }

    @Override
    public void visit(MultiCurve multiCurve) {
        this.visit((AbstractGeometricAggregate)multiCurve);
        if (multiCurve.isSetCurveMember()) {
            for (CurveProperty curveProperty : new ArrayList<CurveProperty>(multiCurve.getCurveMember())) {
                this.visit(curveProperty);
            }
        }
        if (multiCurve.isSetCurveMembers()) {
            this.visit(multiCurve.getCurveMembers());
        }
    }

    @Override
    public void visit(MultiGeometry multiGeometry) {
        this.visit((AbstractGeometricAggregate)multiGeometry);
        if (multiGeometry.isSetGeometryMember()) {
            for (GeometryProperty<? extends AbstractGeometry> geometryProperty : new ArrayList<GeometryProperty<? extends AbstractGeometry>>(multiGeometry.getGeometryMember())) {
                this.visit(geometryProperty);
            }
        }
        if (multiGeometry.isSetGeometryMembers()) {
            this.visit(multiGeometry.getGeometryMembers());
        }
    }

    @Override
    public void visit(MultiLineString multiLineString) {
        this.visit((AbstractGeometricAggregate)multiLineString);
        if (multiLineString.isSetLineStringMember()) {
            for (LineStringProperty lineStringProperty : new ArrayList<LineStringProperty>(multiLineString.getLineStringMember())) {
                this.visit(lineStringProperty);
            }
        }
    }

    @Override
    public void visit(MultiPoint multiPoint) {
        this.visit((AbstractGeometricAggregate)multiPoint);
        if (multiPoint.isSetPointMember()) {
            for (PointProperty pointProperty : new ArrayList<PointProperty>(multiPoint.getPointMember())) {
                this.visit(pointProperty);
            }
        }
        if (multiPoint.isSetPointMembers()) {
            this.visit(multiPoint.getPointMembers());
        }
    }

    @Override
    public void visit(MultiPolygon multiPolygon) {
        this.visit((AbstractGeometricAggregate)multiPolygon);
        if (multiPolygon.isSetPolygonMember()) {
            for (PolygonProperty polygonProperty : new ArrayList<PolygonProperty>(multiPolygon.getPolygonMember())) {
                this.visit(polygonProperty);
            }
        }
    }

    @Override
    public void visit(MultiSolid multiSolid) {
        this.visit((AbstractGeometricAggregate)multiSolid);
        if (multiSolid.isSetSolidMember()) {
            for (SolidProperty solidProperty : new ArrayList<SolidProperty>(multiSolid.getSolidMember())) {
                this.visit(solidProperty);
            }
        }
        if (multiSolid.isSetSolidMembers()) {
            this.visit(multiSolid.getSolidMembers());
        }
    }

    @Override
    public void visit(MultiSurface multiSurface) {
        this.visit((AbstractGeometricAggregate)multiSurface);
        if (multiSurface.isSetSurfaceMember()) {
            for (SurfaceProperty surfaceProperty : new ArrayList<SurfaceProperty>(multiSurface.getSurfaceMember())) {
                this.visit(surfaceProperty);
            }
        }
        if (multiSurface.isSetSurfaceMembers()) {
            this.visit(multiSurface.getSurfaceMembers());
        }
    }

    @Override
    public void visit(OrientableCurve orientableCurve) {
        this.visit((AbstractCurve)orientableCurve);
        if (orientableCurve.isSetBaseCurve()) {
            this.visit(orientableCurve.getBaseCurve());
        }
    }

    @Override
    public void visit(OrientableSurface orientableSurface) {
        this.visit((AbstractSurface)orientableSurface);
        if (orientableSurface.isSetBaseSurface()) {
            this.visit(orientableSurface.getBaseSurface());
        }
    }

    @Override
    public void visit(_TexturedSurface texturedSurface) {
        this.visit((OrientableSurface)texturedSurface);
    }

    @Override
    public void visit(Point point) {
        this.visit((AbstractGeometricPrimitive)point);
    }

    @Override
    public void visit(Polygon polygon) {
        this.visit((AbstractSurface)polygon);
        if (polygon.isSetExterior()) {
            this.visit(polygon.getExterior());
        }
        if (polygon.isSetInterior()) {
            for (AbstractRingProperty interior : new ArrayList<AbstractRingProperty>(polygon.getInterior())) {
                this.visit(interior);
            }
        }
    }

    @Override
    public void visit(RectifiedGrid rectifiedGrid) {
        this.visit((Grid)rectifiedGrid);
        if (rectifiedGrid.isSetOrigin()) {
            this.visit(rectifiedGrid.getOrigin());
        }
    }

    @Override
    public void visit(Ring ring) {
        this.visit((AbstractRing)ring);
        if (ring.isSetCurveMember()) {
            for (CurveProperty curveProperty : new ArrayList<CurveProperty>(ring.getCurveMember())) {
                this.visit(curveProperty);
            }
        }
    }

    @Override
    public void visit(Solid solid) {
        this.visit((AbstractSolid)solid);
        if (solid.isSetExterior()) {
            this.visit(solid.getExterior());
        }
        if (solid.isSetInterior()) {
            for (SurfaceProperty interior : new ArrayList<SurfaceProperty>(solid.getInterior())) {
                this.visit(interior);
            }
        }
    }

    @Override
    public void visit(Surface surface) {
        this.visit((AbstractSurface)surface);
        if (surface.isSetPatches()) {
            this.visit(surface.getPatches());
        }
    }

    @Override
    public void visit(Tin tin) {
        this.visit((TriangulatedSurface)tin);
    }

    @Override
    public void visit(TriangulatedSurface triangulatedSurface) {
        this.visit((Surface)triangulatedSurface);
    }

    public void visit(ImplicitGeometry implicitGeometry) {
    }

    public <T extends AbstractGML> void visit(AssociationByRepOrRef<T> association) {
        if (this.shouldWalk) {
            if (association.getObject() instanceof AbstractGeometry) {
                ((AbstractGeometry)association.getObject()).accept(this);
            } else if (association.getObject() instanceof ImplicitGeometry) {
                this.visit((ImplicitGeometry)association.getObject());
            }
        }
    }

    public <T extends AbstractGeometry> void visit(GeometryProperty<T> geometryProperty) {
        if (geometryProperty.isSetGeometry() && this.shouldWalk) {
            ((AbstractGeometry)geometryProperty.getGeometry()).accept(this);
        }
    }

    public <T extends AbstractGeometry> void visit(InlineGeometryProperty<T> geometryProperty) {
        if (geometryProperty.isSetGeometry() && this.shouldWalk) {
            ((AbstractGeometry)geometryProperty.getGeometry()).accept(this);
        }
    }

    public <T extends AbstractGeometry> void visit(GeometryArrayProperty<T> geometryArrayProperty) {
        if (geometryArrayProperty.isSetGeometry()) {
            for (AbstractGeometry abstractGeometry : new ArrayList<T>(geometryArrayProperty.getGeometry())) {
                if (!this.shouldWalk) continue;
                abstractGeometry.accept(this);
            }
        }
    }

    public void visit(SurfacePatchArrayProperty surfacePatchArrayProperty) {
        if (surfacePatchArrayProperty.isSetSurfacePatch()) {
            for (AbstractSurfacePatch abstractSurfacePatch : new ArrayList<AbstractSurfacePatch>(surfacePatchArrayProperty.getSurfacePatch())) {
                if (!this.shouldWalk) continue;
                if (abstractSurfacePatch instanceof Triangle) {
                    this.visit((Triangle)abstractSurfacePatch);
                    continue;
                }
                if (abstractSurfacePatch instanceof Rectangle) {
                    this.visit((Rectangle)abstractSurfacePatch);
                    continue;
                }
                if (!(abstractSurfacePatch instanceof PolygonPatch)) continue;
                this.visit((PolygonPatch)abstractSurfacePatch);
            }
        }
    }
}

