/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.util.xml;

import org.citygml4j.util.xml.ArrayBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXEventBuffer
implements ContentHandler {
    private final String END_PREFIX_MAPPING = "END_PREFIX_MAPPING";
    private final Byte UNDEFINED = 0;
    private final Byte START_DOCUMENT = 1;
    private final Byte END_DOCUMENT = 2;
    private final Byte START_ELEMENT = 3;
    private final Byte END_ELEMENT = 4;
    private final Byte QUALIFIED_END_ELEMENT = 5;
    private final Byte CHARACTERS = 6;
    private final Byte NAMESPACE_PREFIX_MAPPING = 7;
    private final Byte ATTRIBUTE = 8;
    private ArrayBuffer<String> stringBuffer;
    private ArrayBuffer<char[]> charactersBuffer;
    private ArrayBuffer<Byte> eventBuffer;
    private ArrayBuffer<String> tmpBuffer;
    private AttributesImpl atts;
    private Byte previousElement = this.UNDEFINED;

    public SAXEventBuffer() {
        this.stringBuffer = new ArrayBuffer<String>(String.class);
        this.charactersBuffer = new ArrayBuffer<char[]>(char[].class);
        this.eventBuffer = new ArrayBuffer<Byte>(Byte.class);
    }

    public void reset() {
        this.stringBuffer = new ArrayBuffer<String>(String.class);
        this.charactersBuffer = new ArrayBuffer<char[]>(char[].class);
        this.eventBuffer = new ArrayBuffer<Byte>(Byte.class);
        this.tmpBuffer = null;
        this.atts = null;
        this.previousElement = this.UNDEFINED;
    }

    public boolean isEmpty() {
        return this.eventBuffer.currentPtr() == 0 && this.eventBuffer.previousBuffer() == null;
    }

    public void removeTrailingCharacters() {
        while (this.eventBuffer.peek() == this.CHARACTERS) {
            this.popEvent();
            this.popCharacters();
        }
    }

    public void addCharacters(char[] ch) {
        if (this.previousElement == this.START_ELEMENT) {
            this.pushEvent(this.CHARACTERS);
            this.pushCharacters(ch);
        }
    }

    public void addStartElement(String uri, String localName, String prefix) {
        if (this.previousElement == this.START_ELEMENT) {
            this.removeTrailingCharacters();
        }
        this.pushEvent(this.START_ELEMENT);
        this.pushString(uri);
        this.pushString(localName);
        this.pushString(prefix);
        this.previousElement = this.START_ELEMENT;
    }

    public void addEndElement() {
        if (this.previousElement == this.END_ELEMENT) {
            this.removeTrailingCharacters();
        }
        this.pushEvent(this.END_ELEMENT);
        this.previousElement = this.END_ELEMENT;
    }

    public void addEndElement(String uri, String localName) {
        if (this.previousElement == this.END_ELEMENT) {
            this.removeTrailingCharacters();
        }
        this.pushEvent(this.QUALIFIED_END_ELEMENT);
        this.pushString(uri);
        this.pushString(localName);
        this.previousElement = this.END_ELEMENT;
    }

    public void addNamespacePrefixMapping(String uri, String prefix) {
        this.pushEvent(this.NAMESPACE_PREFIX_MAPPING);
        this.pushString(uri);
        this.pushString(prefix);
    }

    public void addAttribute(String uri, String localName, String prefix, String type, String value) {
        this.pushEvent(this.ATTRIBUTE);
        this.pushString(uri);
        this.pushString(localName);
        this.pushString(prefix);
        this.pushString(type);
        this.pushString(value);
    }

    public void addStartDocument() {
        this.pushEvent(this.START_DOCUMENT);
    }

    public void addEndDocument() {
        this.pushEvent(this.END_DOCUMENT);
    }

    public void send(ContentHandler handler, boolean release) throws SAXException {
        if (this.isEmpty()) {
            throw new IllegalStateException("buffer is empty.");
        }
        this.eventBuffer = this.eventBuffer.rewindToHeadBuffer();
        this.stringBuffer = this.stringBuffer.rewindToHeadBuffer();
        this.charactersBuffer = this.charactersBuffer.rewindToHeadBuffer();
        this.tmpBuffer = new ArrayBuffer<String>(String.class);
        this.atts = new AttributesImpl();
        Byte currentEvent = null;
        while (this.eventBuffer.peek() != null) {
            currentEvent = this.nextEvent(release);
            if (currentEvent == this.START_ELEMENT) {
                this.sendStartElement(handler, release);
                continue;
            }
            if (currentEvent == this.END_ELEMENT) {
                this.sendEndElement(handler);
                continue;
            }
            if (currentEvent == this.CHARACTERS) {
                this.sendCharacters(handler, release);
                continue;
            }
            if (currentEvent == this.NAMESPACE_PREFIX_MAPPING) {
                this.sendStartPrefixMapping(handler, release);
                continue;
            }
            if (currentEvent == this.START_DOCUMENT) {
                handler.startDocument();
                continue;
            }
            if (currentEvent == this.END_DOCUMENT) {
                handler.endDocument();
                continue;
            }
            if (currentEvent != this.QUALIFIED_END_ELEMENT) continue;
            this.sendQualifiedEndElement(handler, release);
        }
        this.eventBuffer.decrementPtr();
        this.stringBuffer.decrementPtr();
        this.charactersBuffer.decrementPtr();
        if (release) {
            this.reset();
        }
    }

    private void sendCharacters(ContentHandler handler, boolean release) throws SAXException {
        char[] ch = this.nextCharacters(release);
        handler.characters(ch, 0, ch.length);
    }

    private void sendStartPrefixMapping(ContentHandler handler, boolean release) throws SAXException {
        String nsUri = this.nextString(release);
        String nsPrefix = this.nextString(release);
        if (nsPrefix == null) {
            nsPrefix = "";
        }
        handler.startPrefixMapping(nsPrefix, nsUri);
        this.pushTmpString(nsPrefix);
        this.pushTmpString("END_PREFIX_MAPPING");
    }

    private void sendStartElement(ContentHandler handler, boolean release) throws SAXException {
        String elementQName;
        String elementUri = this.nextString(release);
        String elementLocalName = this.nextString(release);
        String elementPrefix = this.nextString(release);
        String string = elementQName = elementPrefix == null || elementPrefix.length() == 0 ? elementLocalName : new StringBuffer(elementPrefix).append(':').append(elementLocalName).toString();
        if (this.eventBuffer.peek() == this.ATTRIBUTE) {
            do {
                String attrQName;
                this.nextEvent(release);
                String attrUri = this.nextString(release);
                String attrLocalName = this.nextString(release);
                String attrPrefix = this.nextString(release);
                String attrType = this.nextString(release);
                String attrValue = this.nextString(release);
                String string2 = attrQName = attrPrefix == null || attrPrefix.length() == 0 ? attrLocalName : new StringBuffer(attrPrefix).append(':').append(attrLocalName).toString();
                if (attrUri == null) {
                    attrUri = "";
                }
                this.atts.addAttribute(attrUri, attrLocalName, attrQName, attrType, attrValue);
            } while (this.eventBuffer.peek() == this.ATTRIBUTE);
        }
        this.pushTmpString(elementUri);
        this.pushTmpString(elementLocalName);
        this.pushTmpString(elementPrefix);
        handler.startElement(elementUri, elementLocalName, elementQName, this.atts);
        this.atts.clear();
    }

    private void sendEndElement(ContentHandler handler) throws SAXException {
        String elementPrefix = this.popTmpString();
        String elementLocalName = this.popTmpString();
        String elementUri = this.popTmpString();
        String elementQName = elementPrefix == null ? elementLocalName : new StringBuffer(elementPrefix).append(':').append(elementLocalName).toString();
        handler.endElement(elementUri, elementLocalName, elementQName);
        if (this.tmpBuffer.peek() == "END_PREFIX_MAPPING") {
            do {
                this.popTmpString();
                String nsPrefix = this.popTmpString();
                handler.endPrefixMapping(nsPrefix);
            } while (this.tmpBuffer.peek() == "END_PREFIX_MAPPING");
        }
    }

    private void sendQualifiedEndElement(ContentHandler handler, boolean release) throws SAXException {
        String elementUri = this.nextString(release);
        String elementLocalName = this.nextString(release);
        handler.endElement(elementUri, elementLocalName, elementLocalName);
        if (this.tmpBuffer.peek() == "END_PREFIX_MAPPING") {
            do {
                this.popTmpString();
                String nsPrefix = this.popTmpString();
                handler.endPrefixMapping(nsPrefix);
            } while (this.tmpBuffer.peek() == "END_PREFIX_MAPPING");
        }
    }

    private void pushEvent(byte event) {
        this.eventBuffer.push(event);
        if (this.eventBuffer.currentPtr() == this.eventBuffer.size()) {
            this.eventBuffer = this.eventBuffer.appendBuffer();
        }
    }

    private void pushCharacters(char[] ch) {
        this.charactersBuffer.push(ch);
        if (this.charactersBuffer.currentPtr() == this.charactersBuffer.size()) {
            this.charactersBuffer = this.charactersBuffer.appendBuffer();
        }
    }

    private void pushString(String s) {
        this.stringBuffer.push(s);
        if (this.stringBuffer.currentPtr() == this.stringBuffer.size()) {
            this.stringBuffer = this.stringBuffer.appendBuffer();
        }
    }

    private void pushTmpString(String s) {
        this.tmpBuffer.push(s);
        if (this.tmpBuffer.currentPtr() == this.tmpBuffer.size()) {
            this.tmpBuffer = this.tmpBuffer.appendBuffer();
        }
    }

    private void popEvent() {
        if (this.eventBuffer.currentPtr() == 0) {
            this.eventBuffer = this.eventBuffer.dropBuffer();
        }
        this.eventBuffer.pop();
    }

    private void popCharacters() {
        if (this.charactersBuffer.currentPtr() == 0) {
            this.charactersBuffer = this.charactersBuffer.dropBuffer();
        }
        this.charactersBuffer.pop();
    }

    private String popTmpString() {
        if (this.tmpBuffer.currentPtr() == 0) {
            this.tmpBuffer = this.tmpBuffer.dropBuffer();
        }
        return this.tmpBuffer.pop();
    }

    private Byte nextEvent(boolean release) {
        Byte event = this.eventBuffer.next(release);
        if (this.eventBuffer.currentPtr() > this.eventBuffer.size() && this.eventBuffer.nextBuffer() != null) {
            this.eventBuffer = this.eventBuffer.nextBuffer();
            if (release) {
                this.eventBuffer.dropPreviousBuffer();
            }
        }
        return event;
    }

    private String nextString(boolean release) {
        String s = this.stringBuffer.next(release);
        if (this.stringBuffer.currentPtr() > this.stringBuffer.size() && this.stringBuffer.nextBuffer() != null) {
            this.stringBuffer = this.stringBuffer.nextBuffer();
            if (release) {
                this.stringBuffer.dropPreviousBuffer();
            }
        }
        return s;
    }

    private char[] nextCharacters(boolean release) {
        char[] ch = this.charactersBuffer.next(release);
        if (this.charactersBuffer.currentPtr() > this.charactersBuffer.size() && this.charactersBuffer.nextBuffer() != null) {
            this.charactersBuffer = this.charactersBuffer.nextBuffer();
            if (release) {
                this.charactersBuffer.dropPreviousBuffer();
            }
        }
        return ch;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] tmp = new char[length];
        System.arraycopy(ch, start, tmp, 0, length);
        this.addCharacters(tmp);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.addStartDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.addStartElement(uri, localName, null);
        for (int i = 0; i < atts.getLength(); ++i) {
            this.addAttribute(atts.getURI(i), atts.getLocalName(i), null, atts.getType(i), atts.getValue(i));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.addNamespacePrefixMapping(uri, prefix);
    }

    @Override
    public void endDocument() throws SAXException {
        this.addEndDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.addEndElement();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }
}

