/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.citygml.CityGMLVersion;

public class CityGMLNamespaceContext
implements NamespaceContext {
    private HashMap<String, String> namespaces = new HashMap();

    public void setPrefix(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException("namespace prefix may not be null.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        Iterator<Map.Entry<String, String>> iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getValue().equals(prefix)) continue;
            iter.remove();
            break;
        }
        this.namespaces.put(uri, prefix);
    }

    public void setDefaultNamespace(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        if (!namespaceURI.equals("")) {
            this.setPrefix("", namespaceURI);
        }
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        if (namespaceURI.equals("")) {
            return "";
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return this.namespaces.get(namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String tmp;
        if (prefix == null) {
            throw new IllegalArgumentException("namespace prefix may not be null.");
        }
        if (prefix.equals("") && (tmp = this.namespaces.get(prefix)) != null) {
            return tmp;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(prefix)) continue;
            return entry.getKey();
        }
        return "";
    }

    public Iterator<String> getPrefixes() {
        return this.namespaces.values().iterator();
    }

    public boolean containsPrefix(String prefix) {
        return this.namespaces.containsValue(prefix);
    }

    public Iterator<String> getNamespaceURIs() {
        return this.namespaces.keySet().iterator();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespace URI may not be null.");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add("xml");
            return prefixes.iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            ArrayList<String> prefixes = new ArrayList<String>();
            prefixes.add("xmlns");
            return prefixes.iterator();
        }
        return this.namespaces.values().iterator();
    }

    public void reset() {
        this.namespaces.clear();
    }

    public boolean isEmpty() {
        return this.namespaces.isEmpty();
    }

    public void setDefaultNamespace(Module module) {
        this.setDefaultNamespace(module.getNamespaceURI());
    }

    public void setPrefix(Module module) {
        this.setPrefix(module.getNamespacePrefix(), module.getNamespaceURI());
    }

    public void setPrefixes(CityGMLVersion version) {
        for (Module module : version.getModules()) {
            this.setPrefix(module);
        }
    }

    public void setPrefixes(ModuleContext moduleContext) {
        for (Module module : moduleContext.getModules()) {
            this.setPrefix(module);
        }
    }
}

