/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opengis.cite.citygml20.CommonFixture;
import org.opengis.cite.citygml20.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AppearanceModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.2 Appearance module")
    public void verifyAppearanceModule() {
        String value;
        Element n;
        int i;
        String moduleName = "Appearance";
        String SchemaPath = "xsd/opengis/citygml/appearance/2.0/appearance.xsd";
        if (!this.docNameSpace.contains(SchemaPath)) {
            throw new SkipException("Not " + moduleName + " module.");
        }
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        LinkedHashSet<String> targetSet = new LinkedHashSet<String>();
        String expressionPath = "//*[@gml:id]";
        NodeList nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            n = (Element)nodes.item(i);
            value = n.getAttribute("gml:id");
            idSet.add(value);
        }
        expressionPath = "//app:textureCoordinates[@ring]";
        nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            n = (Element)nodes.item(i);
            value = n.getAttribute("ring").substring(1);
            targetSet.add(value);
        }
        boolean state = idSet.containsAll(targetSet);
        Assert.assertTrue(state, "TextureCoordinates's attribute(ring) reference invalid.");
        targetSet.clear();
        expressionPath = "//app:GeoreferencedTexture/app:target/text()";
        nodes = XMLUtils.getNodeListByXPath(this.testSubject, expressionPath);
        for (i = 0; i < nodes.getLength(); ++i) {
            String value2 = nodes.item(i).getNodeValue().substring(1);
            targetSet.add(value2);
        }
        state = idSet.containsAll(targetSet);
        Assert.assertTrue(state, "GeoreferencedTexture's node(app:target) reference invalid.");
    }
}

