/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.citygml20.module;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.opengis.cite.citygml20.CommonFixture;
import org.opengis.cite.citygml20.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CityObjectGroupModuleValidation
extends CommonFixture {
    public ArrayList<String> docNameSpace;

    @BeforeClass
    public void collectNamespace() {
        this.docNameSpace = this.GetToValidateXsdPathArrayList(this.testSubject);
    }

    @Test(enabled=true, description="B.2.6 CityObjectGroup module")
    public void verifyCityObjectGroupModule() throws Exception {
        String moduleName = "CityObjectGroup";
        String SchemaPath = "xsd/opengis/citygml/cityobjectgroup/2.0/cityObjectGroup.xsd";
        if (!this.docNameSpace.contains(SchemaPath)) {
            throw new SkipException("Not " + moduleName + " module.");
        }
        boolean cyclingState = true;
        String cityObjectGroupExpression = "//grp:CityObjectGroup[@gml:id]/grp:groupMember";
        XPath xpath2 = XMLUtils.getXPathWithNS(this.testSubject);
        NodeList nodes = (NodeList)xpath2.evaluate(cityObjectGroupExpression, this.testSubject, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeEl = (Element)nodes.item(i);
            Element parentEl = (Element)nodeEl.getParentNode();
            String parentId = parentEl.getAttribute("gml:id");
            String expr = "grp:CityObjectGroup";
            NodeList groupList = (NodeList)xpath2.evaluate(expr, nodeEl, XPathConstants.NODESET);
            int a = groupList.getLength();
            for (int j = 0; j < groupList.getLength(); ++j) {
                Element node = (Element)groupList.item(i);
                String childId = node.getAttribute("gml:id");
                if (!childId.equals(parentId)) continue;
                cyclingState = false;
            }
        }
        Assert.assertTrue(cyclingState, "No cyclic groupings shall be included within a CityGML instance document.");
    }
}

