/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SchematronValidator {
    private static final Logger LOGR = Logger.getLogger(SchematronValidator.class.getPackage().getName());
    public static final String ISO_SCHEMATRON_SVRL_NS = "http://purl.oclc.org/dsdl/svrl";
    private static final String INCLUDE_XSLT = "iso_dsdl_include.xsl";
    private static final String ABSTRACT_EXPAND_XSLT = "iso_abstract_expand.xsl";
    private static final String SVRL_REPORT_XSLT = "iso_svrl_xslt2.xsl";
    private Processor processor;
    private XsltTransformer transformer;
    private int totalRuleViolations = 0;

    public SchematronValidator(Source schema) throws Exception {
        this(schema, null);
    }

    public SchematronValidator(Source schema, String phase) throws Exception {
        if (schema == null) {
            throw new IllegalArgumentException("No schema Source provided.");
        }
        this.processor = new Processor(false);
        this.processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", 0);
        XsltExecutable xslt = this.compileSchema(schema, phase);
        this.transformer = xslt.load();
    }

    public ValidationErrorHandler validateSchema(Source schema) throws IOException {
        RelaxNGValidator rngValidator;
        try {
            rngValidator = new RelaxNGValidator(this.getClass().getResource("rnc/schematron-grammar.rnc"));
            rngValidator.validate(schema);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return rngValidator.getErrorHandler();
    }

    public int getRuleViolationCount() {
        return this.totalRuleViolations;
    }

    public boolean ruleViolationsDetected() {
        return this.totalRuleViolations > 0;
    }

    public void setParameters(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            this.transformer.setParameter(new QName(paramName), new XdmAtomicValue(paramValue));
        }
    }

    public Result validate(Source xmlSource) {
        return this.validate(xmlSource, true);
    }

    public Result validate(Source xmlSource, boolean svrlReport) {
        Node node;
        if (xmlSource == null) {
            throw new IllegalArgumentException("Nothing to validate.");
        }
        if (DOMSource.class.isInstance(xmlSource) && (node = ((DOMSource)DOMSource.class.cast(xmlSource)).getNode()).getNodeType() == 1) {
            Document doc = this.importElement((Element)node);
            xmlSource = new DOMSource(doc, xmlSource.getSystemId());
        }
        this.totalRuleViolations = 0;
        XdmDestination results = new XdmDestination();
        try {
            this.transformer.setSource(xmlSource);
            this.transformer.setDestination(results);
            this.transformer.transform();
        }
        catch (SaxonApiException e1) {
            LOGR.warning(e1.getMessage());
        }
        this.totalRuleViolations = this.countRuleViolations(results);
        if (LOGR.isLoggable(Level.FINER)) {
            LOGR.log(Level.FINER, "{0} Schematron rule violations found", this.totalRuleViolations);
            this.writeResultsToTempFile(results);
        }
        NodeInfo nodeInfo = results.getXdmNode().getUnderlyingNode();
        Result result = null;
        result = svrlReport ? new DOMResult(NodeOverNodeInfo.wrap(nodeInfo)) : this.generateTextResult(results.getXdmNode().asSource());
        return result;
    }

    StreamResult generateTextResult(Source svrlSource) {
        XsltCompiler compiler = this.processor.newXsltCompiler();
        StreamResult result = null;
        try {
            XsltExecutable exec = compiler.compile(new StreamSource(this.getClass().getResourceAsStream("svrl2text.xsl")));
            XsltTransformer transformer = exec.load();
            transformer.setSource(svrlSource);
            Serializer serializer = new Serializer();
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            serializer.setOutputStream(bos);
            transformer.setDestination(serializer);
            transformer.transform();
            result = new StreamResult(bos);
        }
        catch (SaxonApiException e) {
            LOGR.warning(e.getMessage());
        }
        return result;
    }

    final XsltExecutable compileSchema(Source schema, String phase) throws Exception {
        XsltCompiler compiler = this.processor.newXsltCompiler();
        CatalogManager manager = new CatalogManager("org/opengis/cite/validation/CatalogManager.properties");
        compiler.setURIResolver(new CatalogResolver(manager));
        XsltExecutable includeXslt = compiler.compile(new StreamSource(SchematronValidator.class.getResourceAsStream(INCLUDE_XSLT)));
        XsltExecutable abstractXslt = compiler.compile(new StreamSource(SchematronValidator.class.getResourceAsStream(ABSTRACT_EXPAND_XSLT)));
        XsltExecutable svrlXslt = compiler.compile(new StreamSource(SchematronValidator.class.getResourceAsStream(SVRL_REPORT_XSLT)));
        XsltTransformer stage1Transformer = includeXslt.load();
        XsltTransformer stage2Transformer = abstractXslt.load();
        XsltTransformer stage3Transformer = svrlXslt.load();
        stage1Transformer.setSource(schema);
        stage1Transformer.setDestination(stage2Transformer);
        stage2Transformer.setDestination(stage3Transformer);
        XdmDestination chainResult = new XdmDestination();
        stage3Transformer.setDestination(chainResult);
        if (null != phase && !phase.isEmpty()) {
            stage3Transformer.setParameter(new QName("phase"), new XdmAtomicValue(phase));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream console = System.err;
        try {
            System.setErr(new PrintStream(baos));
            stage1Transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new Exception(baos.toString() + e.getMessage(), e.getCause());
        }
        finally {
            System.setErr(console);
        }
        XsltExecutable compiledStylesheet = compiler.compile(chainResult.getXdmNode().asSource());
        return compiledStylesheet;
    }

    private void writeResultsToTempFile(XdmDestination xdmResult) {
        File temp = null;
        try {
            temp = File.createTempFile("SchematronValidator-dump-", ".xml");
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(xdmResult.getXdmNode().toString());
            out.close();
        }
        catch (IOException e) {
            LOGR.warning(e.getMessage());
        }
        if (temp.exists()) {
            LOGR.log(Level.FINER, "Dumped Schematron results to {0}", temp.getAbsolutePath());
        }
    }

    private int countRuleViolations(XdmDestination results) {
        XPathCompiler xpath2 = this.processor.newXPathCompiler();
        xpath2.declareNamespace("svrl", ISO_SCHEMATRON_SVRL_NS);
        XdmAtomicValue totalCount = null;
        try {
            XPathExecutable exe = xpath2.compile("count(//svrl:failed-assert) + count(//svrl:successful-report)");
            XPathSelector selector = exe.load();
            selector.setContextItem(results.getXdmNode());
            totalCount = (XdmAtomicValue)selector.evaluateSingle();
        }
        catch (SaxonApiException e) {
            LOGR.warning(e.getMessage());
        }
        return Integer.parseInt(totalCount.getValue().toString());
    }

    Document importElement(Element elem) {
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOGR.log(Level.WARNING, null, ex);
        }
        Document newDoc = docBuilder.newDocument();
        Node newNode = newDoc.importNode(elem, true);
        newDoc.appendChild(newNode);
        return newDoc;
    }
}

