/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class DependencyMap {
    private ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m : methods) {
            this.m_dependencies.put(m.getRealClass().getName() + "." + m.getMethodName(), m);
            for (String g : m.getGroups()) {
                this.m_groups.put(g, m);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group2, ITestNGMethod fromMethod) {
        Set uniqueKeys = this.m_groups.keySet();
        List<ITestNGMethod> result = Lists.newArrayList();
        for (String k : uniqueKeys) {
            List temp;
            if (!Pattern.matches(group2, k) || (temp = (List)this.m_groups.get(k)) == null) continue;
            result.addAll((Collection<ITestNGMethod>)this.m_groups.get(k));
        }
        if (result.isEmpty() && !fromMethod.ignoreMissingDependencies()) {
            throw new TestNGException("DependencyMap::Method \"" + fromMethod + "\" depends on nonexistent group \"" + group2 + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List l = (List)this.m_dependencies.get(methodName);
        if (l == null && fromMethod.ignoreMissingDependencies()) {
            return fromMethod;
        }
        if (l != null) {
            for (ITestNGMethod m : l) {
                if (fromMethod.getRealClass().isAssignableFrom(m.getRealClass())) {
                    if (m.getInstance() != fromMethod.getInstance()) continue;
                    return m;
                }
                return m;
            }
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }
}

