/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IParameterizable;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ArrayIterator;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderHolder;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.Nullable;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Parameters {
    public static final String NULL_VALUE = "null";

    public static Object[] createInstantiationParameters(Constructor ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParameters(ctor.toString(), ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, finder, parameterNames, new MethodParameters(params, Collections.emptyMap()), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, Object[] parameterValues, @Nullable ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx, ITestResult testResult) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getMethod() : null;
        Map<String, String> methodParams = currentTestMethod != null ? currentTestMethod.findMethodParameters(ctx.getCurrentXmlTest()) : Collections.emptyMap();
        return Parameters.createParameters(m, new MethodParameters(params, methodParams, parameterValues, currentTestMeth, ctx, testResult), finder, xmlSuite, IConfigurationAnnotation.class, "@Configuration");
    }

    public static Object getInjectedParameter(Class<?> c, Method method, ITestContext context, ITestResult testResult) {
        Object result = null;
        if (Method.class.equals(c)) {
            result = method;
        } else if (ITestContext.class.equals(c)) {
            result = context;
        } else if (XmlTest.class.equals(c)) {
            result = context.getCurrentXmlTest();
        } else if (ITestResult.class.equals(c)) {
            result = testResult;
        }
        return result;
    }

    private static Object[] createParameters(String methodName, Class[] parameterTypes, String[] optionalValues, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Object[] result = new Object[]{};
        if (parameterTypes.length > 0) {
            List vResult = Lists.newArrayList();
            Parameters.checkParameterTypes(methodName, parameterTypes, methodAnnotation, parameterNames);
            int j = 0;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object inject = Parameters.getInjectedParameter(parameterTypes[i], params.currentTestMethod, params.context, params.testResult);
                if (inject != null) {
                    vResult.add(inject);
                    continue;
                }
                if (j >= parameterNames.length) continue;
                String p = parameterNames[j];
                String value = (String)params.xmlParameters.get(p);
                if (null == value) {
                    value = System.getProperty(p);
                }
                if (null == value) {
                    if (optionalValues != null) {
                        value = optionalValues[i];
                    }
                    if (null == value) {
                        throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on method " + methodName + " but has not been marked @Optional or defined\n" + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                    }
                }
                vResult.add(Parameters.convertType(parameterTypes[i], value, p));
                ++j;
            }
            result = vResult.toArray(new Object[vResult.size()]);
        }
        return result;
    }

    private static void checkParameterTypes(String methodName, Class[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        int totalLength = parameterTypes.length;
        HashSet<Class> injectedTypes = new HashSet<Class>(){
            private static final long serialVersionUID = -5324894581793435812L;
            {
                this.add(ITestContext.class);
                this.add(ITestResult.class);
                this.add(XmlTest.class);
                this.add(Method.class);
                this.add(Object[].class);
            }
        };
        for (Class parameterType : parameterTypes) {
            if (!injectedTypes.contains(parameterType)) continue;
            --totalLength;
        }
        if (parameterNames.length != totalLength) {
            throw new TestNGException("Method " + methodName + " requires " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
        }
    }

    public static Object convertType(Class type, String value, String paramName) {
        Object result = null;
        if (NULL_VALUE.equals(value.toLowerCase())) {
            if (type.isPrimitive()) {
                Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
            }
            return null;
        }
        if (type == String.class) {
            result = value;
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = Integer.parseInt(value);
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            result = Boolean.valueOf(value);
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = Byte.parseByte(value);
        } else if (type == Character.TYPE || type == Character.class) {
            result = Character.valueOf(value.charAt(0));
        } else if (type == Double.TYPE || type == Double.class) {
            result = Double.parseDouble(value);
        } else if (type == Float.TYPE || type == Float.class) {
            result = Float.valueOf(Float.parseFloat(value));
        } else if (type == Long.TYPE || type == Long.class) {
            result = Long.parseLong(value);
        } else if (type == Short.TYPE || type == Short.class) {
            result = Short.parseShort(value);
        } else if (type.isEnum()) {
            result = Enum.valueOf(type, value);
        } else assert (false) : "Unsupported type parameter : " + type;
        return result;
    }

    private static DataProviderHolder findDataProvider(Object instance, ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder, ITestContext context) {
        DataProviderHolder result = null;
        IDataProvidable dp = Parameters.findDataProviderInfo(clazz, m, finder);
        if (dp != null) {
            String dataProviderName = dp.getDataProvider();
            Class<?> dataProviderClass = dp.getDataProviderClass();
            if (!Utils.isStringEmpty(dataProviderName) && null == (result = Parameters.findDataProvider(instance, clazz, finder, dataProviderName, dataProviderClass, context))) {
                throw new TestNGException("Method " + m + " requires a @DataProvider named : " + dataProviderName + (dataProviderClass != null ? " in class " + dataProviderClass.getName() : ""));
            }
        }
        return result;
    }

    private static IDataProvidable findDataProviderInfo(ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder) {
        IDataProvidable result;
        if (m.getMethod() != null) {
            result = AnnotationHelper.findTest(finder, m.getMethod());
            if (result == null) {
                result = AnnotationHelper.findFactory(finder, m.getMethod());
            }
            if (result == null) {
                result = AnnotationHelper.findTest(finder, clazz.getRealClass());
            }
        } else {
            result = AnnotationHelper.findFactory(finder, m.getConstructor());
        }
        return result;
    }

    private static DataProviderHolder findDataProvider(Object instance, ITestClass clazz, IAnnotationFinder finder, String name, Class dataProviderClass, ITestContext context) {
        DataProviderHolder result = null;
        Class cls = clazz.getRealClass();
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            Injector injector;
            IDataProviderAnnotation dp = finder.findAnnotation(m, IDataProviderAnnotation.class);
            if (null == dp || !name.equals(Parameters.getDataProviderName(dp, m))) continue;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0 && (injector = context.getInjector(clazz)) != null) {
                instance = injector.getInstance(dataProviderClass);
            }
            if (result != null) {
                throw new TestNGException("Found two providers called '" + name + "' on " + cls);
            }
            result = new DataProviderHolder(dp, m, instance);
        }
        return result;
    }

    private static String getDataProviderName(IDataProviderAnnotation dp, Method m) {
        return Strings.isNullOrEmpty(dp.getName()) ? m.getName() : dp.getName();
    }

    private static Object[] createParameters(Method m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class annotationClass, String atName) {
        Object[] extraParameters;
        List result = Lists.newArrayList();
        IParametersAnnotation annotation2 = finder.findAnnotation(m, IParametersAnnotation.class);
        Class[] types = m.getParameterTypes();
        if (null != annotation2) {
            String[] parameterNames = annotation2.getValue();
            extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
        } else {
            IParameterizable a = (IParameterizable)finder.findAnnotation(m, annotationClass);
            if (null != a && a.getParameters().length > 0) {
                String[] parameterNames = a.getParameters();
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, parameterNames, params, xmlSuite);
            } else {
                extraParameters = Parameters.createParameters(m.getName(), types, finder.findOptionalValues(m), atName, finder, new String[0], params, xmlSuite);
            }
        }
        Collections.addAll(result, extraParameters);
        for (int i = 0; i < types.length; ++i) {
            if (!Object[].class.equals((Object)types[i])) continue;
            result.add(i, params.parameterValues);
        }
        return result.toArray(new Object[result.size()]);
    }

    public static ParameterHolder handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance) {
        ParameterHolder result;
        DataProviderHolder dataProviderHolder = Parameters.findDataProvider(instance, testMethod.getTestClass(), testMethod.getConstructorOrMethod(), annotationFinder, methodParams.context);
        if (null != dataProviderHolder) {
            int parameterCount = testMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            Iterator<Object[]> parameters = MethodInvocationHelper.invokeDataProvider(dataProviderHolder.instance, dataProviderHolder.method, testMethod, methodParams.context, fedInstance, annotationFinder);
            Iterator<Object[]> filteredParameters = Parameters.filterParameters(parameters, testMethod.getInvocationNumbers());
            result = new ParameterHolder(filteredParameters, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, dataProviderHolder);
        } else {
            allParameterNames.putAll(methodParams.xmlParameters);
            Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getMethod(), methodParams, annotationFinder, xmlSuite, ITestAnnotation.class, "@Test")};
            testMethod.setParameterInvocationCount(allParameterValuesArray.length);
            Iterator<Object[]> parameters = MethodHelper.createArrayIterator(allParameterValuesArray);
            result = new ParameterHolder(parameters, ParameterHolder.ParameterOrigin.ORIGIN_XML, null);
        }
        return result;
    }

    private static Iterator<Object[]> filterParameters(Iterator<Object[]> parameters, List<Integer> list) {
        if (list.isEmpty()) {
            return parameters;
        }
        List result = Lists.newArrayList();
        int i = 0;
        while (parameters.hasNext()) {
            Object[] next = parameters.next();
            if (list.contains(i)) {
                result.add(next);
            }
            ++i;
        }
        return new ArrayIterator((Object[][])result.toArray((T[])new Object[list.size()][]));
    }

    private static void ppp(String s) {
        System.out.println("[Parameters] " + s);
    }

    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        public ITestResult testResult;

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams) {
            this(params, methodParams, null, null, null, null);
        }

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams, Method m) {
            this(params, methodParams, null, m, null, null);
        }

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams, Object[] pv, Method m, ITestContext ctx, ITestResult tr) {
            Map<String, String> allParams = Maps.newHashMap();
            allParams.putAll(params);
            allParams.putAll(methodParams);
            this.xmlParameters = allParams;
            this.currentTestMethod = m;
            this.context = ctx;
            this.parameterValues = pv;
            this.testResult = tr;
        }
    }
}

