/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.config;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.config.TEBaseNotFoundException;
import com.occamlab.te.config.TEConfigException;
import com.occamlab.te.util.XMLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigFileCreator {
    private static Logger LOGR = Logger.getLogger("com.occamlab.te.web.ConfigFileCreator");
    private DocumentBuilder builder;
    private Document docMain;
    private Element config;
    private Element scripts;

    public ConfigFileCreator() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setExpandEntityReferences(false);
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void create(String tebase) throws TEConfigException {
        File f = new File(tebase);
        if (f.exists()) {
            try {
                this.process(tebase);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new TEBaseNotFoundException(tebase);
        }
    }

    public void create(File tebase) throws TEConfigException {
        this.create(tebase.toString() + File.separator);
    }

    private void deleteConfigFile(String tebase) {
        File f = new File(tebase + "config.xml");
        if (f.exists()) {
            f.delete();
            LOGR.info("Old config file removed " + f);
        } else {
            LOGR.info("Config file not removed, since there was no file at " + f);
        }
    }

    private void process(String tebase) {
        this.deleteConfigFile(tebase);
        this.docMain = this.builder.newDocument();
        this.config = this.docMain.createElement("config");
        this.docMain.appendChild(this.config);
        this.scripts = this.docMain.createElement("scripts");
        this.config.appendChild(this.scripts);
        String scriptsDir = tebase + "scripts";
        LOGR.info("Scripts directory found at " + scriptsDir);
        File[] testScriptsDir = new File(scriptsDir).listFiles();
        if (testScriptsDir != null) {
            for (File dir : testScriptsDir) {
                this.processDir(dir);
            }
        }
        String mainconfig = tebase + "config.xml";
        this.saveConfigFile(this.docMain, mainconfig);
    }

    public void processDir(File dir) {
        if (dir.isDirectory() && !dir.getName().startsWith(".")) {
            List<File> configFiles = this.getConfigFiles(dir);
            for (File file : configFiles) {
                this.processTestConfigFile(file);
            }
        }
    }

    private void processTestConfigFile(File configFile) {
        String configFilePath = null;
        Document docTest = null;
        if (configFile != null) {
            configFilePath = configFile.getAbsolutePath();
            docTest = this.getDocument(configFile);
        }
        if (docTest != null) {
            Node orgInTest = XMLUtils.getFirstNode(docTest, "/organization/name[1]");
            String org = orgInTest.getTextContent();
            String xpath2 = "/config/scripts/organization/name[text()='" + org + "']";
            Node orgInMainConfig = XMLUtils.getFirstNode(this.docMain, xpath2);
            if (orgInMainConfig == null) {
                Node orgInTestImported = this.docMain.importNode(orgInTest.getParentNode(), true);
                this.scripts.appendChild(orgInTestImported);
            } else {
                Node standardInTest = XMLUtils.getFirstNode(docTest, "/organization/standard[1]");
                String standardInTestName = XMLUtils.getFirstNode(docTest, "/organization/standard[1]/name").getTextContent();
                xpath2 = "/config/scripts/organization/standard/name[text()='" + standardInTestName + "']";
                Node standardInMain = XMLUtils.getFirstNode(this.docMain, xpath2);
                if (standardInMain == null) {
                    Node orgInMain = orgInMainConfig.getParentNode();
                    orgInMain.appendChild(this.docMain.importNode(standardInTest, true));
                } else {
                    Node versionInTest = XMLUtils.getFirstNode(docTest, "/organization/standard/version[1]");
                    standardInMain.getParentNode().appendChild(this.docMain.importNode(versionInTest, true));
                }
            }
            LOGR.config("Added " + configFile.getAbsolutePath() + " to config file");
        } else {
            LOGR.config("No config file was found in dir " + configFilePath + ". It was not registered in the main config file.");
        }
    }

    public void saveConfigFile(Document docMain, String mainconfig) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(docMain);
            StreamResult result = new StreamResult(new FileOutputStream(mainconfig));
            LOGR.info("SUCCESSFULLY created config.xml at " + mainconfig);
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception e) {
            LOGR.warning("The main config file was not created at " + mainconfig);
            e.printStackTrace();
        }
    }

    public Document getDocument(File xml) {
        try {
            Document doc = this.builder.parse(xml);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<File> getConfigFiles(File dir) {
        String[] extensions = new String[]{"xml"};
        ArrayList<File> configFiles = new ArrayList<File>();
        Collection<File> files = FileUtils.listFiles(dir, extensions, true);
        for (File file : files) {
            if (!file.getName().equals("config.xml")) continue;
            configFiles.add(file);
        }
        return configFiles;
    }

    public static void main(String[] args) throws Exception {
        new SetupOptions();
        new ConfigFileCreator().create(SetupOptions.getBaseConfigDirectory());
    }
}

