/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.TemplateEntry;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionEntry
extends TemplateEntry {
    boolean java;
    boolean initialized;
    String className;
    String method;
    int minArgs;
    int maxArgs;
    List<Node> classParams = null;

    FunctionEntry() {
    }

    FunctionEntry(Element function) {
        super(function);
        Element e;
        String type = function.getAttribute("type");
        if (type.equals("xsl")) {
            this.setJava(false);
        } else if (type.equals("java")) {
            this.setJava(true);
        } else {
            throw new RuntimeException("Invalid function type");
        }
        this.minArgs = 0;
        if (this.getParams() != null) {
            this.minArgs = this.getParams().size();
        }
        this.maxArgs = this.minArgs;
        NodeList nl = function.getElementsByTagName("var-params");
        if (nl.getLength() > 0) {
            String max;
            Element varParams = (Element)nl.item(0);
            String min2 = varParams.getAttribute("min");
            if (min2 != null) {
                this.minArgs += Integer.parseInt(min2);
            }
            if ((max = varParams.getAttribute("max")) != null) {
                this.maxArgs += Integer.parseInt(max);
            }
        }
        if (this.usesContext()) {
            ++this.minArgs;
            ++this.maxArgs;
        }
        if ((e = (Element)function.getElementsByTagName("java").item(0)) != null) {
            this.setClassName(e.getAttribute("class"));
            this.setMethod(e.getAttribute("method"));
            this.setInitialized(Boolean.parseBoolean(e.getAttribute("initialized")));
            nl = e.getElementsByTagName("with-param");
            if (this.initialized && nl.getLength() > 0) {
                this.classParams = new ArrayList<Node>();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    Node value = null;
                    NodeList children = el.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node n = children.item(j);
                        if (n.getNodeType() == 3) {
                            value = n;
                        }
                        if (n.getNodeType() != 1) continue;
                        value = n;
                        break;
                    }
                    this.classParams.add(value);
                }
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isJava() {
        return this.java;
    }

    public void setJava(boolean java) {
        this.java = java;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public void setMaxArgs(int maxArgs) {
        this.maxArgs = maxArgs;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public void setMinArgs(int minArgs) {
        this.minArgs = minArgs;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<Node> getClassParams() {
        return this.classParams;
    }

    public void setClassParams(List<Node> classParams) {
        this.classParams = classParams;
    }
}

