/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.index.IndexEntry;
import com.occamlab.te.index.ParserEntry;
import com.occamlab.te.index.ProfileEntry;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.index.TestEntry;
import com.occamlab.te.util.DomUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Index {
    File indexFile = null;
    List<File> dependencies = new ArrayList<File>();
    Map<String, List<FunctionEntry>> functionsMap = new HashMap<String, List<FunctionEntry>>();
    Map<String, ParserEntry> parserMap = new HashMap<String, ParserEntry>();
    Map<String, SuiteEntry> suiteMap = new HashMap<String, SuiteEntry>();
    Map<String, ProfileEntry> profileMap = new HashMap<String, ProfileEntry>();
    Map<String, TestEntry> testMap = new HashMap<String, TestEntry>();
    List<Element> elements = new ArrayList<Element>();

    public Index() {
    }

    public Index(File indexFile) throws Exception {
        if (null == indexFile || !indexFile.exists()) {
            throw new IllegalArgumentException("indexFile is null or does not exist.");
        }
        this.indexFile = indexFile;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(indexFile);
        Element index = doc.getDocumentElement();
        NodeList nodes = index.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            IndexEntry pe;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            this.elements.add(el);
            String name = el.getNodeName();
            if (name.equals("dependency")) {
                File file = new File(el.getAttribute("file").substring(5));
                this.dependencies.add(file);
                continue;
            }
            if (name.equals("suite")) {
                SuiteEntry se = new SuiteEntry(el);
                this.suiteMap.put(se.getId(), se);
                continue;
            }
            if (name.equals("profile")) {
                pe = new ProfileEntry(el);
                this.profileMap.put(pe.getId(), (ProfileEntry)pe);
                continue;
            }
            if (name.equals("test")) {
                TestEntry te = new TestEntry(el);
                this.testMap.put(te.getId(), te);
                continue;
            }
            if (name.equals("function")) {
                FunctionEntry fe = new FunctionEntry(el);
                List<FunctionEntry> functions = this.functionsMap.get(fe.getId());
                if (functions == null) {
                    functions = new ArrayList<FunctionEntry>();
                    functions.add(fe);
                    this.functionsMap.put(fe.getId(), functions);
                    continue;
                }
                functions.add(fe);
                continue;
            }
            if (!name.equals("parser")) continue;
            pe = new ParserEntry(el);
            this.parserMap.put(pe.getId(), (ParserEntry)pe);
        }
    }

    public void persist(File file) throws Exception {
        file.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(file);
        out.println("<index>");
        for (Element el : this.elements) {
            out.println(DomUtils.serializeNode(el));
        }
        out.println("</index>");
        out.close();
    }

    public boolean outOfDate() {
        if (this.indexFile != null) {
            long indexDate = this.indexFile.lastModified();
            for (File file : this.dependencies) {
                if (file.lastModified() + 1000L <= indexDate) continue;
                return true;
            }
        }
        return false;
    }

    public void add(Index index) {
        this.elements.addAll(index.elements);
        this.dependencies.addAll(index.dependencies);
        this.functionsMap.putAll(index.functionsMap);
        this.suiteMap.putAll(index.suiteMap);
        this.profileMap.putAll(index.profileMap);
        this.testMap.putAll(index.testMap);
        this.parserMap.putAll(index.parserMap);
    }

    public List<FunctionEntry> getFunctions(String name) {
        if (name.startsWith("{")) {
            return this.functionsMap.get(name);
        }
        throw new RuntimeException("Invalid function name");
    }

    public List<FunctionEntry> getFunctions(QName qname2) {
        return this.getFunctions("{" + qname2.getNamespaceURI() + "}" + qname2.getLocalPart());
    }

    public Set<String> getFunctionKeys() {
        return this.functionsMap.keySet();
    }

    public ParserEntry getParser(String name) {
        return (ParserEntry)this.getEntry(this.parserMap, name);
    }

    public ParserEntry getParser(QName qname2) {
        return (ParserEntry)this.getEntry(this.parserMap, qname2);
    }

    public Set<String> getParserKeys() {
        return this.parserMap.keySet();
    }

    public SuiteEntry getSuite(String name) {
        return (SuiteEntry)this.getEntry(this.suiteMap, name);
    }

    public SuiteEntry getSuite(QName qname2) {
        return (SuiteEntry)this.getEntry(this.suiteMap, qname2);
    }

    public Set<String> getSuiteKeys() {
        return this.suiteMap.keySet();
    }

    public ProfileEntry getProfile(String name) {
        return (ProfileEntry)this.getEntry(this.profileMap, name);
    }

    public ProfileEntry getProfile(QName qname2) {
        return (ProfileEntry)this.getEntry(this.profileMap, qname2);
    }

    public Set<String> getProfileKeys() {
        return this.profileMap.keySet();
    }

    public Collection<ProfileEntry> getProfiles() {
        return this.profileMap.values();
    }

    public TestEntry getTest(String name) {
        return (TestEntry)this.getEntry(this.testMap, name);
    }

    public TestEntry getTest(QName qname2) {
        return (TestEntry)this.getEntry(this.testMap, qname2);
    }

    public Set<String> getTestKeys() {
        return this.testMap.keySet();
    }

    private IndexEntry getEntry(Map<String, ? extends IndexEntry> map, QName qname2) {
        return this.getEntry(map, "{" + qname2.getNamespaceURI() + "}" + qname2.getLocalPart());
    }

    private IndexEntry getEntry(Map<String, ? extends IndexEntry> map, String name) {
        if (name == null) {
            return map.values().iterator().next();
        }
        if (name.startsWith("{")) {
            return map.get(name);
        }
        int i = name.lastIndexOf(44);
        if (i >= 0) {
            String key = "{" + name.substring(0, i) + "}" + name.substring(i + 1);
            return map.get(key);
        }
        String prefix = null;
        String localName = name;
        i = name.indexOf(58);
        if (i >= 0) {
            prefix = name.substring(0, i);
            localName = name.substring(i + 1);
        }
        for (IndexEntry indexEntry : map.values()) {
            if (!indexEntry.getLocalName().equals(localName)) continue;
            if (prefix == null) {
                return indexEntry;
            }
            if (!indexEntry.getPrefix().equals(prefix)) continue;
            return indexEntry;
        }
        return null;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements != null ? elements : new ArrayList<Element>();
    }

    public List<File> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<File> dependencies) {
        this.dependencies = dependencies;
    }
}

