/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.DOMExceptionImpl;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class TextOverNodeInfo
extends NodeOverNodeInfo
implements Text,
Comment {
    public String getData() {
        return this.node.getStringValue();
    }

    public void setData(String data) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public int getLength() {
        return this.node.getStringValue().length();
    }

    public String substringData(int offset, int count) throws DOMException {
        try {
            return this.node.getStringValue().substring(offset, offset + count);
        }
        catch (IndexOutOfBoundsException err2) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void insertData(int offset, String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void deleteData(int offset, int count) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public Text splitText(int offset) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    public Text replaceWholeText(String content) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    public boolean isElementContentWhitespace() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        int annotation2 = this.node.getParent().getTypeAnnotation();
        if (annotation2 == -1) {
            return false;
        }
        if (!Whitespace.isWhite(this.node.getStringValue())) {
            return false;
        }
        SchemaType type = this.node.getConfiguration().getSchemaType(annotation2);
        if (!type.isComplexType()) {
            return false;
        }
        return !((ComplexType)type).isMixedContent();
    }

    public String getWholeText() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        return this.node.getStringValue();
    }
}

