/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Token;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public final class Tokenizer {
    private int state = 0;
    public static final int DEFAULT_STATE = 0;
    public static final int BARE_NAME_STATE = 1;
    public static final int SEQUENCE_TYPE_STATE = 2;
    public static final int OPERATOR_STATE = 3;
    public int startLineNumber;
    public int currentToken = 0;
    public String currentTokenValue = null;
    public int currentTokenStartOffset = 0;
    private int nextToken = 0;
    private String nextTokenValue = null;
    private int nextTokenStartOffset = 0;
    public String input;
    public int inputOffset = 0;
    private int inputLength;
    private int lineNumber = 1;
    private int nextLineNumber = 1;
    private List newlineOffsets = null;
    private int precedingToken = -1;

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 0) {
            this.precedingToken = -1;
            this.currentToken = -1;
        } else if (state == 3) {
            this.precedingToken = 104;
            this.currentToken = 104;
        }
    }

    public void tokenize(String input, int start, int end, int lineNumber) throws XPathException {
        this.nextToken = 0;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = 0;
        this.inputOffset = start;
        this.input = input;
        this.startLineNumber = lineNumber;
        this.lineNumber = lineNumber;
        this.nextLineNumber = lineNumber;
        this.inputLength = end == -1 ? input.length() : end;
        this.lookAhead();
        this.next();
    }

    public void next() throws XPathException {
        this.precedingToken = this.currentToken;
        this.currentToken = this.nextToken;
        this.currentTokenValue = this.nextTokenValue;
        if (this.currentTokenValue == null) {
            this.currentTokenValue = "";
        }
        this.currentTokenStartOffset = this.nextTokenStartOffset;
        this.lineNumber = this.nextLineNumber;
        switch (this.currentToken) {
            case 101: {
                int optype = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (optype == -1 || this.followsOperator(this.precedingToken)) break;
                this.currentToken = optype;
                break;
            }
            case 12: {
                if (!this.followsOperator(this.precedingToken)) break;
                this.currentToken = 117;
                break;
            }
            case 107: {
                if (this.followsOperator(this.precedingToken)) break;
                this.currentToken = 17;
            }
        }
        if (this.currentToken == 117 || this.currentToken == 115) {
            return;
        }
        int oldPrecedingToken = this.precedingToken;
        this.lookAhead();
        if (this.currentToken == 101) {
            if (this.state == 1) {
                return;
            }
            switch (this.nextToken) {
                case 5: {
                    int op = Tokenizer.getBinaryOp(this.currentTokenValue);
                    if (op == -1 || this.followsOperator(oldPrecedingToken)) {
                        this.currentToken = Tokenizer.getFunctionType(this.currentTokenValue);
                        this.lookAhead();
                        break;
                    }
                    this.currentToken = op;
                    break;
                }
                case 53: {
                    if (this.state == 2) break;
                    this.currentToken = 54;
                    this.lookAhead();
                    break;
                }
                case 39: {
                    this.lookAhead();
                    this.currentToken = 35;
                    break;
                }
                case 40: {
                    this.lookAhead();
                    this.currentToken = 108;
                    break;
                }
                case 21: {
                    if (this.currentTokenValue == "for") {
                        this.currentToken = 111;
                        break;
                    }
                    if (this.currentTokenValue == "some") {
                        this.currentToken = 31;
                        break;
                    }
                    if (this.currentTokenValue == "every") {
                        this.currentToken = 32;
                        break;
                    }
                    if (this.currentTokenValue != "let") break;
                    this.currentToken = 116;
                    break;
                }
                case 101: {
                    String composite;
                    Integer val;
                    int candidate = -1;
                    if (this.currentTokenValue.equals("element")) {
                        candidate = 55;
                    } else if (this.currentTokenValue.equals("attribute")) {
                        candidate = 56;
                    } else if (this.currentTokenValue.equals("processing-instruction")) {
                        candidate = 57;
                    }
                    if (candidate != -1) {
                        String qname2 = this.nextTokenValue;
                        String saveTokenValue = this.currentTokenValue;
                        int savePosition = this.inputOffset;
                        this.lookAhead();
                        if (this.nextToken == 53) {
                            this.currentToken = candidate;
                            this.currentTokenValue = qname2;
                            this.lookAhead();
                            return;
                        }
                        this.currentToken = 101;
                        this.currentTokenValue = saveTokenValue;
                        this.inputOffset = savePosition;
                        this.nextToken = 101;
                        this.nextTokenValue = qname2;
                    }
                    if ((val = (Integer)Token.doubleKeywords.get(composite = this.currentTokenValue + ' ' + this.nextTokenValue)) == null) break;
                    this.currentToken = val;
                    this.currentTokenValue = composite;
                    this.lookAhead();
                    return;
                }
            }
        }
    }

    public void treatCurrentAsOperator() {
        switch (this.currentToken) {
            case 101: {
                int optype = Tokenizer.getBinaryOp(this.currentTokenValue);
                if (optype == -1) break;
                this.currentToken = optype;
                break;
            }
            case 107: {
                this.currentToken = 17;
            }
        }
    }

    public void lookAhead() throws XPathException {
        char c;
        this.precedingToken = this.nextToken;
        this.nextTokenValue = null;
        this.nextTokenStartOffset = this.inputOffset;
        block39: while (true) {
            if (this.inputOffset >= this.inputLength) {
                this.nextToken = 0;
                return;
            }
            c = this.input.charAt(this.inputOffset++);
            switch (c) {
                case '/': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '/') {
                        ++this.inputOffset;
                        this.nextToken = 8;
                        return;
                    }
                    this.nextToken = 2;
                    return;
                }
                case ':': {
                    if (this.inputOffset < this.inputLength) {
                        if (this.input.charAt(this.inputOffset) == ':') {
                            ++this.inputOffset;
                            this.nextToken = 39;
                            return;
                        }
                        if (this.input.charAt(this.inputOffset) == '=') {
                            this.nextToken = 52;
                            ++this.inputOffset;
                            return;
                        }
                    }
                    throw new XPathException("Unexpected colon at start of token");
                }
                case '@': {
                    this.nextToken = 3;
                    return;
                }
                case '?': {
                    this.nextToken = 113;
                    return;
                }
                case '[': {
                    this.nextToken = 4;
                    return;
                }
                case ']': {
                    this.nextToken = 103;
                    return;
                }
                case '{': {
                    this.nextToken = 53;
                    return;
                }
                case '}': {
                    this.nextToken = 115;
                    return;
                }
                case ';': {
                    this.nextToken = 90;
                    this.state = 0;
                    return;
                }
                case '(': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '#') {
                        ++this.inputOffset;
                        int pragmaStart = this.inputOffset;
                        int nestingDepth = 1;
                        while (nestingDepth > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == '#' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --nestingDepth;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == '#') {
                                ++nestingDepth;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (nestingDepth > 0) {
                            throw new XPathException("Unclosed XQuery pragma");
                        }
                        this.nextToken = 118;
                        this.nextTokenValue = this.input.substring(pragmaStart, this.inputOffset - 2);
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':') {
                        ++this.inputOffset;
                        int nestingDepth = 1;
                        while (nestingDepth > 0 && this.inputOffset < this.inputLength - 1) {
                            if (this.input.charAt(this.inputOffset) == '\n') {
                                this.incrementLineNumber();
                            } else if (this.input.charAt(this.inputOffset) == ':' && this.input.charAt(this.inputOffset + 1) == ')') {
                                --nestingDepth;
                                ++this.inputOffset;
                            } else if (this.input.charAt(this.inputOffset) == '(' && this.input.charAt(this.inputOffset + 1) == ':') {
                                ++nestingDepth;
                                ++this.inputOffset;
                            }
                            ++this.inputOffset;
                        }
                        if (nestingDepth > 0) {
                            throw new XPathException("Unclosed XPath comment");
                        }
                        this.lookAhead();
                    } else {
                        this.nextToken = 5;
                    }
                    return;
                }
                case ')': {
                    this.nextToken = 104;
                    return;
                }
                case '+': {
                    this.nextToken = 15;
                    return;
                }
                case '-': {
                    this.nextToken = 16;
                    return;
                }
                case '=': {
                    this.nextToken = 6;
                    return;
                }
                case '!': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 22;
                        return;
                    }
                    throw new XPathException("'!' without '='");
                }
                case '*': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == ':') {
                        char ahead;
                        ++this.inputOffset;
                        this.nextToken = 62;
                        if (this.inputOffset < this.inputLength && " \r\t\n(".indexOf(ahead = this.input.charAt(this.inputOffset)) >= 0) {
                            throw new XPathException("Whitespace and comments are not allowed after '*:'");
                        }
                        return;
                    }
                    this.nextToken = 107;
                    return;
                }
                case ',': {
                    this.nextToken = 7;
                    return;
                }
                case '$': {
                    this.nextToken = 21;
                    return;
                }
                case '|': {
                    this.nextToken = 1;
                    return;
                }
                case '<': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 14;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '<') {
                        ++this.inputOffset;
                        this.nextToken = 37;
                        return;
                    }
                    this.nextToken = 12;
                    return;
                }
                case '>': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '=') {
                        ++this.inputOffset;
                        this.nextToken = 13;
                        return;
                    }
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '>') {
                        ++this.inputOffset;
                        this.nextToken = 38;
                        return;
                    }
                    this.nextToken = 11;
                    return;
                }
                case '.': {
                    if (this.inputOffset < this.inputLength && this.input.charAt(this.inputOffset) == '.') {
                        ++this.inputOffset;
                        this.nextToken = 106;
                        return;
                    }
                    if (this.inputOffset == this.inputLength || this.input.charAt(this.inputOffset) < '0' || this.input.charAt(this.inputOffset) > '9') {
                        this.nextToken = 105;
                        return;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean allowE = true;
                    boolean allowSign = false;
                    boolean allowDot = true;
                    boolean endOfNum = false;
                    block42: while (!endOfNum) {
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                allowSign = false;
                                break;
                            }
                            case '.': {
                                if (allowDot) {
                                    allowDot = false;
                                    allowSign = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            case 'E': 
                            case 'e': {
                                if (allowE) {
                                    allowSign = true;
                                    allowE = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            case '+': 
                            case '-': {
                                if (allowSign) {
                                    allowSign = false;
                                    break;
                                }
                                --this.inputOffset;
                                break block42;
                            }
                            default: {
                                if ('a' <= c && c <= 'z' || c > '\u007f') {
                                    throw new XPathException("Separator needed after numeric literal");
                                }
                                --this.inputOffset;
                                break block42;
                            }
                        }
                        if (this.inputOffset >= this.inputLength) break;
                        c = this.input.charAt(this.inputOffset++);
                    }
                    this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset);
                    this.nextToken = 109;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.nextTokenValue = "";
                    while (true) {
                        this.inputOffset = this.input.indexOf(c, this.inputOffset);
                        if (this.inputOffset < 0) {
                            this.inputOffset = this.nextTokenStartOffset + 1;
                            throw new XPathException("Unmatched quote in expression");
                        }
                        this.nextTokenValue = this.nextTokenValue + this.input.substring(this.nextTokenStartOffset + 1, this.inputOffset++);
                        if (this.inputOffset >= this.inputLength || this.input.charAt(this.inputOffset) != c) break;
                        this.nextTokenValue = this.nextTokenValue + c;
                        this.nextTokenStartOffset = this.inputOffset++;
                    }
                    if (this.nextTokenValue.indexOf(10) >= 0) {
                        for (int i = 0; i < this.nextTokenValue.length(); ++i) {
                            if (this.nextTokenValue.charAt(i) != '\n') continue;
                            ++this.lineNumber;
                            if (this.newlineOffsets == null) {
                                this.newlineOffsets = new ArrayList(20);
                            }
                            this.newlineOffsets.add(new Integer(this.nextTokenStartOffset + i));
                        }
                    }
                    this.nextTokenValue = this.nextTokenValue.intern();
                    this.nextToken = 102;
                    return;
                }
                case '\n': {
                    this.incrementLineNumber();
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.nextTokenStartOffset = this.inputOffset;
                    continue block39;
                }
                default: {
                    if (c >= '\u0080' || Character.isLetter(c)) break block39;
                    throw new XPathException("Invalid character '" + c + "' in expression");
                }
                case '_': 
            }
            break;
        }
        block45: while (this.inputOffset < this.inputLength) {
            c = this.input.charAt(this.inputOffset);
            switch (c) {
                case ':': {
                    if (this.inputOffset + 1 >= this.inputLength) break;
                    char nc = this.input.charAt(this.inputOffset + 1);
                    if (nc == ':') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                        this.nextToken = 35;
                        this.inputOffset += 2;
                        return;
                    }
                    if (nc == '*') {
                        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                        this.nextToken = 108;
                        this.inputOffset += 2;
                        return;
                    }
                    if (nc != '=') break;
                    this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
                    this.nextToken = 101;
                    return;
                }
                case '-': 
                case '.': 
                case '_': {
                    break;
                }
                default: {
                    if (c < '\u0080' && !Character.isLetterOrDigit(c)) break block45;
                }
            }
            ++this.inputOffset;
        }
        this.nextTokenValue = this.input.substring(this.nextTokenStartOffset, this.inputOffset).intern();
        this.nextToken = 101;
    }

    private static int getBinaryOp(String s2) {
        switch (s2.length()) {
            case 2: {
                if (s2 == "or") {
                    return 9;
                }
                if (s2 == "is") {
                    return 20;
                }
                if (s2 == "to") {
                    return 29;
                }
                if (s2 == "in") {
                    return 30;
                }
                if (s2 == "eq") {
                    return 44;
                }
                if (s2 == "ne") {
                    return 45;
                }
                if (s2 == "gt") {
                    return 46;
                }
                if (s2 == "ge") {
                    return 48;
                }
                if (s2 == "lt") {
                    return 47;
                }
                if (s2 != "le") break;
                return 49;
            }
            case 3: {
                if (s2 == "and") {
                    return 10;
                }
                if (s2 == "div") {
                    return 18;
                }
                if (s2 != "mod") break;
                return 19;
            }
            case 4: {
                if (s2 == "idiv") {
                    return 50;
                }
                if (s2 == "then") {
                    return 26;
                }
                if (s2 == "else") {
                    return 27;
                }
                if (s2 != "case") break;
                return 59;
            }
            case 5: {
                if (s2 == "where") {
                    return 28;
                }
                if (s2 != "union") break;
                return 1;
            }
            case 6: {
                if (s2 == "except") {
                    return 24;
                }
                if (s2 != "return") break;
                return 25;
            }
            case 7: {
                if (s2 == "default") {
                    return 112;
                }
            }
            case 9: {
                if (s2 == "intersect") {
                    return 23;
                }
                if (s2 != "satisfies") break;
                return 33;
            }
        }
        return -1;
    }

    private static int getFunctionType(String s2) {
        switch (s2.length()) {
            case 2: {
                if (s2 != "if") break;
                return 36;
            }
            case 4: {
                if (s2 == "node") {
                    return 61;
                }
                if (s2 == "item") {
                    return 61;
                }
                if (s2 != "text") break;
                return 61;
            }
            case 7: {
                if (s2 == "element") {
                    return 61;
                }
                if (s2 != "comment") break;
                return 61;
            }
            case 9: {
                if (s2 == "attribute") {
                    return 61;
                }
                if (s2 != "namespace") break;
                return 61;
            }
            case 10: {
                if (s2 != "typeswitch") break;
                return 58;
            }
            default: {
                if (s2 == "document-node") {
                    return 61;
                }
                if (s2 == "empty-sequence") {
                    return 61;
                }
                if (s2 == "schema-element") {
                    return 61;
                }
                if (s2 == "schema-attribute") {
                    return 61;
                }
                if (s2 != "processing-instruction") break;
                return 61;
            }
        }
        return 34;
    }

    private boolean followsOperator(int precedingToken) {
        return precedingToken <= Token.LAST_OPERATOR;
    }

    public char nextChar() throws StringIndexOutOfBoundsException {
        char c;
        if ((c = this.input.charAt(this.inputOffset++)) == '\n') {
            this.incrementLineNumber();
            ++this.lineNumber;
        }
        return c;
    }

    private void incrementLineNumber() {
        ++this.nextLineNumber;
        if (this.newlineOffsets == null) {
            this.newlineOffsets = new ArrayList(20);
        }
        this.newlineOffsets.add(new Integer(this.inputOffset - 1));
    }

    public void unreadChar() {
        if (this.input.charAt(--this.inputOffset) == '\n') {
            --this.nextLineNumber;
            --this.lineNumber;
            if (this.newlineOffsets != null) {
                this.newlineOffsets.remove(this.newlineOffsets.size() - 1);
            }
        }
    }

    public String recentText() {
        if (this.inputOffset > this.inputLength) {
            this.inputOffset = this.inputLength;
        }
        if (this.inputOffset < 34) {
            return this.input.substring(0, this.inputOffset);
        }
        return Whitespace.collapseWhitespace("..." + this.input.substring(this.inputOffset - 30, this.inputOffset)).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return (int)(this.getLineAndColumn(this.currentTokenStartOffset) & Integer.MAX_VALUE);
    }

    public long getLineAndColumn(int offset) {
        if (this.newlineOffsets == null) {
            return (long)this.startLineNumber << 32 | (long)offset;
        }
        for (int line = this.newlineOffsets.size() - 1; line >= 0; --line) {
            int nloffset = (Integer)this.newlineOffsets.get(line);
            if (offset <= nloffset) continue;
            return (long)(line + this.startLineNumber + 1) << 32 | (long)(offset - nloffset);
        }
        return (long)this.startLineNumber << 32 | (long)(offset + 1);
    }

    public int getLineNumber(int offset) {
        return (int)(this.getLineAndColumn(offset) >> 32);
    }

    public int getColumnNumber(int offset) {
        return (int)(this.getLineAndColumn(offset) & Integer.MAX_VALUE);
    }
}

