/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Token;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SubstitutionGroupTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest nodetest1;
    private NodeTest nodetest2;
    private int operator;
    private boolean isGlobalComponentTest;

    public CombinedNodeTest(NodeTest nt1, int operator, NodeTest nt2) {
        this.nodetest1 = nt1;
        this.operator = operator;
        this.nodetest2 = nt2;
    }

    public void setGlobalComponentTest(boolean global) {
        this.isGlobalComponentTest = global;
    }

    public boolean matches(int nodeType, int fingerprint, int annotation2) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(nodeType, fingerprint, annotation2) || this.nodetest2.matches(nodeType, fingerprint, annotation2);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(nodeType, fingerprint, annotation2) || this.nodetest2 != null && !this.nodetest2.matches(nodeType, fingerprint, annotation2));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(nodeType, fingerprint, annotation2)) && this.nodetest2 != null && !this.nodetest2.matches(nodeType, fingerprint, annotation2);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(tree, nodeNr) || this.nodetest2.matches(tree, nodeNr);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(tree, nodeNr) || this.nodetest2 != null && !this.nodetest2.matches(tree, nodeNr));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(tree, nodeNr)) && this.nodetest2 != null && !this.nodetest2.matches(tree, nodeNr);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(NodeInfo node) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(node) || this.nodetest2.matches(node);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(node) || this.nodetest2 != null && !this.nodetest2.matches(node));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(node)) && this.nodetest2 != null && !this.nodetest2.matches(node);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public String toString(NamePool pool) {
        if (this.isGlobalComponentTest) {
            if (this.nodetest1 instanceof SubstitutionGroupTest) {
                return this.nodetest1.toString(pool);
            }
            int kind = this.nodetest1.getPrimitiveType();
            String skind = kind == 1 ? "schema-element(" : "schema-attribute(";
            String name = pool.getClarkName(this.nodetest1.getFingerprint());
            return skind + name + ')';
        }
        if (this.nodetest1 instanceof NameTest && this.operator == 23) {
            int kind = this.nodetest1.getPrimitiveType();
            String skind = kind == 1 ? "element(" : "attribute(";
            String content = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                SchemaType schemaType = ((ContentTypeTest)this.nodetest2).getSchemaType();
                content = ", " + pool.getClarkName(schemaType.getFingerprint());
            }
            String name = pool.getClarkName(this.nodetest1.getFingerprint());
            return skind + name + content + ')';
        }
        String nt1 = this.nodetest1 == null ? "true()" : this.nodetest1.toString(pool);
        String nt2 = this.nodetest2 == null ? "true()" : this.nodetest2.toString(pool);
        return '(' + nt1 + ' ' + Token.tokens[this.operator] + ' ' + nt2 + ')';
    }

    public String toString() {
        if (this.isGlobalComponentTest) {
            if (this.nodetest1 instanceof SubstitutionGroupTest) {
                return this.nodetest1.toString();
            }
            int kind = this.nodetest1.getPrimitiveType();
            String skind = kind == 1 ? "schema-element(" : "schema-attribute(";
            String name = this.nodetest1.toString();
            return skind + name + ')';
        }
        if (this.nodetest1 instanceof NameTest && this.operator == 23) {
            int kind = this.nodetest1.getPrimitiveType();
            String skind = kind == 1 ? "element(" : "attribute(";
            String content = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                SchemaType schemaType = ((ContentTypeTest)this.nodetest2).getSchemaType();
                content = ", " + schemaType.getFingerprint();
            }
            String name = this.nodetest1.toString();
            return skind + name + content + ')';
        }
        String nt1 = this.nodetest1 == null ? "true()" : this.nodetest1.toString();
        String nt2 = this.nodetest2 == null ? "true()" : this.nodetest2.toString();
        return '(' + nt1 + ' ' + Token.tokens[this.operator] + ' ' + nt2 + ')';
    }

    public ItemType getSuperType(TypeHierarchy th) {
        switch (this.operator) {
            case 1: {
                return Type.getCommonSuperType(this.nodetest1, this.nodetest2, th);
            }
            case 23: {
                return this.nodetest1;
            }
            case 24: {
                return this.nodetest1;
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public int getNodeKindMask() {
        switch (this.operator) {
            case 1: {
                return this.nodetest1.getNodeKindMask() | this.nodetest2.getNodeKindMask();
            }
            case 23: {
                return this.nodetest1.getNodeKindMask() & this.nodetest2.getNodeKindMask();
            }
            case 24: {
                return this.nodetest1.getNodeKindMask();
            }
        }
        return 0;
    }

    public int getPrimitiveType() {
        int mask = this.getNodeKindMask();
        if (mask == 2) {
            return 1;
        }
        if (mask == 4) {
            return 2;
        }
        if (mask == 512) {
            return 9;
        }
        return 0;
    }

    public IntHashSet getRequiredNodeNames() {
        IntHashSet s1 = this.nodetest1.getRequiredNodeNames();
        IntHashSet s2 = this.nodetest2.getRequiredNodeNames();
        if (s2 == null) {
            return s1;
        }
        if (s1 == null) {
            return s2;
        }
        switch (this.operator) {
            case 1: {
                return s1.union(s2);
            }
            case 23: {
                return s1.intersect(s2);
            }
            case 24: {
                return s1.except(s2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public SchemaType getContentType() {
        SchemaType type2;
        SchemaType type1 = this.nodetest1.getContentType();
        if (type1.isSameType(type2 = this.nodetest2.getContentType())) {
            return type1;
        }
        if (this.operator == 23) {
            if (type2 instanceof AnyType) {
                return type1;
            }
            if (type1 instanceof AnyType) {
                return type2;
            }
        }
        return AnyType.getInstance();
    }

    public AtomicType getAtomizedItemType() {
        AtomicType type2;
        AtomicType type1 = this.nodetest1.getAtomizedItemType();
        if (type1.isSameType(type2 = this.nodetest2.getAtomizedItemType())) {
            return type1;
        }
        if (this.operator == 23) {
            if (type2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return type1;
            }
            if (type1.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                return type2;
            }
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int getFingerprint() {
        int fp2;
        int fp1 = this.nodetest1.getFingerprint();
        if (fp1 == (fp2 = this.nodetest2.getFingerprint())) {
            return fp1;
        }
        if (fp2 == -1 && this.operator == 23) {
            return fp1;
        }
        if (fp1 == -1 && this.operator == 23) {
            return fp2;
        }
        return -1;
    }

    public boolean isNillable() {
        return this.nodetest1.isNillable() || this.nodetest2.isNillable();
    }

    public int hashCode() {
        return this.nodetest1.hashCode() ^ this.nodetest2.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CombinedNodeTest && ((CombinedNodeTest)other).nodetest1.equals(this.nodetest1) && ((CombinedNodeTest)other).nodetest2.equals(this.nodetest2) && ((CombinedNodeTest)other).operator == this.operator;
    }

    public double getDefaultPriority() {
        return 0.25;
    }

    public NodeTest[] getComponentNodeTests() {
        return new NodeTest[]{this.nodetest1, this.nodetest2};
    }

    public int getOperator() {
        return this.operator;
    }
}

