/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;

public final class LocalNameTest
extends NodeTest {
    private NamePool namePool;
    private int nodeKind;
    private String localName;

    public LocalNameTest(NamePool pool, int nodeKind, String localName) {
        this.namePool = pool;
        this.nodeKind = nodeKind;
        this.localName = localName;
    }

    public boolean matches(int nodeType, int fingerprint, int annotation2) {
        if (fingerprint == -1) {
            return false;
        }
        if (nodeType != this.nodeKind) {
            return false;
        }
        return this.localName.equals(this.namePool.getLocalName(fingerprint));
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        int fingerprint = tree.getNameCode(nodeNr) & 0xFFFFF;
        if (fingerprint == -1) {
            return false;
        }
        if (tree.getNodeKind(nodeNr) != this.nodeKind) {
            return false;
        }
        return this.localName.equals(this.namePool.getLocalName(fingerprint));
    }

    public boolean matches(NodeInfo node) {
        return this.localName.equals(node.getLocalPart());
    }

    public final double getDefaultPriority() {
        return -0.25;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String toString() {
        return "*:" + this.localName;
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.localName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof LocalNameTest && ((LocalNameTest)other).namePool == this.namePool && ((LocalNameTest)other).nodeKind == this.nodeKind && ((LocalNameTest)other).localName.equals(this.localName);
    }
}

