/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;

public class SubstitutionGroupTest
extends NodeTest {
    private int head;
    private IntHashSet group;

    public SubstitutionGroupTest(int head, IntHashSet group2) {
        this.group = group2;
        this.head = head;
    }

    public boolean matches(int nodeKind, int nameCode, int annotation2) {
        return nodeKind == 1 && this.group.contains(nameCode & 0xFFFFF);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return tree.getNodeKind(nodeNr) == 1 && this.group.contains(tree.getNameCode(nodeNr) & 0xFFFFF);
    }

    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == 1 && this.group.contains(node.getFingerprint());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return 1;
    }

    public int getNodeKindMask() {
        return 2;
    }

    public IntHashSet getRequiredNodeNames() {
        return this.group;
    }

    public int getHeadFingerprint() {
        return this.head;
    }

    public String toString(NamePool pool) {
        return "schema-element(" + pool.getDisplayName(this.head) + ')';
    }

    public int hashCode() {
        return this.head;
    }

    public boolean equals(Object other) {
        return other instanceof SubstitutionGroupTest && ((SubstitutionGroupTest)other).head == this.head;
    }
}

