/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class ExternalObjectType
implements AtomicType,
Serializable {
    private Class javaClass;
    private Configuration config;
    int fingerprint;
    int baseFingerprint = -1;

    public ExternalObjectType(Class javaClass, Configuration config) {
        this.javaClass = javaClass;
        this.config = config;
        String localName = javaClass.getName().replace('$', '_');
        this.fingerprint = config.getNamePool().allocate("", "http://saxon.sf.net/java-type", localName);
    }

    public String getName() {
        return this.config.getNamePool().getLocalName(this.fingerprint);
    }

    public String getTargetNamespace() {
        return this.config.getNamePool().getURI(this.fingerprint);
    }

    public boolean isExternalType() {
        return true;
    }

    public boolean isBuiltInType() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public boolean isOrdered() {
        return false;
    }

    public String getSystemId() {
        return null;
    }

    public final int getValidationStatus() {
        return 3;
    }

    public final int getBlock() {
        return 0;
    }

    public final int getDerivationMethod() {
        return 1;
    }

    public final boolean allowsDerivation(int derivation) {
        return true;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public final boolean isComplexType() {
        return false;
    }

    public final SchemaType getBaseType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public ItemType getPrimitiveItemType() {
        return this;
    }

    public int getPrimitiveType() {
        return 632;
    }

    public String toString(NamePool pool) {
        return this.getDisplayName();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    public boolean isSameType(SchemaType other) {
        return other.getFingerprint() == this.getFingerprint();
    }

    public int getRelationship(ExternalObjectType other) {
        Class j2 = other.javaClass;
        if (this.javaClass.equals(j2)) {
            return 0;
        }
        if (this.javaClass.isAssignableFrom(j2)) {
            return 1;
        }
        if (j2.isAssignableFrom(this.javaClass)) {
            return 2;
        }
        if (this.javaClass.isInterface() || j2.isInterface()) {
            return 3;
        }
        return 4;
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
    }

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isAtomicType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public int getWhitespaceAction(TypeHierarchy th) {
        return 0;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence value) throws ValidationException {
        return value;
    }

    public SchemaType getBuiltInBaseType() {
        return this;
    }

    public boolean isNamespaceSensitive() {
        return false;
    }

    public boolean isAnonymousType() {
        return false;
    }

    public final SequenceIterator getTypedValue(NodeInfo node) {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    public Value atomize(NodeInfo node) throws XPathException {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver2, NameChecker nameChecker) throws ValidationException {
        throw new ValidationException("Cannot validate a string against an external object type");
    }

    public ValidationFailure validate(AtomicValue primValue, CharSequence lexicalValue, NameChecker checker) {
        throw new UnsupportedOperationException("validate");
    }

    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        ExternalObjectType.analyzeContentExpression(this, expression, env, kind);
    }

    public static void analyzeContentExpression(SimpleType simpleType2, Expression expression, StaticContext env, int kind) throws XPathException {
        if (kind == 1) {
            expression.checkPermittedContents(simpleType2, env, true);
        } else if (kind == 2 && (expression instanceof ValueOf || expression instanceof Literal)) {
            expression.checkPermittedContents(simpleType2, env, true);
        }
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, NameChecker nameChecker) {
        throw new UnsupportedOperationException("Cannot use an external object type for validation");
    }

    public ItemType getSuperType(TypeHierarchy th) {
        if (this.javaClass == Object.class) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        Class javaSuper = this.javaClass.getSuperclass();
        if (javaSuper == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return new ExternalObjectType(javaSuper, this.config);
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public String toString() {
        String name = this.javaClass.getName();
        name = name.replace('$', '-');
        return "java:" + name;
    }

    public String getDisplayName() {
        return this.toString();
    }
}

