/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.extension;

import org.citygml4j.model.module.ModuleVersion;

public class ExtensionModuleVersion
implements ModuleVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final String additionalLabel;

    public ExtensionModuleVersion(int major, int minor, int patch, String additionalLabel) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.additionalLabel = additionalLabel;
    }

    public ExtensionModuleVersion(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public ExtensionModuleVersion(int major, int minor) {
        this(major, minor, 0, null);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getAdditionalLabel() {
        return this.additionalLabel;
    }

    @Override
    public String getVersionString() {
        StringBuilder version = new StringBuilder(this.major).append(".").append(this.minor).append(this.patch);
        if (this.additionalLabel != null) {
            version.append(this.additionalLabel);
        }
        return version.toString();
    }

    public String toString() {
        return this.getVersionString();
    }
}

