/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.cityobjectgroup;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.CityObjectGroupType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroup;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupMember;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.util.child.ChildInfo;
import org.citygml4j.util.gmlid.DefaultGMLIdManager;
import org.citygml4j.util.gmlid.GMLIdManager;
import org.citygml4j.util.walker.FeatureFunctionWalker;
import org.citygml4j.util.walker.FeatureWalker;

public class CityObjectGroupMarshaller {
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private final GMLIdManager gmlIdManager = DefaultGMLIdManager.getInstance();

    public CityObjectGroupMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        if (src instanceof CityObjectGroup) {
            return this.marshalCityObjectGroup((CityObjectGroup)src, cityJSON);
        }
        return null;
    }

    public void marshalCityObjectGroup(CityObjectGroup src, CityObjectGroupType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfCityObjectGroup()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfCityObjectGroup(), dest, cityJSON);
        }
        if (src.isSetGeometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getGeometry())) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetGroupParent() && src.getGroupParent().isSetCityObject()) {
            AbstractCityObjectType parent = this.citygml.marshal(src.getGroupParent().getCityObject(), cityJSON);
            cityJSON.addCityObject(parent);
        }
        if (src.isSetGroupMember()) {
            for (CityObjectGroupMember property : src.getGroupMember()) {
                if (property.isSetCityObject()) {
                    AbstractCityObject cityObject = property.getCityObject();
                    if (!cityObject.isSetId()) {
                        cityObject.setId(this.gmlIdManager.generateUUID());
                    }
                    AbstractCityObjectType member = this.json.getGMLMarshaller().marshalFeatureProperty(property, cityJSON);
                    dest.addMember(member.getGmlId());
                    cityJSON.addCityObject(member);
                    continue;
                }
                if (!property.isSetHref()) continue;
                String member = property.getHref().replaceAll("^.*?#+?", "");
                dest.addMember(member);
            }
        }
    }

    public CityObjectGroupType marshalCityObjectGroup(CityObjectGroup src, CityJSON cityJSON) {
        CityObjectGroupType dest = new CityObjectGroupType();
        this.marshalCityObjectGroup(src, dest, cityJSON);
        return dest;
    }

    public void postprocessGroupMembers(CityModel src, CityJSON cityJSON) {
        final Set gmlIds = cityJSON.getCityObjects().stream().map(AbstractCityObjectType::getGmlId).collect(Collectors.toSet());
        List groups = cityJSON.getCityObjects().stream().filter(CityObjectGroupType.class::isInstance).map(CityObjectGroupType.class::cast).collect(Collectors.toList());
        final ChildInfo childInfo = new ChildInfo();
        for (CityObjectGroupType group2 : groups) {
            final HashSet candidates = new HashSet();
            Iterator<String> iter = group2.getMembers().iterator();
            while (iter.hasNext()) {
                final String gmlId = iter.next();
                if (gmlIds.contains(gmlId)) continue;
                iter.remove();
                final AbstractCityObject member = src.accept(new FeatureFunctionWalker<AbstractCityObject>(){

                    @Override
                    public AbstractCityObject apply(AbstractCityObject cityObject) {
                        return gmlId.equals(cityObject.getId()) ? cityObject : (AbstractCityObject)super.apply(cityObject);
                    }
                });
                if (member == null) continue;
                member.accept(new FeatureWalker(){

                    @Override
                    public void visit(AbstractCityObject cityObject) {
                        if (cityObject != member && cityObject.isSetId() && gmlIds.contains(cityObject.getId())) {
                            boolean addCandidate = true;
                            AbstractFeature parent = cityObject;
                            while ((parent = childInfo.getParentFeature(parent)) != null) {
                                if (!parent.isSetId() || !candidates.contains(parent.getId())) continue;
                                addCandidate = false;
                                break;
                            }
                            if (addCandidate) {
                                candidates.add(cityObject.getId());
                            }
                        }
                        super.visit(cityObject);
                    }
                });
            }
            if (candidates.isEmpty()) continue;
            candidates.forEach(group2::addMember);
        }
    }
}

