/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.generics;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.util.GenericAttributeType;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.citygml.generics.DateAttribute;
import org.citygml4j.model.citygml.generics.DoubleAttribute;
import org.citygml4j.model.citygml.generics.GenericAttributeSet;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.citygml.generics.IntAttribute;
import org.citygml4j.model.citygml.generics.MeasureAttribute;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.citygml.generics.UriAttribute;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.basicTypes.Measure;

public class GenericsMarshaller {
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private final Map<String, GenericAttributeType> genericAttributeTypes = new HashMap<String, GenericAttributeType>();

    public GenericsMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        if (src instanceof GenericCityObject) {
            return this.marshalGenericCityObject((GenericCityObject)src, cityJSON);
        }
        return null;
    }

    public void marshalGenericCityObject(GenericCityObject src, GenericCityObjectType dest, CityJSON cityJSON) {
        AbstractGeometryType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetLod0Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod0Geometry())) != null) {
            geometry.setLod(0);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Geometry())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod0ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod0ImplicitRepresentation(), 0)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation(), 1)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry(geometry);
        }
    }

    public GenericCityObjectType marshalGenericCityObject(GenericCityObject src, CityJSON cityJSON) {
        GenericCityObjectType dest = new GenericCityObjectType();
        this.marshalGenericCityObject(src, dest, cityJSON);
        return dest;
    }

    public void marshalGenericAttributes(AbstractCityObject src, Attributes dest) {
        if (src.isSetGenericAttribute()) {
            for (AbstractGenericAttribute attribute : src.getGenericAttribute()) {
                Object value = this.marshalGenericAttribute(attribute);
                if (value == null) continue;
                dest.addExtensionAttribute(attribute.getName(), value);
            }
        }
    }

    public void marshalGenericAttributes(AbstractCityObject src, SemanticsType dest) {
        if (src.isSetGenericAttribute()) {
            for (AbstractGenericAttribute attribute : src.getGenericAttribute()) {
                Object value;
                if ("type".equals(attribute.getName()) || (value = this.marshalGenericAttribute(attribute)) == null) continue;
                dest.addAttribute(attribute.getName(), value);
            }
        }
    }

    public boolean hasGenericAttributeTypes() {
        return !this.genericAttributeTypes.isEmpty();
    }

    public Map<String, GenericAttributeType> getGenericAttributeTypes() {
        return this.genericAttributeTypes;
    }

    private Object marshalGenericAttribute(AbstractGenericAttribute src) {
        GenericAttributeType type;
        if (this.json.isGenerateCityGMLMetadata() && (type = GenericAttributeType.fromType(src.getCityGMLClass())) != null) {
            this.genericAttributeTypes.put(src.getName(), type);
        }
        switch (src.getCityGMLClass()) {
            case DATE_ATTRIBUTE: {
                LocalDate date = ((DateAttribute)src).getValue();
                return date != null ? date.format(DateTimeFormatter.ISO_LOCAL_DATE) : null;
            }
            case DOUBLE_ATTRIBUTE: {
                return ((DoubleAttribute)src).getValue();
            }
            case INT_ATTRIBUTE: {
                return ((IntAttribute)src).getValue();
            }
            case STRING_ATTRIBUTE: {
                return ((StringAttribute)src).getValue();
            }
            case URI_ATTRIBUTE: {
                return ((UriAttribute)src).getValue();
            }
            case MEASURE_ATTRIBUTE: {
                Measure measure = ((MeasureAttribute)src).getValue();
                return measure != null ? Double.valueOf(measure.getValue()) : null;
            }
            case GENERIC_ATTRIBUTE_SET: {
                GenericAttributeSet attributeSet = (GenericAttributeSet)src;
                boolean isObject = attributeSet.getGenericAttribute().stream().anyMatch(a -> !"item".equalsIgnoreCase(a.getName()));
                if (isObject) {
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                    for (AbstractGenericAttribute attribute : attributeSet.getGenericAttribute()) {
                        Object value = this.marshalGenericAttribute(attribute);
                        if (value == null) continue;
                        result.put(attribute.getName(), value);
                    }
                    return result;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                for (AbstractGenericAttribute attribute : attributeSet.getGenericAttribute()) {
                    Object value = this.marshalGenericAttribute(attribute);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        }
        return null;
    }
}

