/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.landuse;

import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.LandUseType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.model.citygml.landuse.LandUse;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;

public class LandUseMarshaller {
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;

    public LandUseMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        if (src instanceof LandUse) {
            return this.marshalLandUse((LandUse)src, cityJSON);
        }
        return null;
    }

    public void marshalLandUse(LandUse src, LandUseType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfLandUse()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfLandUse(), dest, cityJSON);
        }
        if (src.isSetLod0MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod0MultiSurface())) != null) {
            geometry.setLod(0);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
    }

    public LandUseType marshalLandUse(LandUse src, CityJSON cityJSON) {
        LandUseType dest = new LandUseType();
        this.marshalLandUse(src, dest, cityJSON);
        return dest;
    }
}

