/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.transportation;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.SemanticSurfaceCollector;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractTransportationComplexType;
import org.citygml4j.cityjson.feature.RailwayType;
import org.citygml4j.cityjson.feature.RoadType;
import org.citygml4j.cityjson.feature.TransportSquareType;
import org.citygml4j.cityjson.feature.TransportationComplexAttributes;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.MultiLineStringType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.transportation.AbstractTransportationObject;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficArea;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficAreaProperty;
import org.citygml4j.model.citygml.transportation.Railway;
import org.citygml4j.model.citygml.transportation.Road;
import org.citygml4j.model.citygml.transportation.Square;
import org.citygml4j.model.citygml.transportation.TrafficArea;
import org.citygml4j.model.citygml.transportation.TrafficAreaProperty;
import org.citygml4j.model.citygml.transportation.TransportationComplex;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class TransportationMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public TransportationMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(Road.class, this::marshalRoad).with(Railway.class, this::marshalRailway).with(Square.class, this::marshalSquare);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof TrafficArea) {
            semantics = new SemanticsType("TrafficArea");
            this.marshalTrafficArea((TrafficArea)cityObject, semantics);
        } else if (cityObject instanceof AuxiliaryTrafficArea) {
            semantics = new SemanticsType("AuxiliaryTrafficArea");
            this.marshalAuxiliaryTrafficArea((AuxiliaryTrafficArea)cityObject, semantics);
        }
        if (semantics != null) {
            this.citygml.getGenericsMarshaller().marshalGenericAttributes(cityObject, semantics);
        }
        return semantics;
    }

    public void marshalAbstractTransportationObject(AbstractTransportationObject src, AbstractCityObjectType dest, CityJSON cityJSON) {
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfTransportationObject()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTransportationObject(), dest, cityJSON);
        }
    }

    public void marshalTransportationComplex(TransportationComplex src, AbstractTransportationComplexType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType abstractGeometryObjectType;
        AbstractGeometryObjectType abstractGeometryObjectType2;
        AbstractGeometryObjectType abstractGeometryObjectType3;
        MultiLineStringType multiLineStringType;
        Code surfaceMaterial;
        this.marshalAbstractTransportationObject(src, dest, cityJSON);
        TransportationComplexAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code code : src.getFunction()) {
                if (!code.isSetValue()) continue;
                attributes.setFunction(code.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code code : src.getUsage()) {
                if (!code.isSetValue()) continue;
                attributes.setUsage(code.getValue());
                break;
            }
        }
        if (src.isSetTrafficArea()) {
            for (TrafficAreaProperty trafficAreaProperty : src.getTrafficArea()) {
                if (!trafficAreaProperty.isSetTrafficArea() || !trafficAreaProperty.getTrafficArea().isSetSurfaceMaterial() || !(surfaceMaterial = trafficAreaProperty.getTrafficArea().getSurfaceMaterial()).isSetValue()) continue;
                attributes.addSurfaceMaterial(surfaceMaterial.getValue());
            }
        }
        if (src.isSetAuxiliaryTrafficArea()) {
            for (AuxiliaryTrafficAreaProperty auxiliaryTrafficAreaProperty : src.getAuxiliaryTrafficArea()) {
                if (!auxiliaryTrafficAreaProperty.isSetAuxiliaryTrafficArea() || !auxiliaryTrafficAreaProperty.getAuxiliaryTrafficArea().isSetSurfaceMaterial() || !(surfaceMaterial = auxiliaryTrafficAreaProperty.getAuxiliaryTrafficArea().getSurfaceMaterial()).isSetValue()) continue;
                attributes.addSurfaceMaterial(surfaceMaterial.getValue());
            }
        }
        if (src.isSetGenericApplicationPropertyOfTransportationComplex()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTransportationComplex(), dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetTrafficArea() || src.isSetAuxiliaryTrafficArea()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod0Network() && (multiLineStringType = this.json.getGMLMarshaller().marshalMultiLineString(src.getLod0Network())) != null) {
            multiLineStringType.setLod(0);
            dest.addGeometry(multiLineStringType);
        }
        if (src.isSetLod1MultiSurface() && (abstractGeometryObjectType3 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            abstractGeometryObjectType3.setLod(1);
            dest.addGeometry(abstractGeometryObjectType3);
        }
        if (src.isSetLod2MultiSurface() && (abstractGeometryObjectType2 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            abstractGeometryObjectType2.setLod(2);
            dest.addGeometry(abstractGeometryObjectType2);
        }
        if (src.isSetLod3MultiSurface() && (abstractGeometryObjectType = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            abstractGeometryObjectType.setLod(3);
            dest.addGeometry(abstractGeometryObjectType);
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public void marshalRoad(Road src, RoadType dest, CityJSON cityJSON) {
        this.marshalTransportationComplex(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfRoad()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfRoad(), dest, cityJSON);
        }
    }

    public RoadType marshalRoad(Road src, CityJSON cityJSON) {
        RoadType dest = new RoadType();
        this.marshalRoad(src, dest, cityJSON);
        return dest;
    }

    public void marshalRailway(Railway src, RailwayType dest, CityJSON cityJSON) {
        this.marshalTransportationComplex(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfRailway()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfRailway(), dest, cityJSON);
        }
    }

    public RailwayType marshalRailway(Railway src, CityJSON cityJSON) {
        RailwayType dest = new RailwayType();
        this.marshalRailway(src, dest, cityJSON);
        return dest;
    }

    public void marshalSquare(Square src, TransportSquareType dest, CityJSON cityJSON) {
        this.marshalTransportationComplex(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfSquare()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfSquare(), dest, cityJSON);
        }
    }

    public TransportSquareType marshalSquare(Square src, CityJSON cityJSON) {
        TransportSquareType dest = new TransportSquareType();
        this.marshalSquare(src, dest, cityJSON);
        return dest;
    }

    private void marshalTrafficArea(TrafficArea src, SemanticsType dest) {
        if (src.isSetClazz()) {
            dest.addAttribute("class", src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                dest.addAttribute("function", function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                dest.addAttribute("usage", usage.getValue());
                break;
            }
        }
        if (src.isSetSurfaceMaterial()) {
            dest.addAttribute("surfaceMaterial", src.getSurfaceMaterial().getValue());
        }
    }

    private void marshalAuxiliaryTrafficArea(AuxiliaryTrafficArea src, SemanticsType dest) {
        if (src.isSetClazz()) {
            dest.addAttribute("class", src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                dest.addAttribute("function", function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                dest.addAttribute("usage", usage.getValue());
                break;
            }
        }
        if (src.isSetSurfaceMaterial()) {
            dest.addAttribute("surfaceMaterial", src.getSurfaceMaterial().getValue());
        }
    }

    private SemanticSurfaceCollector preprocessGeometry(TransportationComplex src) {
        ArrayList<TrafficAreaProperty> properties = new ArrayList<TrafficAreaProperty>(src.getTrafficArea());
        properties.addAll(src.getAuxiliaryTrafficArea());
        SemanticSurfaceCollector collector = new SemanticSurfaceCollector(src);
        collector.collectSurfaces(properties, 2, 3);
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2MultiSurface, src::setLod2MultiSurface, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3MultiSurface, src::setLod3MultiSurface, lod);
        }
        return collector;
    }

    private void postprocessGeometry(TransportationComplex src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2MultiSurface, src::unsetLod2MultiSurface);
                continue;
            }
            collector.clean(src::getLod3MultiSurface, src::unsetLod3MultiSurface);
        }
    }
}

