/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.waterbody;

import java.util.HashMap;
import java.util.Map;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.SemanticSurfaceCollector;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.WaterBodyType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.waterbody.AbstractWaterObject;
import org.citygml4j.model.citygml.waterbody.WaterBody;
import org.citygml4j.model.citygml.waterbody.WaterClosureSurface;
import org.citygml4j.model.citygml.waterbody.WaterGroundSurface;
import org.citygml4j.model.citygml.waterbody.WaterSurface;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;

public class WaterBodyMarshaller {
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;

    public WaterBodyMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        if (src instanceof WaterBody) {
            return this.marshalWaterBody((WaterBody)src, cityJSON);
        }
        return null;
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof WaterSurface) {
            semantics = new SemanticsType("WaterSurface");
            this.marshalWaterSurface((WaterSurface)cityObject, semantics);
        } else if (cityObject instanceof WaterGroundSurface) {
            semantics = new SemanticsType("WaterGroundSurface");
        } else if (cityObject instanceof WaterClosureSurface) {
            semantics = new SemanticsType("WaterClosureSurface");
        }
        if (semantics != null) {
            this.citygml.getGenericsMarshaller().marshalGenericAttributes(cityObject, semantics);
        }
        return semantics;
    }

    public void marshalAbstractWaterObject(AbstractWaterObject src, AbstractCityObjectType dest, CityJSON cityJSON) {
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfWaterObject()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfWaterObject(), dest, cityJSON);
        }
    }

    public void marshalWaterBody(WaterBody src, WaterBodyType dest, CityJSON cityJSON) {
        AbstractGeometryObjectType abstractGeometryObjectType;
        AbstractGeometryObjectType abstractGeometryObjectType2;
        AbstractGeometryObjectType abstractGeometryObjectType3;
        AbstractGeometryObjectType abstractGeometryObjectType4;
        AbstractGeometryObjectType abstractGeometryObjectType5;
        AbstractGeometryObjectType abstractGeometryObjectType6;
        AbstractGeometryObjectType abstractGeometryObjectType7;
        this.marshalAbstractWaterObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code code : src.getFunction()) {
                if (!code.isSetValue()) continue;
                attributes.setFunction(code.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code code : src.getUsage()) {
                if (!code.isSetValue()) continue;
                attributes.setUsage(code.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfWaterBody()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfWaterBody(), dest, cityJSON);
        }
        Map<Integer, MultiSurface> multiSurfaces = null;
        if (src.isSetBoundedBySurface()) {
            multiSurfaces = this.preprocessGeometry(src);
        }
        if (multiSurfaces != null) {
            for (Map.Entry<Integer, MultiSurface> entry : multiSurfaces.entrySet()) {
                AbstractGeometryObjectType geometry2 = this.json.getGMLMarshaller().marshal(entry.getValue());
                if (geometry2 == null) continue;
                geometry2.setLod(entry.getKey());
                dest.addGeometry(geometry2);
            }
        }
        if (src.isSetLod0MultiCurve() && (abstractGeometryObjectType7 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod0MultiCurve())) != null) {
            abstractGeometryObjectType7.setLod(0);
            dest.addGeometry(abstractGeometryObjectType7);
        }
        if (src.isSetLod1MultiCurve() && (abstractGeometryObjectType6 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiCurve())) != null) {
            abstractGeometryObjectType6.setLod(1);
            dest.addGeometry(abstractGeometryObjectType6);
        }
        if (src.isSetLod0MultiSurface() && (abstractGeometryObjectType5 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod0MultiSurface())) != null) {
            abstractGeometryObjectType5.setLod(0);
            dest.addGeometry(abstractGeometryObjectType5);
        }
        if (src.isSetLod1MultiSurface() && (abstractGeometryObjectType4 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            abstractGeometryObjectType4.setLod(1);
            dest.addGeometry(abstractGeometryObjectType4);
        }
        if (src.isSetLod1Solid() && (abstractGeometryObjectType3 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Solid())) != null) {
            abstractGeometryObjectType3.setLod(1);
            dest.addGeometry(abstractGeometryObjectType3);
        }
        if (src.isSetLod2Solid() && (abstractGeometryObjectType2 = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Solid())) != null) {
            abstractGeometryObjectType2.setLod(2);
            dest.addGeometry(abstractGeometryObjectType2);
        }
        if (src.isSetLod3Solid() && (abstractGeometryObjectType = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Solid())) != null) {
            abstractGeometryObjectType.setLod(3);
            dest.addGeometry(abstractGeometryObjectType);
        }
    }

    public WaterBodyType marshalWaterBody(WaterBody src, CityJSON cityJSON) {
        WaterBodyType dest = new WaterBodyType();
        this.marshalWaterBody(src, dest, cityJSON);
        return dest;
    }

    private void marshalWaterSurface(WaterSurface src, SemanticsType dest) {
        if (src.isSetWaterLevel()) {
            dest.addAttribute("waterLevel", src.getWaterLevel().getValue());
        }
    }

    private Map<Integer, MultiSurface> preprocessGeometry(WaterBody src) {
        HashMap<Integer, MultiSurface> multiSurfaces = new HashMap<Integer, MultiSurface>();
        SemanticSurfaceCollector collector = new SemanticSurfaceCollector(src);
        collector.collectSurfaces(src.getBoundedBySurface(), 2, 3);
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            multiSurfaces.put(lod, collector.getSurfaces(lod));
        }
        return multiSurfaces;
    }
}

