/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.citygml4j.builder.copy.ShallowCopyBuilder;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.OrientableSurface;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.model.gml.geometry.primitives.Surface;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.util.walker.GeometryWalker;

public class SemanticSurfaceCollector {
    private final SurfaceWalker walker;

    public SemanticSurfaceCollector(AbstractCityObject parent) {
        this.walker = new SurfaceWalker(parent);
    }

    public void collectSurfaces(AbstractCityObject boundarySurface, int minLod, int maxLod) {
        LodRepresentation lods = boundarySurface.getLodRepresentation();
        for (int lod = minLod; lod <= maxLod; ++lod) {
            if (!lods.isSetGeometry(lod)) continue;
            this.walker.lod = lod;
            for (GeometryProperty<? extends AbstractGeometry> geometryProperty : lods.getGeometry(lod)) {
                this.walker.visit(geometryProperty);
            }
        }
    }

    public void collectSurfaces(List<? extends FeatureProperty<?>> properties, int minLod, int maxLod) {
        if (properties != null) {
            for (FeatureProperty<?> property : properties) {
                if (!(property.getFeature() instanceof AbstractCityObject)) continue;
                this.collectSurfaces((AbstractCityObject)property.getFeature(), minLod, maxLod);
            }
        }
    }

    public boolean hasSurfaces(int lod) {
        return this.walker.surfaces.containsKey(lod);
    }

    public void assignSurfaces(GeometryPropertyGetter getter, MultiSurfacePropertySetter setter, int lod) {
        MultiSurface multiSurface;
        GeometryProperty<? extends AbstractGeometry> property = getter.get();
        if (property != null && property.isSetGeometry() && property.getGeometry() instanceof MultiSurface) {
            multiSurface = (MultiSurface)property.getGeometry();
        } else {
            multiSurface = new MultiSurface();
            multiSurface.setLocalProperty("org.citygml4j.geometry.dummy", true);
            setter.set(new MultiSurfaceProperty(multiSurface));
        }
        multiSurface.getSurfaceMember().addAll(this.getSurfaceProperties(lod));
    }

    public MultiSurface getSurfaces(int lod) {
        MultiSurface multiSurface = new MultiSurface();
        multiSurface.setLocalProperty("org.citygml4j.geometry.dummy", true);
        multiSurface.getSurfaceMember().addAll(this.getSurfaceProperties(lod));
        return multiSurface;
    }

    public void clean(GeometryPropertyGetter getter, GeometryPropertyUnsetter unsetter) {
        GeometryProperty<? extends AbstractGeometry> property = getter.get();
        if (property != null && property.isSetGeometry() && property.getGeometry() instanceof MultiSurface) {
            MultiSurface multiSurface = (MultiSurface)property.getGeometry();
            if (multiSurface.hasLocalProperty("org.citygml4j.geometry.dummy")) {
                unsetter.unset();
            } else {
                multiSurface.getSurfaceMember().removeIf(p -> p.hasLocalProperty("org.citygml4j.geometry.dummy"));
            }
        }
    }

    private List<SurfaceProperty> getSurfaceProperties(int lod) {
        ArrayList<SurfaceProperty> properties = new ArrayList<SurfaceProperty>();
        Collection surfaces = (Collection)this.walker.surfaces.get(lod);
        if (surfaces != null) {
            for (AbstractSurface surface : surfaces) {
                SurfaceProperty property = new SurfaceProperty();
                property.setLocalProperty("org.citygml4j.geometry.dummy", true);
                property.setLocalProperty("org.citygml4j.geometry.xlink", surface);
                properties.add(property);
            }
        }
        return properties;
    }

    @FunctionalInterface
    public static interface GeometryPropertyUnsetter {
        public void unset();
    }

    @FunctionalInterface
    public static interface MultiSurfacePropertySetter {
        public void set(MultiSurfaceProperty var1);
    }

    @FunctionalInterface
    public static interface GeometryPropertyGetter {
        public GeometryProperty<? extends AbstractGeometry> get();
    }

    private static final class SurfaceWalker
    extends GeometryWalker {
        private final Map<Integer, List<AbstractSurface>> surfaces = new HashMap<Integer, List<AbstractSurface>>();
        private final ShallowCopyBuilder copyBuilder = new ShallowCopyBuilder();
        private final Set<String> parentGeometryIds = new HashSet<String>();
        private int lod;

        SurfaceWalker(AbstractCityObject parent) {
            GeometryWalker walker = new GeometryWalker(){

                @Override
                public void visit(AbstractGeometry geometry) {
                    if (geometry.isSetId()) {
                        parentGeometryIds.add(geometry.getId());
                    }
                    super.visit(geometry);
                }

                @Override
                public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
                    if (property.hasLocalProperty("org.citygml4j.geometry.xlink")) {
                        AbstractGeometry geometry = (AbstractGeometry)property.getLocalProperty("org.citygml4j.geometry.xlink");
                        parentGeometryIds.add(geometry.getId());
                    } else {
                        super.visit(property);
                    }
                }
            };
            LodRepresentation lods = parent.getLodRepresentation();
            for (int lod = 2; lod < 4; ++lod) {
                if (!lods.isSetGeometry(lod)) continue;
                for (GeometryProperty<? extends AbstractGeometry> geometryProperty : lods.getGeometry(lod)) {
                    walker.visit(geometryProperty);
                }
            }
        }

        @Override
        public void visit(OrientableSurface surface) {
            this.collect(surface);
        }

        @Override
        public void visit(Surface surface) {
            this.collect(surface);
        }

        @Override
        public void visit(Polygon surface) {
            this.collect(surface);
        }

        @Override
        public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
            if (!property.isSetGeometry() && property.hasLocalProperty("org.citygml4j.geometry.xlink")) {
                AbstractGeometry geometry = (AbstractGeometry)property.getLocalProperty("org.citygml4j.geometry.xlink");
                geometry = (AbstractGeometry)geometry.copy(this.copyBuilder);
                geometry.setParent(property);
                geometry.accept(this);
            } else {
                super.visit(property);
            }
        }

        private void collect(AbstractSurface surface) {
            if (!surface.isSetId() || !this.parentGeometryIds.contains(surface.getId())) {
                this.surfaces.computeIfAbsent(this.lod, k -> new ArrayList()).add(surface);
            }
        }
    }
}

