/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.appearance.AppearanceUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.bridge.BridgeUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.building.BuildingUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.cityfurniture.CityFurnitureUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.cityobjectgroup.CityObjectGroupUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.core.CoreUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.generics.GenericsUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.landuse.LandUseUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.relief.ReliefUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.transportation.TransportationUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.tunnel.TunnelUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.vegetation.VegetationUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.waterbody.WaterBodyUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractTransportationComplexType;
import org.citygml4j.cityjson.feature.AbstractVegetationObjectType;
import org.citygml4j.cityjson.feature.BridgeType;
import org.citygml4j.cityjson.feature.BuildingType;
import org.citygml4j.cityjson.feature.CityFurnitureType;
import org.citygml4j.cityjson.feature.CityObjectGroupType;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.feature.LandUseType;
import org.citygml4j.cityjson.feature.TINReliefType;
import org.citygml4j.cityjson.feature.TunnelType;
import org.citygml4j.cityjson.feature.WaterBodyType;
import org.citygml4j.cityjson.geometry.AbstractSemanticsObject;
import org.citygml4j.cityjson.geometry.InternalSemanticsType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.bridge.BridgeModuleComponent;
import org.citygml4j.model.citygml.building.BuildingModuleComponent;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.transportation.TransportationModuleComponent;
import org.citygml4j.model.citygml.tunnel.TunnelModuleComponent;
import org.citygml4j.model.citygml.waterbody.WaterBodyModuleComponent;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;

public class CityGMLUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final AppearanceUnmarshaller app;
    private final BridgeUnmarshaller brid;
    private final BuildingUnmarshaller bldg;
    private final CityFurnitureUnmarshaller frn;
    private final CityObjectGroupUnmarshaller grp;
    private final CoreUnmarshaller core;
    private final GenericsUnmarshaller gen;
    private final LandUseUnmarshaller luse;
    private final ReliefUnmarshaller dem;
    private final TransportationUnmarshaller tran;
    private final TunnelUnmarshaller tun;
    private final VegetationUnmarshaller veg;
    private final WaterBodyUnmarshaller wtr;

    public CityGMLUnmarshaller(CityJSONUnmarshaller json) {
        this.json = json;
        this.app = new AppearanceUnmarshaller(this);
        this.brid = new BridgeUnmarshaller(this);
        this.bldg = new BuildingUnmarshaller(this);
        this.frn = new CityFurnitureUnmarshaller(this);
        this.grp = new CityObjectGroupUnmarshaller(this);
        this.core = new CoreUnmarshaller(this);
        this.gen = new GenericsUnmarshaller(this);
        this.luse = new LandUseUnmarshaller(this);
        this.dem = new ReliefUnmarshaller(this);
        this.tran = new TransportationUnmarshaller(this);
        this.tun = new TunnelUnmarshaller(this);
        this.veg = new VegetationUnmarshaller(this);
        this.wtr = new WaterBodyUnmarshaller(this);
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        AbstractCityObject dest = null;
        if (src instanceof BridgeType) {
            dest = this.brid.unmarshal(src, cityJSON);
        } else if (src instanceof BuildingType) {
            dest = this.bldg.unmarshal(src, cityJSON);
        } else if (src instanceof CityFurnitureType) {
            dest = this.frn.unmarshalCityFurniture((CityFurnitureType)src, cityJSON);
        } else if (src instanceof CityObjectGroupType) {
            dest = this.grp.unmarshalCityObjectGroup((CityObjectGroupType)src, cityJSON);
        } else if (src instanceof GenericCityObjectType) {
            dest = this.gen.unmarshalGenericCityObject((GenericCityObjectType)src, cityJSON);
        } else if (src instanceof LandUseType) {
            dest = this.luse.unmarshalLandUse((LandUseType)src, cityJSON);
        } else if (src instanceof TINReliefType) {
            dest = this.dem.unmarshalTINRelief((TINReliefType)src, cityJSON);
        } else if (src instanceof AbstractTransportationComplexType) {
            dest = this.tran.unmarshal(src, cityJSON);
        } else if (src instanceof TunnelType) {
            dest = this.tun.unmarshal(src, cityJSON);
        } else if (src instanceof AbstractVegetationObjectType) {
            dest = this.veg.unmarshal(src, cityJSON);
        } else if (src instanceof WaterBodyType) {
            dest = this.wtr.unmarshalWaterBody((WaterBodyType)src, cityJSON);
        }
        return dest;
    }

    public void unmarshalSemantics(AbstractSemanticsObject src, Map<Integer, List<AbstractSurface>> surfaces, Number lod, AbstractCityObject root) {
        HashMap<Integer, AbstractCityObject> parents = new HashMap<Integer, AbstractCityObject>();
        List<Integer> indexes = this.orderByParents(src);
        for (int index : indexes) {
            SemanticsType semanticsType = src.getSurfaces().get(index);
            if (semanticsType == null) continue;
            List<AbstractSurface> tmp = surfaces.get(index);
            if (tmp == null) {
                if (!semanticsType.isSetChildren()) continue;
                tmp = Collections.emptyList();
            }
            AbstractCityObject parent = null;
            if (semanticsType.isSetParent()) {
                parent = (AbstractCityObject)parents.get(semanticsType.getParent());
            }
            if (parent == null) {
                parent = root;
            }
            AbstractCityObject cityObject = null;
            Class<? extends SemanticsType> semanticsTypeClass = this.json.getCityJSONRegistry().getSemanticSurfaceClass(semanticsType.getType());
            if (semanticsTypeClass != InternalSemanticsType.class) {
                cityObject = this.json.getADEUnmarshaller().unmarshalSemanticSurface(semanticsType, tmp, lod, parent);
            } else if (parent instanceof BridgeModuleComponent) {
                cityObject = this.brid.unmarshalSemantics(semanticsType, tmp, lod, parent);
            } else if (parent instanceof BuildingModuleComponent) {
                cityObject = this.bldg.unmarshalSemantics(semanticsType, tmp, lod, parent);
            } else if (parent instanceof TransportationModuleComponent) {
                cityObject = this.tran.unmarshalSemantics(semanticsType, tmp, lod, parent);
            } else if (parent instanceof TunnelModuleComponent) {
                cityObject = this.tun.unmarshalSemantics(semanticsType, tmp, lod, parent);
            } else if (parent instanceof WaterBodyModuleComponent) {
                cityObject = this.wtr.unmarshalSemantics(semanticsType, tmp, lod, parent);
            }
            if (cityObject == null) continue;
            parents.put(index, cityObject);
        }
    }

    private List<Integer> orderByParents(AbstractSemanticsObject semanticsObject) {
        HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
        for (int i = 0; i < semanticsObject.getNumSurfaces(); ++i) {
            SemanticsType type = semanticsObject.getSurfaces().get(i);
            int weight = 0;
            SemanticsType parent = type;
            while (parent != null && parent.isSetParent()) {
                parent = semanticsObject.getSurfaces().get(parent.getParent());
                ++weight;
            }
            indexes.put(i, weight);
        }
        return indexes.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public AppearanceUnmarshaller getAppearanceUnmarshaller() {
        return this.app;
    }

    public BridgeUnmarshaller getBridgeUnmarshaller() {
        return this.brid;
    }

    public BuildingUnmarshaller getBuildingUnmarshaller() {
        return this.bldg;
    }

    public CityFurnitureUnmarshaller getCityFurnitureUnmarshaller() {
        return this.frn;
    }

    public CityObjectGroupUnmarshaller getCiyCityObjectGroupUnmarshaller() {
        return this.grp;
    }

    public CoreUnmarshaller getCoreUnmarshaller() {
        return this.core;
    }

    public GenericsUnmarshaller getGenericsUnmarshaller() {
        return this.gen;
    }

    public LandUseUnmarshaller getLandUseUnmarshaller() {
        return this.luse;
    }

    public ReliefUnmarshaller getReliefUnmarshaller() {
        return this.dem;
    }

    public TransportationUnmarshaller getTransportationUnmarshaller() {
        return this.tran;
    }

    public VegetationUnmarshaller getVegetationUnmarshaller() {
        return this.veg;
    }

    public WaterBodyUnmarshaller getWaterBodyUnmarshaller() {
        return this.wtr;
    }

    public CityJSONUnmarshaller getCityJSONUnmarshaller() {
        return this.json;
    }
}

