/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.ade;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.citygml4j.CityGMLContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtension;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionModule;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionUnmarshaller;
import org.citygml4j.builder.cityjson.extension.CityObjectContext;
import org.citygml4j.builder.cityjson.extension.ExtensionPropertyContext;
import org.citygml4j.builder.cityjson.extension.SemanticSurfaceContext;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.ade.ADEUnmarshallerHelper;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;

public class ADEUnmarshaller {
    private final CityJSONUnmarshaller json;
    private Map<String, CityJSONExtensionUnmarshaller> unmarshallersByType;
    private Map<Class<? extends ExtensibleType>, Map<String, CityJSONExtensionUnmarshaller>> unmarshallersByProperty;
    private Map<String, CityJSONExtensionUnmarshaller> unmarshallersByPackage;

    public ADEUnmarshaller(CityJSONUnmarshaller json) {
        this.json = json;
        CityGMLContext context = CityGMLContext.getInstance();
        if (context.hasCityJSONExtensionContexts()) {
            this.unmarshallersByType = new HashMap<String, CityJSONExtensionUnmarshaller>();
            this.unmarshallersByProperty = new HashMap<Class<? extends ExtensibleType>, Map<String, CityJSONExtensionUnmarshaller>>();
            this.unmarshallersByPackage = new HashMap<String, CityJSONExtensionUnmarshaller>();
            ADEUnmarshallerHelper helper = new ADEUnmarshallerHelper(json);
            for (ADEContext adeContext : context.getADEContexts()) {
                CityJSONExtension extension;
                CityJSONExtensionUnmarshaller unmarshaller;
                if (!(adeContext instanceof CityJSONExtensionContext) || (unmarshaller = (extension = ((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension()).createExtensionUnmarshaller()) == null) continue;
                unmarshaller.setADEUnmarshallerHelper(helper);
                for (CityJSONExtensionModule module : extension.getExtensionModules()) {
                    Map<Class<? extends ExtensibleType>, Map<String, Type>> map;
                    Map<String, Class<? extends SemanticsType>> semanticSurfaces;
                    Map<String, Class<? extends AbstractCityObjectType>> cityObjects = module.getCityObjects();
                    if (cityObjects != null) {
                        for (String string : cityObjects.keySet()) {
                            this.unmarshallersByType.put(string, unmarshaller);
                        }
                    }
                    if ((semanticSurfaces = module.getSemanticSurfaces()) != null) {
                        for (String type2 : semanticSurfaces.keySet()) {
                            this.unmarshallersByType.put(type2 + "\"surface\"", unmarshaller);
                        }
                    }
                    if ((map = module.getExtensionProperties()) == null) continue;
                    for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : map.entrySet()) {
                        for (String name : entry.getValue().keySet()) {
                            Map unmarshallers = this.unmarshallersByProperty.computeIfAbsent(entry.getKey(), v -> new ConcurrentHashMap());
                            unmarshallers.put(name, unmarshaller);
                        }
                    }
                }
                for (String packageName : adeContext.getModelPackageNames()) {
                    this.unmarshallersByPackage.put(packageName, unmarshaller);
                }
            }
        }
    }

    public AbstractFeature unmarshalCityObject(AbstractCityObjectType src, CityJSON cityJSON, AbstractFeature parent) {
        if (this.unmarshallersByType != null) {
            CityJSONExtensionUnmarshaller unmarshaller = this.unmarshallersByType.get(src.getType());
            if (unmarshaller != null) {
                return unmarshaller.unmarshalCityObject(src, new CityObjectContext(parent, cityJSON));
            }
        } else if (src.hasLocalProperty("org.citygml4j.unknownExtension") && src instanceof GenericCityObjectType) {
            GenericCityObject dest = this.json.getCityGMLUnmarshaller().getGenericsUnmarshaller().unmarshalGenericCityObject((GenericCityObjectType)src, cityJSON);
            String type = src.getType();
            if (type.startsWith("+")) {
                type = type.substring(1);
            }
            dest.setClazz(new Code(type));
            dest.setLocalProperty("org.citygml4j.unknownExtension", true);
            this.json.getCityGMLUnmarshaller().getCoreUnmarshaller().unmarshalAsGlobalFeature(dest);
            return dest;
        }
        return null;
    }

    public AbstractCityObject unmarshalSemanticSurface(SemanticsType src, List<AbstractSurface> surfaces, Number lod, AbstractCityObject parent) {
        CityJSONExtensionUnmarshaller unmarshaller;
        if (this.unmarshallersByType != null && (unmarshaller = this.unmarshallersByType.get(src.getType() + "\"surface\"")) != null) {
            return unmarshaller.unmarshalSemanticSurface(src, new SemanticSurfaceContext(surfaces, lod, parent));
        }
        return null;
    }

    public boolean assignSemanticSurface(AbstractCityObject semanticSurface, Number lod, AbstractCityObject parent) {
        CityJSONExtensionUnmarshaller unmarshaller;
        if (this.unmarshallersByPackage != null && (unmarshaller = this.unmarshallersByPackage.get(parent.getClass().getPackage().getName())) != null) {
            return unmarshaller.assignSemanticSurface(semanticSurface, new SemanticSurfaceContext(lod, parent));
        }
        return false;
    }

    public void unmarshalExtensionProperty(String name, Object value, ExtensibleType src, CityJSON cityJSON, AbstractFeature parent) {
        if (this.unmarshallersByProperty != null) {
            for (Map.Entry<Class<? extends ExtensibleType>, Map<String, CityJSONExtensionUnmarshaller>> entry : this.unmarshallersByProperty.entrySet()) {
                CityJSONExtensionUnmarshaller unmarshaller;
                if (!entry.getKey().isAssignableFrom(src.getClass()) || (unmarshaller = entry.getValue().get(name)) == null) continue;
                unmarshaller.unmarshalExtensionProperty(name, new ExtensionPropertyContext(value, cityJSON, parent));
            }
        }
    }
}

