/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.generics;

import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.builder.cityjson.util.GenericAttributeType;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.citygml.generics.DateAttribute;
import org.citygml4j.model.citygml.generics.DoubleAttribute;
import org.citygml4j.model.citygml.generics.GenericAttributeSet;
import org.citygml4j.model.citygml.generics.GenericCityObject;
import org.citygml4j.model.citygml.generics.IntAttribute;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.citygml.generics.UriAttribute;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.GeometryProperty;

public class GenericsUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;
    private Map<String, GenericAttributeType> genericAttributeTypes;

    public GenericsUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    public void setGenericAttributeTypes(Map<String, GenericAttributeType> genericAttributeTypes) {
        this.genericAttributeTypes = genericAttributeTypes;
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        if (src instanceof GenericCityObjectType) {
            return this.unmarshalGenericCityObject((GenericCityObjectType)src, cityJSON);
        }
        return null;
    }

    public void unmarshalGenericCityObject(GenericCityObjectType src, GenericCityObject dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGML geometry;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                if (geometry == null) continue;
                int lod = geometryObject.getLod().intValue();
                switch (lod) {
                    case 0: {
                        dest.setLod0Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 1: {
                        dest.setLod1Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 2: {
                        dest.setLod2Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 3: {
                        dest.setLod3Geometry(new GeometryProperty<AbstractGML>(geometry));
                    }
                }
                continue;
            }
            if (!(geometryType instanceof GeometryInstanceType)) continue;
            GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
            geometry = this.citygml.getCoreUnmarshaller().unmarshalGeometryInstance(geometryInstance);
            if (geometry == null) continue;
            switch ((Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod")) {
                case 0: {
                    dest.setLod1ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 1: {
                    dest.setLod1ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 2: {
                    dest.setLod2ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 3: {
                    dest.setLod3ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                }
            }
        }
    }

    public GenericCityObject unmarshalGenericCityObject(GenericCityObjectType src, CityJSON cityJSON) {
        GenericCityObject dest = new GenericCityObject();
        this.unmarshalGenericCityObject(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalGenericAttribute(String name, Object value, AbstractCityObject dest) {
        AbstractGenericAttribute attribute = this.unmarshalGenericAttribute(name, value);
        if (attribute != null) {
            dest.addGenericAttribute(attribute);
        }
    }

    public void unmarshalGenericAttributes(Map<String, Object> src, AbstractCityObject dest) {
        for (Map.Entry<String, Object> property : src.entrySet()) {
            AbstractGenericAttribute attribute = this.unmarshalGenericAttribute(property.getKey(), property.getValue());
            if (attribute == null) continue;
            dest.addGenericAttribute(attribute);
        }
    }

    private AbstractGenericAttribute unmarshalGenericAttribute(Object name, Object value) {
        AbstractGenericAttribute attribute;
        if (value == null) {
            return null;
        }
        GenericAttributeType type = this.genericAttributeTypes != null ? this.genericAttributeTypes.get(name.toString()) : null;
        AbstractGenericAttribute abstractGenericAttribute = attribute = type != null ? this.unmarshalTypedGenericAttribute(name, value, type) : this.unmarshalUntypedGenericAttribute(name, value);
        if (attribute != null) {
            String attrName = name.toString();
            if (attrName.startsWith("+")) {
                attrName = attrName.substring(1);
            }
            attribute.setName(attrName);
        }
        return attribute;
    }

    private AbstractGenericAttribute unmarshalTypedGenericAttribute(Object name, Object value, GenericAttributeType type) {
        try {
            switch (type) {
                case INT_ATTRIBUTE: {
                    int intValue = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                    return new IntAttribute(intValue);
                }
                case MEASURE_ATTRIBUTE: 
                case DOUBLE_ATTRIBUTE: {
                    double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                    return new DoubleAttribute(doubleValue);
                }
                case DATE_ATTRIBUTE: {
                    return new DateAttribute((LocalDate)value);
                }
                case STRING_ATTRIBUTE: {
                    return new StringAttribute(value.toString());
                }
                case URI_ATTRIBUTE: {
                    return new UriAttribute(value.toString());
                }
                case GENERIC_ATTRIBUTE_SET: {
                    return this.unmarshalGenericAttributeSet(value);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private AbstractGenericAttribute unmarshalUntypedGenericAttribute(Object name, Object value) {
        if (value instanceof Integer) {
            return new IntAttribute((Integer)value);
        }
        if (value instanceof Double) {
            return new DoubleAttribute((Double)value);
        }
        if (value instanceof LocalDate) {
            return new DateAttribute((LocalDate)value);
        }
        if (value instanceof String) {
            try {
                URI uri = new URI((String)value);
                if (uri.getScheme() != null && uri.getPath() != null) {
                    return new UriAttribute((String)value);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new StringAttribute((String)value);
        }
        if (value instanceof Map || value instanceof Collection || value.getClass().isArray()) {
            return this.unmarshalGenericAttributeSet(value);
        }
        return new StringAttribute(value.toString());
    }

    private GenericAttributeSet unmarshalGenericAttributeSet(Object value) {
        GenericAttributeSet attributeSet;
        block4: {
            block5: {
                block3: {
                    attributeSet = new GenericAttributeSet();
                    if (!(value instanceof Map)) break block3;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        AbstractGenericAttribute item = this.unmarshalGenericAttribute(entry.getKey(), entry.getValue());
                        if (item == null) continue;
                        attributeSet.addGenericAttribute(item);
                    }
                    break block4;
                }
                if (!(value instanceof Collection)) break block5;
                for (Object object : (Collection)value) {
                    AbstractGenericAttribute item = this.unmarshalGenericAttribute("item", object);
                    if (item == null) continue;
                    attributeSet.addGenericAttribute(item);
                }
                break block4;
            }
            if (!value.getClass().isArray()) break block4;
            for (int i = 0; i < Array.getLength(value); ++i) {
                AbstractGenericAttribute item = this.unmarshalGenericAttribute("item", Array.get(value, i));
                if (item == null) continue;
                attributeSet.addGenericAttribute(item);
            }
        }
        return attributeSet;
    }
}

