/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.copy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;

public abstract class CopyBuilder {
    private HashSet<Class<?>> shallowCopy = new HashSet();
    private HashSet<Class<?>> nullCopy = new HashSet();

    public Object copy(Object target) {
        if (target instanceof String) {
            return this.copy((String)target);
        }
        if (target instanceof Number) {
            return this.copy((Number)target);
        }
        if (target instanceof Boolean) {
            return this.copy((Boolean)target);
        }
        if (target instanceof Character) {
            return this.copy((Character)target);
        }
        if (target instanceof Void) {
            return this.copy((Void)target);
        }
        if (target instanceof Cloneable) {
            try {
                return this.copyCloneable((Cloneable)target);
            }
            catch (UnsupportedOperationException e) {
                return target;
            }
        }
        return target;
    }

    public void setShallowCopy(Class<?> ... c) {
        this.shallowCopy.addAll(Arrays.asList(c));
    }

    public void setNullCopy(Class<?> ... c) {
        this.nullCopy.addAll(Arrays.asList(c));
    }

    public void unsetShallowCopy(Class<?> ... c) {
        for (Class<?> item : c) {
            this.shallowCopy.remove(item);
        }
    }

    public void unsetNullCopy(Class<?> ... c) {
        for (Class<?> item : c) {
            this.nullCopy.remove(item);
        }
    }

    protected boolean isNullCopy(Object target) {
        if (target == null) {
            return true;
        }
        if (this.nullCopy.contains(target.getClass())) {
            return true;
        }
        for (Class<?> c : target.getClass().getInterfaces()) {
            if (!this.nullCopy.contains(c)) continue;
            return true;
        }
        return false;
    }

    protected boolean isShallowCopy(Object target) {
        if (this.shallowCopy.contains(target.getClass())) {
            return true;
        }
        for (Class<?> c : target.getClass().getInterfaces()) {
            if (!this.shallowCopy.contains(c)) continue;
            return true;
        }
        return false;
    }

    protected boolean shallowSetContains(Class<?> c) {
        return this.shallowCopy.contains(c);
    }

    public String copy(String value) {
        return value != null ? (this.nullCopy.contains(value.getClass()) ? null : value) : null;
    }

    public Number copy(Number value) {
        return value != null ? (Number)(this.nullCopy.contains(value.getClass()) ? (Number)null : (Number)value) : (Number)null;
    }

    public Boolean copy(Boolean value) {
        return value != null ? (this.nullCopy.contains(value.getClass()) ? null : value) : null;
    }

    public Character copy(Character value) {
        return value != null ? (this.nullCopy.contains(value.getClass()) ? null : value) : null;
    }

    public Void copy(Void value) {
        return null;
    }

    public Class<?> copy(Class<?> value) {
        return value != null ? (this.nullCopy.contains(value) ? null : value) : null;
    }

    public long copy(long value) {
        return value;
    }

    public int copy(int value) {
        return value;
    }

    public short copy(short value) {
        return value;
    }

    public char copy(char value) {
        return value;
    }

    public byte copy(byte value) {
        return value;
    }

    public double copy(double value) {
        return value;
    }

    public float copy(float value) {
        return value;
    }

    public boolean copy(boolean value) {
        return value;
    }

    public Object[] copy(Object[] array) {
        Object[] copy = new Object[array.length];
        for (int index = 0; index < array.length; ++index) {
            Object itemCopy;
            Object item = array[index];
            copy[index] = itemCopy = this.copy(item);
        }
        return copy;
    }

    public long[] copy(long[] array) {
        long[] copy = new long[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public int[] copy(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public short[] copy(short[] array) {
        short[] copy = new short[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public char[] copy(char[] array) {
        char[] copy = new char[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public byte[] copy(byte[] array) {
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public double[] copy(double[] array) {
        double[] copy = new double[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public float[] copy(float[] array) {
        float[] copy = new float[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public boolean[] copy(boolean[] array) {
        boolean[] copy = new boolean[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public Object copyCloneable(Cloneable object) {
        Method method = null;
        try {
            method = object.getClass().getMethod("clone", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null || !Modifier.isPublic(method.getModifiers())) {
            throw new UnsupportedOperationException("Could not clone object [" + object + "].", new CloneNotSupportedException("Object class [" + object.getClass() + "] implements java.lang.Cloneable interface, but does not provide a public no-arg clone() method. By convention, classes that implement java.lang.Cloneable should override java.lang.Object.clone() method (which is protected) with a public method."));
        }
        boolean wasAccessible = method.isAccessible();
        try {
            if (!wasAccessible) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            Object object2 = method.invoke((Object)object, (Object[])null);
            return object2;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Could not clone the object [" + object + "] as invocation of the clone() method has thrown an exception.", ex);
        }
        finally {
            if (!wasAccessible) {
                try {
                    method.setAccessible(false);
                }
                catch (SecurityException securityException) {}
            }
        }
    }
}

