/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.ade.ADEMarshaller;
import org.citygml4j.builder.jaxb.marshal.gml.GMLMarshaller;
import org.citygml4j.builder.jaxb.marshal.xal.XALMarshaller;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.module.ModuleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBMarshaller {
    private final CityGMLMarshaller citygml;
    private final GMLMarshaller gml;
    private final XALMarshaller xal;
    private final ADEMarshaller ade;
    private final CityGMLBuilder builder;
    private final DatatypeFactory dataTypeFactory;
    private ModuleContext moduleContext;
    private Document document;

    public JAXBMarshaller(CityGMLBuilder builder, ModuleContext moduleContext) {
        this.builder = builder;
        this.moduleContext = moduleContext;
        this.citygml = new CityGMLMarshaller(this);
        this.gml = new GMLMarshaller(this);
        this.xal = new XALMarshaller();
        this.ade = new ADEMarshaller(this);
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Failed to create DatatypeFactory.", e);
        }
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        JAXBElement<?> dest = null;
        if (src instanceof ADEModelObject) {
            dest = this.ade.marshalJAXBElement((ADEModelObject)src);
        } else {
            dest = this.citygml.marshalJAXBElement(src);
            if (dest == null) {
                dest = this.gml.marshalJAXBElement(src);
            }
            if (dest == null) {
                dest = this.xal.marshalJAXBElement(src);
            }
        }
        return dest;
    }

    public Element marshalDOMElement(ModelObject src) {
        Element dest = null;
        try {
            if (this.document == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                this.document = docBuilder.newDocument();
            }
            dest = this.marshalDOMElement(src, this.document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dest;
    }

    public Element marshalDOMElement(ModelObject src, Document document) {
        Element dest = null;
        try {
            Node child;
            JAXBElement<?> jaxbElement;
            Marshaller marshaller = this.builder.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            Element foo = document.createElement("foo");
            JAXBElement<?> jAXBElement = jaxbElement = src instanceof JAXBElement ? (JAXBElement<?>)((Object)src) : this.marshalJAXBElement(src);
            if (jaxbElement != null) {
                marshaller.marshal(jaxbElement, foo);
            }
            if ((child = foo.getFirstChild()) instanceof Element) {
                dest = (Element)child;
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return dest;
    }

    public Element marshalDOMElement(JAXBElement<?> src, JAXBContext ctx) {
        Element dest = null;
        try {
            if (this.document == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                this.document = docBuilder.newDocument();
            }
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            Element foo = this.document.createElement("foo");
            marshaller.marshal(src, foo);
            Node child = foo.getFirstChild();
            if (child instanceof Element) {
                dest = (Element)child;
            }
        }
        catch (JAXBException | ParserConfigurationException exception) {
            // empty catch block
        }
        return dest;
    }

    public Object marshal(ModelObject src) {
        Object dest = null;
        if (src instanceof ADEModelObject) {
            dest = this.ade.marshal((ADEModelObject)src);
        } else {
            dest = this.citygml.marshal(src);
            if (dest == null) {
                dest = this.gml.marshal(src);
            }
            if (dest == null) {
                dest = this.xal.marshal(src);
            }
        }
        return dest;
    }

    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    public void setModuleContext(ModuleContext moduleContext) {
        if (moduleContext == null) {
            throw new IllegalArgumentException("module context may not be null.");
        }
        this.moduleContext = moduleContext;
    }

    public DatatypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public CityGMLMarshaller getCityGMLMarshaller() {
        return this.citygml;
    }

    public GMLMarshaller getGMLMarshaller() {
        return this.gml;
    }

    public XALMarshaller getXALMarshaller() {
        return this.xal;
    }

    public ADEMarshaller getADEMarshaller() {
        return this.ade;
    }
}

