/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal.citygml.building;

import java.math.BigInteger;
import java.time.LocalDate;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml.building._1.AbstractBoundarySurfaceType;
import net.opengis.citygml.building._1.AbstractBuildingType;
import net.opengis.citygml.building._1.AbstractOpeningType;
import net.opengis.citygml.building._1.BoundarySurfacePropertyType;
import net.opengis.citygml.building._1.BuildingFurnitureType;
import net.opengis.citygml.building._1.BuildingInstallationPropertyType;
import net.opengis.citygml.building._1.BuildingInstallationType;
import net.opengis.citygml.building._1.BuildingPartPropertyType;
import net.opengis.citygml.building._1.BuildingPartType;
import net.opengis.citygml.building._1.BuildingType;
import net.opengis.citygml.building._1.CeilingSurfaceType;
import net.opengis.citygml.building._1.ClosureSurfaceType;
import net.opengis.citygml.building._1.DoorType;
import net.opengis.citygml.building._1.FloorSurfaceType;
import net.opengis.citygml.building._1.GroundSurfaceType;
import net.opengis.citygml.building._1.IntBuildingInstallationPropertyType;
import net.opengis.citygml.building._1.IntBuildingInstallationType;
import net.opengis.citygml.building._1.InteriorFurniturePropertyType;
import net.opengis.citygml.building._1.InteriorRoomPropertyType;
import net.opengis.citygml.building._1.InteriorWallSurfaceType;
import net.opengis.citygml.building._1.ObjectFactory;
import net.opengis.citygml.building._1.OpeningPropertyType;
import net.opengis.citygml.building._1.RoofSurfaceType;
import net.opengis.citygml.building._1.RoomType;
import net.opengis.citygml.building._1.WallSurfaceType;
import net.opengis.citygml.building._1.WindowType;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.building.AbstractBoundarySurface;
import org.citygml4j.model.citygml.building.AbstractBuilding;
import org.citygml4j.model.citygml.building.AbstractOpening;
import org.citygml4j.model.citygml.building.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.building.Building;
import org.citygml4j.model.citygml.building.BuildingFurniture;
import org.citygml4j.model.citygml.building.BuildingInstallation;
import org.citygml4j.model.citygml.building.BuildingInstallationProperty;
import org.citygml4j.model.citygml.building.BuildingPart;
import org.citygml4j.model.citygml.building.BuildingPartProperty;
import org.citygml4j.model.citygml.building.CeilingSurface;
import org.citygml4j.model.citygml.building.ClosureSurface;
import org.citygml4j.model.citygml.building.Door;
import org.citygml4j.model.citygml.building.FloorSurface;
import org.citygml4j.model.citygml.building.GroundSurface;
import org.citygml4j.model.citygml.building.IntBuildingInstallation;
import org.citygml4j.model.citygml.building.IntBuildingInstallationProperty;
import org.citygml4j.model.citygml.building.InteriorFurnitureProperty;
import org.citygml4j.model.citygml.building.InteriorRoomProperty;
import org.citygml4j.model.citygml.building.InteriorWallSurface;
import org.citygml4j.model.citygml.building.OpeningProperty;
import org.citygml4j.model.citygml.building.OuterCeilingSurface;
import org.citygml4j.model.citygml.building.OuterFloorSurface;
import org.citygml4j.model.citygml.building.RoofSurface;
import org.citygml4j.model.citygml.building.Room;
import org.citygml4j.model.citygml.building.WallSurface;
import org.citygml4j.model.citygml.building.Window;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.util.mapper.TypeMapper;

public class Building100Marshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectFactory bldg = new ObjectFactory();
    private final JAXBMarshaller jaxb;
    private final CityGMLMarshaller citygml;
    private TypeMapper<JAXBElement<?>> elementMapper;
    private TypeMapper<Object> typeMapper;

    public Building100Marshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBMarshaller();
    }

    private TypeMapper<JAXBElement<?>> getElementMapper() {
        if (this.elementMapper == null) {
            this.lock.lock();
            try {
                if (this.elementMapper == null) {
                    this.elementMapper = TypeMapper.create().with(Building.class, this::createBuilding).with(BuildingFurniture.class, this::createBuildingFurniture).with(BuildingInstallation.class, this::createBuildingInstallation).with(BuildingPart.class, this::createBuildingPart).with(CeilingSurface.class, this::createCeilingSurface).with(ClosureSurface.class, this::createClosureSurface).with(Door.class, this::createDoor).with(FloorSurface.class, this::createFloorSurface).with(GroundSurface.class, this::createGroundSurface).with(IntBuildingInstallation.class, this::createIntBuildingInstallation).with(InteriorWallSurface.class, this::createInteriorWallSurface).with(OuterCeilingSurface.class, this::createOuterCeilingSurface).with(OuterFloorSurface.class, this::createOuterFloorSurface).with(RoofSurface.class, this::createRoofSurface).with(Room.class, this::createRoom).with(WallSurface.class, this::createWallSurface).with(Window.class, this::createWindow);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.elementMapper;
    }

    private TypeMapper<Object> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(BoundarySurfaceProperty.class, this::marshalBoundarySurfaceProperty).with(Building.class, this::marshalBuilding).with(BuildingFurniture.class, this::marshalBuildingFurniture).with(BuildingInstallation.class, this::marshalBuildingInstallation).with(BuildingInstallationProperty.class, this::marshalBuildingInstallationProperty).with(BuildingPart.class, this::marshalBuildingPart).with(BuildingPartProperty.class, this::marshalBuildingPartProperty).with(CeilingSurface.class, this::marshalCeilingSurface).with(ClosureSurface.class, this::marshalClosureSurface).with(Door.class, this::marshalDoor).with(FloorSurface.class, this::marshalFloorSurface).with(GroundSurface.class, this::marshalGroundSurface).with(IntBuildingInstallation.class, this::marshalIntBuildingInstallation).with(IntBuildingInstallationProperty.class, this::marshalIntBuildingInstallationProperty).with(InteriorFurnitureProperty.class, this::marshalInteriorFurnitureProperty).with(InteriorRoomProperty.class, this::marshalInteriorRoomProperty).with(InteriorWallSurface.class, this::marshalInteriorWallSurface).with(OpeningProperty.class, this::marshalOpeningProperty).with(OuterCeilingSurface.class, this::marshalOuterCeilingSurface).with(OuterFloorSurface.class, this::marshalOuterFloorSurface).with(RoofSurface.class, this::marshalRoofSurface).with(Room.class, this::marshalRoom).with(WallSurface.class, this::marshalWallSurface).with(Window.class, this::marshalWindow);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        return this.getElementMapper().apply(src);
    }

    public Object marshal(ModelObject src) {
        return this.getTypeMapper().apply(src);
    }

    public void marshalAbstractBuilding(AbstractBuilding src, AbstractBuildingType dest) {
        LocalDate date;
        this.citygml.getCore100Marshaller().marshalAbstractSite(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(usage.getValue());
            }
        }
        if (src.isSetYearOfConstruction()) {
            date = src.getYearOfConstruction();
            dest.setYearOfConstruction(this.jaxb.getDataTypeFactory().newXMLGregorianCalendarDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), Integer.MIN_VALUE));
        }
        if (src.isSetYearOfDemolition()) {
            date = src.getYearOfDemolition();
            dest.setYearOfDemolition(this.jaxb.getDataTypeFactory().newXMLGregorianCalendarDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), Integer.MIN_VALUE));
        }
        if (src.isSetRoofType()) {
            dest.setRoofType(src.getRoofType().getValue());
        }
        if (src.isSetMeasuredHeight()) {
            dest.setMeasuredHeight(this.jaxb.getGMLMarshaller().marshalLength(src.getMeasuredHeight()));
        }
        if (src.isSetStoreysAboveGround()) {
            dest.setStoreysAboveGround(BigInteger.valueOf(src.getStoreysAboveGround().intValue()));
        }
        if (src.isSetStoreysBelowGround()) {
            dest.setStoreysBelowGround(BigInteger.valueOf(src.getStoreysBelowGround().intValue()));
        }
        if (src.isSetStoreyHeightsAboveGround()) {
            dest.setStoreyHeightsAboveGround(this.jaxb.getGMLMarshaller().marshalMeasureOrNullList(src.getStoreyHeightsAboveGround()));
        }
        if (src.isSetStoreyHeightsBelowGround()) {
            dest.setStoreyHeightsBelowGround(this.jaxb.getGMLMarshaller().marshalMeasureOrNullList(src.getStoreyHeightsBelowGround()));
        }
        if (src.isSetLod1Solid()) {
            dest.setLod1Solid(this.jaxb.getGMLMarshaller().marshalSolidProperty(src.getLod1Solid()));
        }
        if (src.isSetLod2Solid()) {
            dest.setLod2Solid(this.jaxb.getGMLMarshaller().marshalSolidProperty(src.getLod2Solid()));
        }
        if (src.isSetLod3Solid()) {
            dest.setLod3Solid(this.jaxb.getGMLMarshaller().marshalSolidProperty(src.getLod3Solid()));
        }
        if (src.isSetLod4Solid()) {
            dest.setLod4Solid(this.jaxb.getGMLMarshaller().marshalSolidProperty(src.getLod4Solid()));
        }
        if (src.isSetLod1MultiSurface()) {
            dest.setLod1MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod1MultiSurface()));
        }
        if (src.isSetLod2MultiSurface()) {
            dest.setLod2MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod2MultiSurface()));
        }
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetLod1TerrainIntersection()) {
            dest.setLod1TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod1TerrainIntersection()));
        }
        if (src.isSetLod2TerrainIntersection()) {
            dest.setLod2TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod2TerrainIntersection()));
        }
        if (src.isSetLod3TerrainIntersection()) {
            dest.setLod3TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod3TerrainIntersection()));
        }
        if (src.isSetLod4TerrainIntersection()) {
            dest.setLod4TerrainIntersection(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod4TerrainIntersection()));
        }
        if (src.isSetLod2MultiCurve()) {
            dest.setLod2MultiCurve(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod2MultiCurve()));
        }
        if (src.isSetLod3MultiCurve()) {
            dest.setLod3MultiCurve(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod3MultiCurve()));
        }
        if (src.isSetLod4MultiCurve()) {
            dest.setLod4MultiCurve(this.jaxb.getGMLMarshaller().marshalMultiCurveProperty(src.getLod4MultiCurve()));
        }
        if (src.isSetOuterBuildingInstallation()) {
            for (BuildingInstallationProperty buildingInstallationProperty : src.getOuterBuildingInstallation()) {
                dest.getOuterBuildingInstallation().add(this.marshalBuildingInstallationProperty(buildingInstallationProperty));
            }
        }
        if (src.isSetInteriorBuildingInstallation()) {
            for (IntBuildingInstallationProperty intBuildingInstallationProperty : src.getInteriorBuildingInstallation()) {
                dest.getInteriorBuildingInstallation().add(this.marshalIntBuildingInstallationProperty(intBuildingInstallationProperty));
            }
        }
        if (src.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : src.getBoundedBySurface()) {
                dest.getBoundedBySurface().add(this.marshalBoundarySurfaceProperty(boundarySurfaceProperty));
            }
        }
        if (src.isSetConsistsOfBuildingPart()) {
            for (BuildingPartProperty buildingPartProperty : src.getConsistsOfBuildingPart()) {
                dest.getConsistsOfBuildingPart().add(this.marshalBuildingPartProperty(buildingPartProperty));
            }
        }
        if (src.isSetInteriorRoom()) {
            for (InteriorRoomProperty interiorRoomProperty : src.getInteriorRoom()) {
                dest.getInteriorRoom().add(this.marshalInteriorRoomProperty(interiorRoomProperty));
            }
        }
        if (src.isSetAddress()) {
            for (AddressProperty addressProperty : src.getAddress()) {
                dest.getAddress().add(this.citygml.getCore100Marshaller().marshalAddressProperty(addressProperty));
            }
        }
        if (src.isSetGenericApplicationPropertyOfAbstractBuilding()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfAbstractBuilding()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfAbstractBuilding().add(jaxbElement);
            }
        }
    }

    public void marshalAbstractBoundarySurface(AbstractBoundarySurface src, AbstractBoundarySurfaceType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetLod2MultiSurface()) {
            dest.setLod2MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod2MultiSurface()));
        }
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetOpening()) {
            for (OpeningProperty openingProperty : src.getOpening()) {
                dest.getOpening().add(this.marshalOpeningProperty(openingProperty));
            }
        }
        if (src.isSetGenericApplicationPropertyOfBoundarySurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfBoundarySurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfBoundarySurface().add(jaxbElement);
            }
        }
    }

    public void marshalAbstractOpening(AbstractOpening src, AbstractOpeningType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetGenericApplicationPropertyOfOpening()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfOpening()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfOpening().add(jaxbElement);
            }
        }
    }

    public BoundarySurfacePropertyType marshalBoundarySurfaceProperty(BoundarySurfaceProperty src) {
        JAXBElement<?> elem;
        BoundarySurfacePropertyType dest = this.bldg.createBoundarySurfacePropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetBoundarySurface() && (elem = this.jaxb.marshalJAXBElement(src.getBoundarySurface())) != null && elem.getValue() instanceof AbstractBoundarySurfaceType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public void marshalBuilding(Building src, BuildingType dest) {
        this.marshalAbstractBuilding(src, dest);
        if (src.isSetGenericApplicationPropertyOfBuilding()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfBuilding()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfBuilding().add(jaxbElement);
            }
        }
    }

    public BuildingType marshalBuilding(Building src) {
        BuildingType dest = this.bldg.createBuildingType();
        this.marshalBuilding(src, dest);
        return dest;
    }

    public void marshalBuildingFurniture(BuildingFurniture src, BuildingFurnitureType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(usage.getValue());
            }
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetLod4ImplicitRepresentation()) {
            dest.setLod4ImplicitRepresentation(this.citygml.getCore100Marshaller().marshalImplicitRepresentationProperty(src.getLod4ImplicitRepresentation()));
        }
        if (src.isSetGenericApplicationPropertyOfBuildingFurniture()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfBuildingFurniture()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfBuildingFurniture().add(jaxbElement);
            }
        }
    }

    public BuildingFurnitureType marshalBuildingFurniture(BuildingFurniture src) {
        BuildingFurnitureType dest = this.bldg.createBuildingFurnitureType();
        this.marshalBuildingFurniture(src, dest);
        return dest;
    }

    public void marshalBuildingInstallation(BuildingInstallation src, BuildingInstallationType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(usage.getValue());
            }
        }
        if (src.isSetLod2Geometry()) {
            dest.setLod2Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry()));
        }
        if (src.isSetLod3Geometry()) {
            dest.setLod3Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry()));
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetGenericApplicationPropertyOfBuildingInstallation()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfBuildingInstallation()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfBuildingInstallation().add(jaxbElement);
            }
        }
    }

    public BuildingInstallationType marshalBuildingInstallation(BuildingInstallation src) {
        BuildingInstallationType dest = this.bldg.createBuildingInstallationType();
        this.marshalBuildingInstallation(src, dest);
        return dest;
    }

    public BuildingInstallationPropertyType marshalBuildingInstallationProperty(BuildingInstallationProperty src) {
        JAXBElement<?> elem;
        BuildingInstallationPropertyType dest = this.bldg.createBuildingInstallationPropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetBuildingInstallation() && (elem = this.jaxb.marshalJAXBElement(src.getBuildingInstallation())) != null && elem.getValue() instanceof BuildingInstallationType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public void marshalBuildingPart(BuildingPart src, BuildingPartType dest) {
        this.marshalAbstractBuilding(src, dest);
        if (src.isSetGenericApplicationPropertyOfBuildingPart()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfBuildingPart()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfBuildingPart().add(jaxbElement);
            }
        }
    }

    public BuildingPartType marshalBuildingPart(BuildingPart src) {
        BuildingPartType dest = this.bldg.createBuildingPartType();
        this.marshalBuildingPart(src, dest);
        return dest;
    }

    public BuildingPartPropertyType marshalBuildingPartProperty(BuildingPartProperty src) {
        JAXBElement<?> elem;
        BuildingPartPropertyType dest = this.bldg.createBuildingPartPropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetBuildingPart() && (elem = this.jaxb.marshalJAXBElement(src.getBuildingPart())) != null && elem.getValue() instanceof BuildingPartType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public void marshalCeilingSurface(CeilingSurface src, CeilingSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfCeilingSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfCeilingSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfCeilingSurface().add(jaxbElement);
            }
        }
    }

    public CeilingSurfaceType marshalCeilingSurface(CeilingSurface src) {
        CeilingSurfaceType dest = this.bldg.createCeilingSurfaceType();
        this.marshalCeilingSurface(src, dest);
        return dest;
    }

    public void marshalClosureSurface(ClosureSurface src, ClosureSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfClosureSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfClosureSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfClosureSurface().add(jaxbElement);
            }
        }
    }

    public ClosureSurfaceType marshalClosureSurface(ClosureSurface src) {
        ClosureSurfaceType dest = this.bldg.createClosureSurfaceType();
        this.marshalClosureSurface(src, dest);
        return dest;
    }

    public void marshalDoor(Door src, DoorType dest) {
        this.marshalAbstractOpening(src, dest);
        if (src.isSetAddress()) {
            for (AddressProperty addressProperty : src.getAddress()) {
                dest.getAddress().add(this.citygml.getCore100Marshaller().marshalAddressProperty(addressProperty));
            }
        }
        if (src.isSetGenericApplicationPropertyOfDoor()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfDoor()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfDoor().add(jaxbElement);
            }
        }
    }

    public DoorType marshalDoor(Door src) {
        DoorType dest = this.bldg.createDoorType();
        this.marshalDoor(src, dest);
        return dest;
    }

    public void marshalFloorSurface(FloorSurface src, FloorSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfFloorSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfFloorSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfFloorSurface().add(jaxbElement);
            }
        }
    }

    public FloorSurfaceType marshalFloorSurface(FloorSurface src) {
        FloorSurfaceType dest = this.bldg.createFloorSurfaceType();
        this.marshalFloorSurface(src, dest);
        return dest;
    }

    public void marshalGroundSurface(GroundSurface src, GroundSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfGroundSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfGroundSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfGroundSurface().add(jaxbElement);
            }
        }
    }

    public GroundSurfaceType marshalGroundSurface(GroundSurface src) {
        GroundSurfaceType dest = this.bldg.createGroundSurfaceType();
        this.marshalGroundSurface(src, dest);
        return dest;
    }

    public void marshalOuterCeilingSurface(OuterCeilingSurface src, WallSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfOuterCeilingSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfOuterCeilingSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfWallSurface().add(jaxbElement);
            }
        }
    }

    public WallSurfaceType marshalOuterCeilingSurface(OuterCeilingSurface src) {
        WallSurfaceType dest = this.bldg.createWallSurfaceType();
        this.marshalOuterCeilingSurface(src, dest);
        return dest;
    }

    public void marshalOuterFloorSurface(OuterFloorSurface src, WallSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfOuterFloorSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfOuterFloorSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfWallSurface().add(jaxbElement);
            }
        }
    }

    public WallSurfaceType marshalOuterFloorSurface(OuterFloorSurface src) {
        WallSurfaceType dest = this.bldg.createWallSurfaceType();
        this.marshalOuterFloorSurface(src, dest);
        return dest;
    }

    public void marshalIntBuildingInstallation(IntBuildingInstallation src, IntBuildingInstallationType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(usage.getValue());
            }
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetGenericApplicationPropertyOfIntBuildingInstallation()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfIntBuildingInstallation()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfIntBuildingInstallation().add(jaxbElement);
            }
        }
    }

    public IntBuildingInstallationType marshalIntBuildingInstallation(IntBuildingInstallation src) {
        IntBuildingInstallationType dest = this.bldg.createIntBuildingInstallationType();
        this.marshalIntBuildingInstallation(src, dest);
        return dest;
    }

    public IntBuildingInstallationPropertyType marshalIntBuildingInstallationProperty(IntBuildingInstallationProperty src) {
        JAXBElement<?> elem;
        IntBuildingInstallationPropertyType dest = this.bldg.createIntBuildingInstallationPropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetIntBuildingInstallation() && (elem = this.jaxb.marshalJAXBElement(src.getIntBuildingInstallation())) != null && elem.getValue() instanceof IntBuildingInstallationType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public InteriorFurniturePropertyType marshalInteriorFurnitureProperty(InteriorFurnitureProperty src) {
        JAXBElement<?> elem;
        InteriorFurniturePropertyType dest = this.bldg.createInteriorFurniturePropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetBuildingFurniture() && (elem = this.jaxb.marshalJAXBElement(src.getBuildingFurniture())) != null && elem.getValue() instanceof BuildingFurnitureType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public InteriorRoomPropertyType marshalInteriorRoomProperty(InteriorRoomProperty src) {
        JAXBElement<?> elem;
        InteriorRoomPropertyType dest = this.bldg.createInteriorRoomPropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetRoom() && (elem = this.jaxb.marshalJAXBElement(src.getRoom())) != null && elem.getValue() instanceof RoomType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public void marshalInteriorWallSurface(InteriorWallSurface src, InteriorWallSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfInteriorWallSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfInteriorWallSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfInteriorWallSurface().add(jaxbElement);
            }
        }
    }

    public InteriorWallSurfaceType marshalInteriorWallSurface(InteriorWallSurface src) {
        InteriorWallSurfaceType dest = this.bldg.createInteriorWallSurfaceType();
        this.marshalInteriorWallSurface(src, dest);
        return dest;
    }

    public OpeningPropertyType marshalOpeningProperty(OpeningProperty src) {
        JAXBElement<?> elem;
        OpeningPropertyType dest = this.bldg.createOpeningPropertyType();
        this.jaxb.getGMLMarshaller().marshalFeatureProperty((FeatureProperty<? extends AbstractFeature>)src, dest);
        if (src.isSetOpening() && (elem = this.jaxb.marshalJAXBElement(src.getOpening())) != null && elem.getValue() instanceof AbstractOpeningType) {
            dest.set_Object(elem);
        }
        return dest;
    }

    public void marshalRoofSurface(RoofSurface src, RoofSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfRoofSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfRoofSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfRoofSurface().add(jaxbElement);
            }
        }
    }

    public RoofSurfaceType marshalRoofSurface(RoofSurface src) {
        RoofSurfaceType dest = this.bldg.createRoofSurfaceType();
        this.marshalRoofSurface(src, dest);
        return dest;
    }

    public void marshalRoom(Room src, RoomType dest) {
        this.citygml.getCore100Marshaller().marshalAbstractCityObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                dest.getFunction().add(function.getValue());
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                dest.getUsage().add(usage.getValue());
            }
        }
        if (src.isSetLod4Solid()) {
            dest.setLod4Solid(this.jaxb.getGMLMarshaller().marshalSolidProperty(src.getLod4Solid()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLMarshaller().marshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : src.getBoundedBySurface()) {
                dest.getBoundedBySurface().add(this.marshalBoundarySurfaceProperty(boundarySurfaceProperty));
            }
        }
        if (src.isSetInteriorFurniture()) {
            for (InteriorFurnitureProperty interiorFurnitureProperty : src.getInteriorFurniture()) {
                dest.getInteriorFurniture().add(this.marshalInteriorFurnitureProperty(interiorFurnitureProperty));
            }
        }
        if (src.isSetRoomInstallation()) {
            for (IntBuildingInstallationProperty intBuildingInstallationProperty : src.getRoomInstallation()) {
                dest.getRoomInstallation().add(this.marshalIntBuildingInstallationProperty(intBuildingInstallationProperty));
            }
        }
        if (src.isSetGenericApplicationPropertyOfRoom()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfRoom()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfRoom().add(jaxbElement);
            }
        }
    }

    public RoomType marshalRoom(Room src) {
        RoomType dest = this.bldg.createRoomType();
        this.marshalRoom(src, dest);
        return dest;
    }

    public void marshalWallSurface(WallSurface src, WallSurfaceType dest) {
        this.marshalAbstractBoundarySurface(src, dest);
        if (src.isSetGenericApplicationPropertyOfWallSurface()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfWallSurface()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfWallSurface().add(jaxbElement);
            }
        }
    }

    public WallSurfaceType marshalWallSurface(WallSurface src) {
        WallSurfaceType dest = this.bldg.createWallSurfaceType();
        this.marshalWallSurface(src, dest);
        return dest;
    }

    public void marshalWindow(Window src, WindowType dest) {
        this.marshalAbstractOpening(src, dest);
        if (src.isSetGenericApplicationPropertyOfWindow()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfWindow()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfWindow().add(jaxbElement);
            }
        }
    }

    public WindowType marshalWindow(Window src) {
        WindowType dest = this.bldg.createWindowType();
        this.marshalWindow(src, dest);
        return dest;
    }

    private JAXBElement<?> createBuilding(Building src) {
        return this.bldg.createBuilding(this.marshalBuilding(src));
    }

    private JAXBElement<?> createBuildingFurniture(BuildingFurniture src) {
        return this.bldg.createBuildingFurniture(this.marshalBuildingFurniture(src));
    }

    private JAXBElement<?> createBuildingInstallation(BuildingInstallation src) {
        return this.bldg.createBuildingInstallation(this.marshalBuildingInstallation(src));
    }

    private JAXBElement<?> createBuildingPart(BuildingPart src) {
        return this.bldg.createBuildingPart(this.marshalBuildingPart(src));
    }

    private JAXBElement<?> createCeilingSurface(CeilingSurface src) {
        return this.bldg.createCeilingSurface(this.marshalCeilingSurface(src));
    }

    private JAXBElement<?> createClosureSurface(ClosureSurface src) {
        return this.bldg.createClosureSurface(this.marshalClosureSurface(src));
    }

    private JAXBElement<?> createDoor(Door src) {
        return this.bldg.createDoor(this.marshalDoor(src));
    }

    private JAXBElement<?> createFloorSurface(FloorSurface src) {
        return this.bldg.createFloorSurface(this.marshalFloorSurface(src));
    }

    private JAXBElement<?> createGroundSurface(GroundSurface src) {
        return this.bldg.createGroundSurface(this.marshalGroundSurface(src));
    }

    private JAXBElement<?> createIntBuildingInstallation(IntBuildingInstallation src) {
        return this.bldg.createIntBuildingInstallation(this.marshalIntBuildingInstallation(src));
    }

    private JAXBElement<?> createInteriorWallSurface(InteriorWallSurface src) {
        return this.bldg.createInteriorWallSurface(this.marshalInteriorWallSurface(src));
    }

    private JAXBElement<?> createOuterCeilingSurface(OuterCeilingSurface src) {
        return this.bldg.createWallSurface(this.marshalOuterCeilingSurface(src));
    }

    private JAXBElement<?> createOuterFloorSurface(OuterFloorSurface src) {
        return this.bldg.createWallSurface(this.marshalOuterFloorSurface(src));
    }

    private JAXBElement<?> createRoofSurface(RoofSurface src) {
        return this.bldg.createRoofSurface(this.marshalRoofSurface(src));
    }

    private JAXBElement<?> createRoom(Room src) {
        return this.bldg.createRoom(this.marshalRoom(src));
    }

    private JAXBElement<?> createWallSurface(WallSurface src) {
        return this.bldg.createWallSurface(this.marshalWallSurface(src));
    }

    private JAXBElement<?> createWindow(Window src) {
        return this.bldg.createWindow(this.marshalWindow(src));
    }
}

