/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.ade.ADEUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.gml.GMLUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.xal.XALUnmarshaller;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.schema.SchemaHandler;
import org.w3c.dom.Element;

public class JAXBUnmarshaller {
    private final CityGMLUnmarshaller citygml;
    private final GMLUnmarshaller gml;
    private final XALUnmarshaller xal;
    private final ADEUnmarshaller ade;
    private final CityGMLBuilder builder;
    private final SchemaHandler schemaHandler;
    private final DatatypeFactory dataTypeFactory;
    private boolean parseSchema = true;
    private boolean throwMissingADESchema = true;
    private boolean skipGenericADEContent;
    private boolean releaseJAXBElements = true;

    public JAXBUnmarshaller(CityGMLBuilder builder, SchemaHandler schemaHandler) {
        this.builder = builder;
        this.schemaHandler = schemaHandler;
        this.citygml = new CityGMLUnmarshaller(this);
        this.gml = new GMLUnmarshaller(this);
        this.xal = new XALUnmarshaller();
        this.ade = new ADEUnmarshaller(this);
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Failed to create DatatypeFactory.", e);
        }
    }

    public ModelObject unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        ModelObject dest = this.citygml.unmarshal(src);
        if (dest == null) {
            dest = this.gml.unmarshal(src);
        }
        if (dest == null) {
            dest = this.xal.unmarshal(src);
        }
        if (dest == null) {
            dest = this.ade.unmarshal(src);
        }
        if (this.releaseJAXBElements) {
            src.setValue(null);
        }
        return dest;
    }

    public ModelObject unmarshal(Element element) throws MissingADESchemaException {
        ModelObject dest = null;
        try {
            Unmarshaller um = this.builder.getJAXBContext().createUnmarshaller();
            Object jaxb = um.unmarshal(element);
            if (jaxb instanceof JAXBElement) {
                dest = this.unmarshal((JAXBElement)jaxb);
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return dest;
    }

    public ModelObject unmarshal(Object src) throws MissingADESchemaException {
        if (src instanceof JAXBElement) {
            return this.unmarshal((JAXBElement)src);
        }
        if (src instanceof Element) {
            return this.unmarshal((Element)src);
        }
        ModelObject dest = this.citygml.unmarshal(src);
        if (dest == null) {
            dest = this.gml.unmarshal(src);
        }
        if (dest == null) {
            dest = this.xal.unmarshal(src);
        }
        if (dest == null) {
            dest = this.ade.unmarshal(src);
        }
        return dest;
    }

    public DatatypeFactory getDataTypeFactory() {
        return this.dataTypeFactory;
    }

    public CityGMLUnmarshaller getCityGMLUnmarshaller() {
        return this.citygml;
    }

    public GMLUnmarshaller getGMLUnmarshaller() {
        return this.gml;
    }

    public XALUnmarshaller getXALUnmarshaller() {
        return this.xal;
    }

    public ADEUnmarshaller getADEUnmarshaller() {
        return this.ade;
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public boolean isParseSchema() {
        return this.parseSchema;
    }

    public void setParseSchema(boolean parseSchema) {
        this.parseSchema = parseSchema;
    }

    public boolean isThrowMissingADESchema() {
        return this.throwMissingADESchema;
    }

    public void setThrowMissingADESchema(boolean throwMissingADESchema) {
        this.throwMissingADESchema = throwMissingADESchema;
    }

    public boolean isSkipGenericADEContent() {
        return this.skipGenericADEContent;
    }

    public void setSkipGenericADEContent(boolean skipGenericADEContent) {
        this.skipGenericADEContent = skipGenericADEContent;
    }

    public boolean isReleaseJAXBElementsFromMemory() {
        return this.releaseJAXBElements;
    }

    public void setReleaseJAXBElementsFromMemory(boolean releaseJAXBElements) {
        this.releaseJAXBElements = releaseJAXBElements;
    }
}

