/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.ade;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.citygml4j.CityGMLContext;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.ade.ADEUnmarshallerHelper;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ADEUnmarshaller {
    private final JAXBUnmarshaller jaxb;
    private Map<String, org.citygml4j.model.citygml.ade.binding.ADEUnmarshaller> unmarshallers;

    public ADEUnmarshaller(JAXBUnmarshaller jaxb) {
        this.jaxb = jaxb;
        CityGMLContext context = CityGMLContext.getInstance();
        if (context.hasADEContexts()) {
            this.unmarshallers = new HashMap<String, org.citygml4j.model.citygml.ade.binding.ADEUnmarshaller>();
            ADEUnmarshallerHelper helper = new ADEUnmarshallerHelper(jaxb);
            for (ADEContext adeContext : context.getADEContexts()) {
                org.citygml4j.model.citygml.ade.binding.ADEUnmarshaller unmarshaller = adeContext.createADEUnmarshaller();
                if (unmarshaller == null) continue;
                unmarshaller.setADEUnmarshallerHelper(helper);
                for (ADEModule module : adeContext.getADEModules()) {
                    this.unmarshallers.put(module.getNamespaceURI(), unmarshaller);
                }
            }
        }
    }

    public ADEGenericElement unmarshal(Element element) throws MissingADESchemaException {
        block7: {
            if (this.jaxb.isSkipGenericADEContent()) {
                return null;
            }
            if (this.jaxb.isParseSchema()) {
                try {
                    this.jaxb.getSchemaHandler().parseSchema(element);
                    this.jaxb.getSchemaHandler().parseSchema(element.getNamespaceURI(), null);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            try {
                this.jaxb.getSchemaHandler().resolveAndParseSchema(element.getNamespaceURI());
            }
            catch (SAXException sAXException) {
            }
            catch (MissingADESchemaException e) {
                if (!this.jaxb.isThrowMissingADESchema()) break block7;
                throw e;
            }
        }
        return new ADEGenericElement(element);
    }

    public ADEModelObject unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        org.citygml4j.model.citygml.ade.binding.ADEUnmarshaller unmarshaller;
        if (this.unmarshallers != null && (unmarshaller = this.unmarshallers.get(src.getName().getNamespaceURI())) != null) {
            ADEModelObject ade = unmarshaller.unmarshal(src);
            if (ade instanceof AbstractFeature && !((AbstractFeature)((Object)ade)).isSetModule()) {
                ((AbstractFeature)((Object)ade)).setModule(Modules.getModule(src.getName().getNamespaceURI()));
            }
            return ade;
        }
        return null;
    }

    public ADEModelObject unmarshal(Object src) throws MissingADESchemaException {
        if (this.unmarshallers != null) {
            for (org.citygml4j.model.citygml.ade.binding.ADEUnmarshaller unmarshaller : this.unmarshallers.values()) {
                ADEModelObject ade = unmarshaller.unmarshal(src);
                if (ade == null) continue;
                return ade;
            }
        }
        return null;
    }
}

