/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.unmarshal.citygml.vegetation;

import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import net.opengis.citygml.vegetation._2.AbstractVegetationObjectType;
import net.opengis.citygml.vegetation._2.PlantCoverType;
import net.opengis.citygml.vegetation._2.SolitaryVegetationObjectType;
import net.opengis.gml.CodeType;
import org.citygml4j.builder.jaxb.unmarshal.JAXBUnmarshaller;
import org.citygml4j.builder.jaxb.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.vegetation.AbstractVegetationObject;
import org.citygml4j.model.citygml.vegetation.PlantCover;
import org.citygml4j.model.citygml.vegetation.SolitaryVegetationObject;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.module.citygml.VegetationModule;
import org.citygml4j.util.mapper.CheckedTypeMapper;
import org.citygml4j.xml.io.reader.MissingADESchemaException;

public class Vegetation200Unmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final VegetationModule module = VegetationModule.v2_0_0;
    private final JAXBUnmarshaller jaxb;
    private final CityGMLUnmarshaller citygml;
    private CheckedTypeMapper<CityGML> typeMapper;

    public Vegetation200Unmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBUnmarshaller();
    }

    private CheckedTypeMapper<CityGML> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = CheckedTypeMapper.create().with(PlantCoverType.class, this::unmarshalPlantCover).with(SolitaryVegetationObjectType.class, this::unmarshalSolitaryVegetationObject).with(JAXBElement.class, this::unmarshal);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public CityGML unmarshal(JAXBElement<?> src) throws MissingADESchemaException {
        return this.unmarshal(src.getValue());
    }

    public CityGML unmarshal(Object src) throws MissingADESchemaException {
        return this.getTypeMapper().apply(src);
    }

    public void unmarshalAbstractVegetationObject(AbstractVegetationObjectType src, AbstractVegetationObject dest) throws MissingADESchemaException {
        this.citygml.getCore200Unmarshaller().unmarshalAbstractCityObject(src, dest);
        if (src.isSet_GenericApplicationPropertyOfVegetationObject()) {
            for (JAXBElement<Object> elem : src.get_GenericApplicationPropertyOfVegetationObject()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(elem);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfVegetationObject(ade);
            }
        }
    }

    public void unmarshalPlantCover(PlantCoverType src, PlantCover dest) throws MissingADESchemaException {
        this.unmarshalAbstractVegetationObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(this.jaxb.getGMLUnmarshaller().unmarshalCode(src.getClazz()));
        }
        if (src.isSetFunction()) {
            for (CodeType codeType : src.getFunction()) {
                dest.addFunction(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetUsage()) {
            for (CodeType codeType : src.getUsage()) {
                dest.addUsage(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetAverageHeight()) {
            dest.setAverageHeight(this.jaxb.getGMLUnmarshaller().unmarshalLength(src.getAverageHeight()));
        }
        if (src.isSetLod1MultiSurface()) {
            dest.setLod1MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod1MultiSurface()));
        }
        if (src.isSetLod2MultiSurface()) {
            dest.setLod2MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod2MultiSurface()));
        }
        if (src.isSetLod3MultiSurface()) {
            dest.setLod3MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod3MultiSurface()));
        }
        if (src.isSetLod4MultiSurface()) {
            dest.setLod4MultiSurface(this.jaxb.getGMLUnmarshaller().unmarshalMultiSurfaceProperty(src.getLod4MultiSurface()));
        }
        if (src.isSetLod1MultiSolid()) {
            dest.setLod1MultiSolid(this.jaxb.getGMLUnmarshaller().unmarshalMultiSolidProperty(src.getLod1MultiSolid()));
        }
        if (src.isSetLod2MultiSolid()) {
            dest.setLod2MultiSolid(this.jaxb.getGMLUnmarshaller().unmarshalMultiSolidProperty(src.getLod2MultiSolid()));
        }
        if (src.isSetLod3MultiSolid()) {
            dest.setLod3MultiSolid(this.jaxb.getGMLUnmarshaller().unmarshalMultiSolidProperty(src.getLod3MultiSolid()));
        }
        if (src.isSetLod4MultiSolid()) {
            dest.setLod4MultiSolid(this.jaxb.getGMLUnmarshaller().unmarshalMultiSolidProperty(src.getLod4MultiSolid()));
        }
        if (src.isSet_GenericApplicationPropertyOfPlantCover()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfPlantCover()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfPlantCover(ade);
            }
        }
    }

    public PlantCover unmarshalPlantCover(PlantCoverType src) throws MissingADESchemaException {
        PlantCover dest = new PlantCover(this.module);
        this.unmarshalPlantCover(src, dest);
        return dest;
    }

    public void unmarshalSolitaryVegetationObject(SolitaryVegetationObjectType src, SolitaryVegetationObject dest) throws MissingADESchemaException {
        this.unmarshalAbstractVegetationObject(src, dest);
        if (src.isSetClazz()) {
            dest.setClazz(this.jaxb.getGMLUnmarshaller().unmarshalCode(src.getClazz()));
        }
        if (src.isSetFunction()) {
            for (CodeType codeType : src.getFunction()) {
                dest.addFunction(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetUsage()) {
            for (CodeType codeType : src.getUsage()) {
                dest.addUsage(this.jaxb.getGMLUnmarshaller().unmarshalCode(codeType));
            }
        }
        if (src.isSetSpecies()) {
            dest.setSpecies(this.jaxb.getGMLUnmarshaller().unmarshalCode(src.getSpecies()));
        }
        if (src.isSetHeight()) {
            dest.setHeight(this.jaxb.getGMLUnmarshaller().unmarshalLength(src.getHeight()));
        }
        if (src.isSetTrunkDiameter()) {
            dest.setTrunkDiameter(this.jaxb.getGMLUnmarshaller().unmarshalLength(src.getTrunkDiameter()));
        }
        if (src.isSetCrownDiameter()) {
            dest.setCrownDiameter(this.jaxb.getGMLUnmarshaller().unmarshalLength(src.getCrownDiameter()));
        }
        if (src.isSetLod1Geometry()) {
            dest.setLod1Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod1Geometry()));
        }
        if (src.isSetLod2Geometry()) {
            dest.setLod2Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod2Geometry()));
        }
        if (src.isSetLod3Geometry()) {
            dest.setLod3Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod3Geometry()));
        }
        if (src.isSetLod4Geometry()) {
            dest.setLod4Geometry(this.jaxb.getGMLUnmarshaller().unmarshalGeometryProperty(src.getLod4Geometry()));
        }
        if (src.isSetLod1ImplicitRepresentation()) {
            dest.setLod1ImplicitRepresentation(this.citygml.getCore200Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation()));
        }
        if (src.isSetLod2ImplicitRepresentation()) {
            dest.setLod2ImplicitRepresentation(this.citygml.getCore200Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation()));
        }
        if (src.isSetLod3ImplicitRepresentation()) {
            dest.setLod3ImplicitRepresentation(this.citygml.getCore200Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation()));
        }
        if (src.isSetLod4ImplicitRepresentation()) {
            dest.setLod4ImplicitRepresentation(this.citygml.getCore200Unmarshaller().unmarshalImplicitRepresentationProperty(src.getLod4ImplicitRepresentation()));
        }
        if (src.isSet_GenericApplicationPropertyOfSolitaryVegetationObject()) {
            for (JAXBElement jAXBElement : src.get_GenericApplicationPropertyOfSolitaryVegetationObject()) {
                ADEModelObject ade = this.jaxb.getADEUnmarshaller().unmarshal(jAXBElement);
                if (ade == null) continue;
                dest.addGenericApplicationPropertyOfSolitaryVegetationObject(ade);
            }
        }
    }

    public SolitaryVegetationObject unmarshalSolitaryVegetationObject(SolitaryVegetationObjectType src) throws MissingADESchemaException {
        SolitaryVegetationObject dest = new SolitaryVegetationObject(this.module);
        this.unmarshalSolitaryVegetationObject(src, dest);
        return dest;
    }

    public boolean assignGenericProperty(ADEGenericElement genericProperty, QName substitutionGroup, AbstractGML dest) {
        String name = substitutionGroup.getLocalPart();
        boolean success = true;
        if (dest instanceof AbstractVegetationObject && name.equals("_GenericApplicationPropertyOfVegetationObject")) {
            ((AbstractVegetationObject)dest).addGenericApplicationPropertyOfVegetationObject(genericProperty);
        } else if (dest instanceof PlantCover && name.equals("_GenericApplicationPropertyOfPlantCover")) {
            ((PlantCover)dest).addGenericApplicationPropertyOfPlantCover(genericProperty);
        } else if (dest instanceof SolitaryVegetationObject && name.equals("_GenericApplicationPropertyOfSolitaryVegetationObject")) {
            ((SolitaryVegetationObject)dest).addGenericApplicationPropertyOfSolitaryVegetationObject(genericProperty);
        } else {
            success = false;
        }
        return success;
    }
}

