/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityGMLModuleType;
import org.citygml4j.model.module.citygml.CityGMLVersion;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.model.module.citygml.GenericsModule;
import org.citygml4j.model.module.citygml.TexturedSurfaceModule;

public class CityGMLNamespaceMapper
implements XMLStreamReader {
    private final XMLStreamReader reader;
    private Stack<ParentFeatureElement> parents;
    private ParentFeatureElement parent;
    private QName currentName;
    private boolean isCityGML;
    private int depth = 0;

    public CityGMLNamespaceMapper(XMLStreamReader reader) {
        this.reader = reader;
        this.parents = new Stack();
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
        this.parents = null;
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        return this.reader.getAttributeLocalName(arg0);
    }

    @Override
    public QName getAttributeName(int arg0) {
        return this.reader.getAttributeName(arg0);
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        String namespaceURI = this.reader.getAttributeNamespace(arg0);
        return namespaceURI != null && namespaceURI.startsWith("http://www.citygml.org/citygml") ? this.currentName.getNamespaceURI() : this.reader.getAttributeNamespace(arg0);
    }

    @Override
    public String getAttributePrefix(int arg0) {
        return this.reader.getAttributePrefix(arg0);
    }

    @Override
    public String getAttributeType(int arg0) {
        return this.reader.getAttributeType(arg0);
    }

    @Override
    public String getAttributeValue(int arg0) {
        return this.reader.getAttributeValue(arg0);
    }

    @Override
    public String getAttributeValue(String arg0, String arg1) {
        return this.reader.getAttributeValue(arg0, arg1);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.reader.getElementText();
    }

    @Override
    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.isCityGML ? this.currentName.getLocalPart() : this.reader.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.reader.getLocation();
    }

    @Override
    public QName getName() {
        return this.isCityGML ? this.currentName : this.reader.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int arg0) {
        return this.reader.getNamespacePrefix(arg0);
    }

    @Override
    public String getNamespaceURI() {
        return this.isCityGML ? this.currentName.getNamespaceURI() : this.reader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(String arg0) {
        return this.reader.getNamespaceURI(arg0);
    }

    @Override
    public String getNamespaceURI(int arg0) {
        return this.reader.getNamespaceURI(arg0);
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.reader.getPrefix();
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.reader.getProperty(arg0);
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return this.reader.getTextCharacters(arg0, arg1, arg2, arg3);
    }

    @Override
    public int getTextLength() {
        return this.reader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.reader.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.reader.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    @Override
    public boolean hasText() {
        return this.reader.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int arg0) {
        return this.reader.isAttributeSpecified(arg0);
    }

    @Override
    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.reader.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    @Override
    public int next() throws XMLStreamException {
        int event = this.reader.next();
        if (event == 1) {
            String localPart = this.reader.getLocalName();
            String namespaceURI = this.reader.getNamespaceURI();
            ++this.depth;
            if (namespaceURI.startsWith("http://www.citygml.org/citygml")) {
                this.isCityGML = true;
                if (localPart.equals("creationDate") || localPart.equals("terminationDate") || localPart.equals("generalizesTo")) {
                    namespaceURI = CoreModule.v1_0_0.getNamespaceURI();
                } else if (localPart.equals("externalReference")) {
                    this.parents.push(this.parent);
                    this.parent = new ParentFeatureElement(localPart, CoreModule.v1_0_0.getNamespaceURI(), this.depth);
                    namespaceURI = CoreModule.v1_0_0.getNamespaceURI();
                } else if (localPart.equals("stringAttribute") || localPart.equals("intAttribute") || localPart.equals("doubleAttribute") || localPart.equals("dateAttribute") || localPart.equals("uriAttribute")) {
                    this.parents.push(this.parent);
                    this.parent = new ParentFeatureElement(localPart, GenericsModule.v1_0_0.getNamespaceURI(), this.depth);
                    namespaceURI = GenericsModule.v1_0_0.getNamespaceURI();
                } else if (localPart.equals("appearanceMember")) {
                    if (this.parent != null && !this.parent.localPart.equals("CityModel")) {
                        localPart = "appearance";
                    }
                    namespaceURI = AppearanceModule.v1_0_0.getNamespaceURI();
                } else if (localPart.equals("TexturedSurface") || localPart.equals("SimpleTexture") || localPart.equals("Material")) {
                    namespaceURI = TexturedSurfaceModule.v1_0_0.getNamespaceURI();
                } else {
                    for (CityGMLModule module : CityGMLVersion.v1_0_0.getCityGMLModules()) {
                        if (module.getType() == CityGMLModuleType.BRIDGE || module.getType() == CityGMLModuleType.TUNNEL || !module.hasFeature(localPart)) continue;
                        this.parents.push(this.parent);
                        this.parent = new ParentFeatureElement(localPart, module.getNamespaceURI(), this.depth);
                        break;
                    }
                    namespaceURI = this.parent.namespaceURI;
                }
            } else {
                this.isCityGML = false;
            }
            this.currentName = new QName(namespaceURI, localPart);
        } else if (event == 2) {
            if (this.parent != null && this.parent.depth == this.depth) {
                this.parent = this.parents.pop();
            }
            --this.depth;
        }
        return event;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.reader.nextTag();
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.reader.require(arg0, arg1, arg2);
    }

    @Override
    public boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    private final class ParentFeatureElement {
        private final String localPart;
        private final String namespaceURI;
        private final int depth;

        public ParentFeatureElement(String localPart, String namespaceURI, int depth) {
            this.localPart = localPart;
            this.namespaceURI = namespaceURI;
            this.depth = depth;
        }
    }
}

