/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.citygml.AppearanceModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityObjectGroupModule;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.xal.XALCoreModule;
import org.citygml4j.xml.io.reader.FeatureReadMode;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.schema.ElementDecl;
import org.citygml4j.xml.schema.Schema;
import org.citygml4j.xml.schema.SchemaHandler;
import org.xml.sax.SAXException;

public class XMLElementChecker {
    private final SchemaHandler schemaHandler;
    private final FeatureReadMode featureReadMode;
    private final boolean keepInlineAppearance;
    private final boolean parseSchema;
    private final boolean failOnMissingADESchema;
    private HashMap<String, List<String>> excludes;
    private HashMap<String, HashSet<String>> cityGMLFeatureProperties;
    private HashMap<String, HashSet<String>> adeFeatureProperties;

    XMLElementChecker(SchemaHandler schemaHandler, FeatureReadMode featureReadMode, boolean keepInlineAppearance, boolean parseSchema, boolean failOnMissingADESchema, List<QName> excludes, List<QName> featureProperties) {
        this.schemaHandler = schemaHandler;
        this.featureReadMode = featureReadMode;
        this.keepInlineAppearance = keepInlineAppearance;
        this.parseSchema = parseSchema;
        this.failOnMissingADESchema = failOnMissingADESchema;
        this.initExcludes(this.prepareNameList(excludes, true));
        if (featureReadMode == FeatureReadMode.SPLIT_PER_COLLECTION_MEMBER) {
            this.initCollectionSplitProperties(this.prepareNameList(featureProperties, false));
        }
    }

    public boolean isCityGMLElement(String namespaceURI) {
        return namespaceURI.startsWith("http://www.opengis.net/citygml");
    }

    public boolean isCityGMLElement(QName name) {
        return this.isCityGMLElement(name.getNamespaceURI());
    }

    public boolean isGMLElement(String namespaceURI) {
        return GMLCoreModule.v3_1_1.getNamespaceURI().equals(namespaceURI);
    }

    public boolean isGMLElement(QName name) {
        return this.isGMLElement(name.getNamespaceURI());
    }

    public boolean isXALElement(String namespaceURI) {
        return XALCoreModule.v2_0.getNamespaceURI().equals(namespaceURI);
    }

    public boolean isXALElement(QName name) {
        return this.isXALElement(name.getNamespaceURI());
    }

    public boolean isParentInfoElement(String namespaceURI, String localPart) {
        if (this.isGMLElement(namespaceURI)) {
            return localPart.equals("metaDataProperty") || localPart.equals("description") || localPart.equals("name") || localPart.equals("boundedBy") || localPart.equals("location");
        }
        if (this.isCityGMLElement(namespaceURI)) {
            return localPart.equals("appearance") || localPart.equals("appearanceMember");
        }
        return false;
    }

    public boolean isParentInfoElement(QName name) {
        return this.isParentInfoElement(name.getNamespaceURI(), name.getLocalPart());
    }

    public ElementInfo getElementInfo(QName name) throws MissingADESchemaException {
        ElementInfo elementInfo = this.getFeature(name);
        if (elementInfo == null && !this.isCityGMLElement(name)) {
            elementInfo = this.getADEElementInfo(name, null, true);
        }
        return elementInfo;
    }

    public ElementInfo getElementInfo(QName name, ElementInfo lastElementInfo) throws MissingADESchemaException {
        if (lastElementInfo != null && lastElementInfo.skipNestedElements) {
            return lastElementInfo;
        }
        ElementInfo elementInfo = null;
        if (lastElementInfo != null && lastElementInfo.isFeatureProperty) {
            elementInfo = this.getFeature(name);
            if (elementInfo == null && !this.isCityGMLElement(name)) {
                elementInfo = this.getADEElementInfo(name, lastElementInfo, true);
            }
        } else if (this.isGMLElement(name)) {
            elementInfo = this.getGMLFeatureProperty(name.getLocalPart());
        } else if (this.isCityGMLElement(name)) {
            elementInfo = this.getCityGMLFeatureProperty(name);
        } else if (!this.isXALElement(name) && this.checkADEFeatureProperty(name)) {
            elementInfo = this.getADEElementInfo(name, lastElementInfo, false);
        }
        return elementInfo;
    }

    private ElementInfo getFeature(QName name) {
        Class<? extends AbstractFeature> featureClass;
        ElementInfo elementInfo = null;
        String localName = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        Module module = Modules.getModule(namespaceURI);
        if (module != null && (featureClass = module.getFeatureClass(localName)) != null) {
            List<String> localNames;
            Schema schema;
            elementInfo = new ElementInfo();
            elementInfo.isFeature = true;
            elementInfo.featureClass = featureClass;
            if (module instanceof ADEModule && (schema = this.schemaHandler.getSchema(namespaceURI)) != null) {
                elementInfo.elementDecl = schema.getGlobalElementDecl(localName);
            }
            if (this.excludes != null && (localNames = this.excludes.get(namespaceURI)) != null && localNames.contains(localName)) {
                elementInfo.isFeature = false;
            }
        }
        return elementInfo;
    }

    private ElementInfo getADEElementInfo(QName name, ElementInfo lastElementInfo, boolean checkForFeature) throws MissingADESchemaException {
        ElementDecl parent;
        ElementDecl elementDecl;
        Schema schema;
        String namespaceURI;
        String localName;
        ElementInfo elementInfo;
        block9: {
            elementInfo = null;
            localName = name.getLocalPart();
            namespaceURI = name.getNamespaceURI();
            schema = this.schemaHandler.getSchema(namespaceURI);
            if (schema == null && this.parseSchema) {
                try {
                    this.schemaHandler.resolveAndParseSchema(namespaceURI);
                    schema = this.schemaHandler.getSchema(namespaceURI);
                }
                catch (SAXException sAXException) {
                }
                catch (MissingADESchemaException e) {
                    if (!this.failOnMissingADESchema) break block9;
                    throw e;
                }
            }
        }
        if (schema != null && (elementDecl = schema.getElementDecl(localName, parent = lastElementInfo != null ? lastElementInfo.elementDecl : null)) != null) {
            elementInfo = new ElementInfo(elementDecl);
            if (checkForFeature && elementDecl.isGlobal() && elementDecl.isFeature()) {
                List<String> localNames;
                elementInfo.isFeature = true;
                if (this.excludes != null && (localNames = this.excludes.get(namespaceURI)) != null && localNames.contains(localName)) {
                    elementInfo.isFeature = false;
                }
            } else if (elementDecl.isFeatureProperty()) {
                elementInfo.isFeatureProperty = true;
                elementInfo.hasXLink = elementDecl.hasXLinkAttribute();
            }
        }
        return elementInfo;
    }

    private ElementInfo getGMLFeatureProperty(String localName) {
        ElementInfo elementInfo = null;
        if (localName.equals("featureMember")) {
            elementInfo = new ElementInfo();
            elementInfo.isFeatureProperty = true;
            elementInfo.hasXLink = true;
        } else if (localName.equals("featureMembers")) {
            elementInfo = new ElementInfo();
            elementInfo.isFeatureProperty = true;
        }
        return elementInfo;
    }

    private ElementInfo getCityGMLFeatureProperty(QName name) {
        ElementInfo elementInfo = null;
        String localName = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        boolean isFeatureProperty = false;
        boolean skipNestedElements = false;
        if (this.featureReadMode == FeatureReadMode.SPLIT_PER_COLLECTION_MEMBER) {
            HashSet<String> properties = this.cityGMLFeatureProperties.get(namespaceURI);
            isFeatureProperty = properties != null && properties.contains(localName);
        } else {
            Module module = Modules.getModule(namespaceURI);
            if (module instanceof CityGMLModule) {
                CityGMLModule cityGMLModule = (CityGMLModule)module;
                isFeatureProperty = cityGMLModule.hasFeatureProperty(localName);
                if (localName.equals("appearance")) {
                    skipNestedElements = this.keepInlineAppearance;
                }
            }
        }
        if (isFeatureProperty) {
            elementInfo = new ElementInfo();
            elementInfo.isFeatureProperty = true;
            elementInfo.hasXLink = true;
            elementInfo.skipNestedElements = skipNestedElements;
        }
        return elementInfo;
    }

    private boolean checkADEFeatureProperty(QName name) {
        if (this.featureReadMode == FeatureReadMode.SPLIT_PER_FEATURE) {
            return true;
        }
        if (this.adeFeatureProperties != null) {
            HashSet<String> properties = this.adeFeatureProperties.get(name.getNamespaceURI());
            return properties != null && properties.contains(name.getLocalPart());
        }
        return false;
    }

    private void initExcludes(List<QName> excludes) {
        if (!excludes.isEmpty()) {
            this.excludes = new HashMap();
            for (QName exclude : excludes) {
                String localName = exclude.getLocalPart();
                String namespaceURI = exclude.getNamespaceURI();
                if (namespaceURI.length() == 0) continue;
                List localNames = this.excludes.computeIfAbsent(namespaceURI, k -> new ArrayList());
                localNames.add(localName);
            }
        }
    }

    private void initCollectionSplitProperties(List<QName> featureProperties) {
        this.cityGMLFeatureProperties = new HashMap();
        featureProperties.add(new QName(CoreModule.v2_0_0.getNamespaceURI(), "cityObjectMember"));
        featureProperties.add(new QName(CoreModule.v1_0_0.getNamespaceURI(), "cityObjectMember"));
        featureProperties.add(new QName(AppearanceModule.v2_0_0.getNamespaceURI(), "appearanceMember"));
        featureProperties.add(new QName(AppearanceModule.v1_0_0.getNamespaceURI(), "appearanceMember"));
        featureProperties.add(new QName(CityObjectGroupModule.v2_0_0.getNamespaceURI(), "groupMember"));
        featureProperties.add(new QName(CityObjectGroupModule.v2_0_0.getNamespaceURI(), "parent"));
        featureProperties.add(new QName(CityObjectGroupModule.v1_0_0.getNamespaceURI(), "groupMember"));
        featureProperties.add(new QName(CityObjectGroupModule.v1_0_0.getNamespaceURI(), "parent"));
        for (QName featureProperty : featureProperties) {
            HashSet properties;
            String localName = featureProperty.getLocalPart();
            String namespaceURI = featureProperty.getNamespaceURI();
            if (namespaceURI.length() == 0) continue;
            CityGMLModule module = Modules.getCityGMLModule(namespaceURI);
            if (module != null) {
                if (!module.hasFeatureProperty(localName)) continue;
                properties = this.cityGMLFeatureProperties.computeIfAbsent(namespaceURI, k -> new HashSet());
                properties.add(localName);
                continue;
            }
            if (this.adeFeatureProperties == null) {
                this.adeFeatureProperties = new HashMap();
            }
            properties = this.adeFeatureProperties.computeIfAbsent(namespaceURI, k -> new HashSet());
            properties.add(localName);
        }
    }

    private List<QName> prepareNameList(List<QName> nameList, boolean checkFeature) {
        ArrayList<QName> result = new ArrayList<QName>();
        for (QName name : nameList) {
            if (name.getNamespaceURI().length() != 0) {
                result.add(name);
                continue;
            }
            for (Module module : Modules.getModules()) {
                if ((!checkFeature || !module.hasFeature(name.getLocalPart())) && (checkFeature || !module.hasFeatureProperty(name.getLocalPart()))) continue;
                result.add(new QName(module.getNamespaceURI(), name.getLocalPart()));
            }
        }
        return result;
    }

    static class ElementInfo {
        private ElementDecl elementDecl;
        private boolean isFeature = false;
        private boolean isFeatureProperty = false;
        private boolean hasXLink = false;
        private boolean skipNestedElements = false;
        private Class<? extends AbstractFeature> featureClass;

        ElementInfo() {
            this.elementDecl = null;
        }

        ElementInfo(ElementDecl decl) {
            this.elementDecl = decl;
        }

        boolean isFeature() {
            return this.isFeature;
        }

        boolean hasXLink() {
            return this.hasXLink;
        }

        Class<? extends AbstractFeature> getFeatureClass() {
            return this.featureClass;
        }
    }
}

