/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.writer;

import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.ValidationEventHandler;
import org.citygml4j.builder.jaxb.CityGMLBuilderException;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.xml.io.writer.JAXBOutputFactory;
import org.citygml4j.builder.jaxb.xml.validation.ValidationSchemaHandler;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.module.Module;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.ade.ADEModule;
import org.citygml4j.model.module.citygml.CityGMLModule;
import org.citygml4j.model.module.citygml.CityGMLVersion;
import org.citygml4j.model.module.citygml.CoreModule;
import org.citygml4j.util.internal.xml.TransformerChainFactory;
import org.citygml4j.util.transform.FeatureSplitMode;
import org.citygml4j.util.transform.FeatureSplitter;
import org.citygml4j.util.xml.SAXWriter;
import org.citygml4j.xml.CityGMLNamespaceContext;
import org.citygml4j.xml.io.writer.AbstractCityGMLWriter;
import org.citygml4j.xml.io.writer.CityGMLWriteException;
import org.citygml4j.xml.io.writer.FeatureWriteMode;
import org.citygml4j.xml.schema.ElementDecl;
import org.citygml4j.xml.schema.Schema;
import org.citygml4j.xml.schema.SchemaHandler;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractJAXBWriter
implements AbstractCityGMLWriter {
    SAXWriter writer;
    JAXBMarshaller jaxbMarshaller;
    JAXBContext jaxbContext;
    FeatureSplitter featureSplitter;
    FeatureWriteMode featureWriteMode;
    TransformerChainFactory transformerChainFactory;
    boolean useValidation;
    ValidationSchemaHandler validationSchemaHandler;
    ValidationEventHandler validationEventHandler;
    private SchemaHandler schemaHandler;

    public AbstractJAXBWriter(SAXWriter writer, JAXBOutputFactory factory, ModuleContext moduleContext) throws CityGMLWriteException {
        this.writer = writer;
        this.jaxbMarshaller = factory.builder.createJAXBMarshaller(new ModuleContext(moduleContext));
        this.jaxbContext = factory.builder.getJAXBContext();
        this.schemaHandler = factory.getSchemaHandler();
        this.transformerChainFactory = factory.getTransformerChainFactory();
        this.featureWriteMode = (FeatureWriteMode)((Object)factory.getProperty("org.citygml4j.featureWriteMode"));
        this.useValidation = (Boolean)factory.getProperty("org.citygml4j.useValidation");
        if (this.featureWriteMode == FeatureWriteMode.SPLIT_PER_COLLECTION_MEMBER) {
            this.featureSplitter = new FeatureSplitter().setSchemaHandler(this.schemaHandler).setGMLIdManager(factory.getGMLIdManager()).setSplitMode(FeatureSplitMode.SPLIT_PER_COLLECTION_MEMBER).keepInlineAppearance((Boolean)factory.getProperty("org.citygml4j.keepInlineAppearance")).splitCopy((Boolean)factory.getProperty("org.citygml4j.splitCopy")).exclude((Set)factory.getProperty("org.citygml4j.excludeFromSplitting"));
        }
        if (this.useValidation) {
            if (this.schemaHandler == null) {
                try {
                    this.schemaHandler = factory.builder.getDefaultSchemaHandler();
                }
                catch (CityGMLBuilderException e) {
                    throw new CityGMLWriteException("Caused by: ", e);
                }
            }
            this.validationSchemaHandler = new ValidationSchemaHandler(this.schemaHandler);
            this.validationEventHandler = factory.getValidationEventHandler();
        }
    }

    @Override
    public void close() throws CityGMLWriteException {
        try {
            this.jaxbMarshaller = null;
            this.jaxbContext = null;
            this.featureSplitter = null;
            this.schemaHandler = null;
            this.validationSchemaHandler = null;
            this.validationEventHandler = null;
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public void reset() {
        if (this.writer != null) {
            this.writer.reset();
        }
    }

    @Override
    public void flush() throws CityGMLWriteException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public void setSchemaLocation(String namespaceURI, String schemaLocation) {
        this.writer.setSchemaLocation(namespaceURI, schemaLocation);
    }

    @Override
    public boolean isEscapeCharacters() {
        return this.writer.isEscapeCharacters();
    }

    @Override
    public String[] getHeaderComment() {
        return this.writer.getHeaderComment();
    }

    @Override
    public String getIndentString() {
        return this.writer.getIndentString();
    }

    @Override
    public CityGMLNamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.writer.getNamespaceURI(prefix);
    }

    @Override
    public String getPrefix(String uri) {
        return this.writer.getPrefix(uri);
    }

    @Override
    public String getSchemaLocation(String namespaceURI) {
        return this.writer.getSchemaLocation(namespaceURI);
    }

    @Override
    public boolean isWriteEncoding() {
        return this.writer.isWriteEncoding();
    }

    @Override
    public boolean isWriteXMLDecl() {
        return this.writer.isWriteXMLDecl();
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setEscapeCharacters(boolean escapeCharacters) {
        this.writer.setEscapeCharacters(escapeCharacters);
    }

    @Override
    public void setHeaderComment(String ... headerMessage) {
        this.writer.setHeaderComment(headerMessage);
    }

    @Override
    public void unsetHeaderComment() {
        this.writer.unsetHeaderComment();
    }

    @Override
    public void setIndentString(String indent) {
        this.writer.setIndentString(indent);
    }

    @Override
    public void setNamespaceContext(CityGMLNamespaceContext context) {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setWriteEncoding(boolean writeEncoding) {
        this.writer.setWriteEncoding(writeEncoding);
    }

    @Override
    public void setWriteXMLDecl(boolean writeXMLDecl) {
        this.writer.setWriteXMLDecl(writeXMLDecl);
    }

    @Override
    public ModuleContext getModuleContext() {
        return this.jaxbMarshaller.getModuleContext();
    }

    @Override
    public void setModuleContext(ModuleContext moduleContext) {
        this.jaxbMarshaller.setModuleContext(moduleContext);
    }

    @Override
    public void setSchemaLocation(Module module) {
        this.setSchemaLocation(module.getNamespaceURI(), module.getSchemaLocation());
    }

    @Override
    public void setSchemaLocations(CityGMLVersion version) {
        for (CityGMLModule module : version.getCityGMLModules()) {
            if (module instanceof CoreModule) continue;
            this.setSchemaLocation(module);
        }
    }

    @Override
    public void setSchemaLocations(ModuleContext moduleContext) {
        for (CityGMLModule module : moduleContext.getCityGMLModules()) {
            if (module instanceof CoreModule) continue;
            this.setSchemaLocation(module);
        }
        for (ADEModule adeModule : moduleContext.getADEModules()) {
            this.setSchemaLocation(adeModule);
        }
    }

    @Override
    public void setSchemaLocations(List<ADEContext> adeContexts) {
        for (ADEContext adeContext : adeContexts) {
            for (ADEModule module : adeContext.getADEModules()) {
                if (module == null || module.getSchemaLocation() == null) continue;
                this.setSchemaLocation(module.getNamespaceURI(), module.getSchemaLocation());
            }
        }
    }

    @Override
    public void setDefaultNamespace(Module module) {
        this.setDefaultNamespace(module.getNamespaceURI());
    }

    @Override
    public void setPrefix(Module module) {
        this.setPrefix(module.getNamespacePrefix(), module.getNamespaceURI());
    }

    @Override
    public void setPrefixes(CityGMLVersion version) {
        for (Module module : version.getModules()) {
            this.setPrefix(module);
        }
    }

    @Override
    public void setPrefixes(ModuleContext moduleContext) {
        for (Module module : moduleContext.getModules()) {
            this.setPrefix(module);
        }
    }

    @Override
    public void setPrefixes(List<ADEContext> adeContexts) {
        for (ADEContext adeContext : adeContexts) {
            for (ADEModule module : adeContext.getADEModules()) {
                if (module == null || module.getNamespacePrefix() == null) continue;
                this.setPrefix(module);
            }
        }
    }

    protected boolean isCityObject(ADEGenericElement adeGenericElement) {
        List<ElementDecl> elementDecls;
        Element element;
        Schema schema;
        boolean isCityObject = false;
        if (this.schemaHandler != null && (schema = this.schemaHandler.getSchema((element = adeGenericElement.getContent()).getNamespaceURI())) != null && (elementDecls = schema.getElementDecls(element.getLocalName())).size() == 1) {
            isCityObject = elementDecls.get(0).isCityObject();
        }
        return isCityObject;
    }
}

