/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.writer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import org.citygml4j.builder.jaxb.xml.io.writer.AbstractJAXBWriter;
import org.citygml4j.builder.jaxb.xml.io.writer.JAXBOutputFactory;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.citygml.core.CityObjectMember;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureArrayProperty;
import org.citygml4j.model.gml.feature.FeatureMember;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.citygml.CityGMLModuleType;
import org.citygml4j.util.internal.xml.TransformerChain;
import org.citygml4j.util.xml.SAXFragmentWriter;
import org.citygml4j.util.xml.SAXWriter;
import org.citygml4j.xml.io.writer.CityGMLWriteException;
import org.citygml4j.xml.io.writer.CityModelInfo;
import org.citygml4j.xml.io.writer.CityModelWriter;
import org.citygml4j.xml.io.writer.FeatureWriteMode;
import org.xml.sax.SAXException;

public class JAXBModelWriter
extends AbstractJAXBWriter
implements CityModelWriter {
    private CityModelInfo cityModelInfo;
    private ModuleContext initModuleCtx;
    private DocumentState documentState = DocumentState.INITIAL;

    public JAXBModelWriter(SAXWriter writer, JAXBOutputFactory factory, ModuleContext moduleContext) throws CityGMLWriteException {
        super(writer, factory, moduleContext);
        this.initModuleCtx = new ModuleContext(moduleContext);
    }

    public JAXBModelWriter(SAXWriter writer, JAXBOutputFactory factory, ModuleContext moduleContext, CityModelInfo cityModelInfo) throws CityGMLWriteException {
        this(writer, factory, moduleContext);
        this.cityModelInfo = cityModelInfo;
    }

    @Override
    public void reset() {
        this.documentState = DocumentState.INITIAL;
        this.cityModelInfo = null;
        super.reset();
    }

    @Override
    public void close() throws CityGMLWriteException {
        if (this.documentState == DocumentState.START_DOCUMENT) {
            this.writeEndDocument();
        }
        this.cityModelInfo = null;
        this.initModuleCtx = null;
        super.close();
    }

    @Override
    public CityModelInfo getCityModelInfo() {
        return this.cityModelInfo;
    }

    @Override
    public void setCityModelInfo(CityModelInfo cityModelInfo) {
        if (cityModelInfo == null) {
            throw new IllegalArgumentException("CityModelInfo may not be null.");
        }
        if (this.documentState == DocumentState.INITIAL) {
            this.cityModelInfo = cityModelInfo;
        }
    }

    @Override
    public void writeFeatureMember(AbstractFeature feature) throws CityGMLWriteException {
        this.writeModelMember(feature);
    }

    @Override
    public void writeFeatureMember(ADEComponent adeComponent) throws CityGMLWriteException {
        this.writeModelMember(adeComponent);
    }

    @Override
    public void writeStartDocument() throws CityGMLWriteException {
        switch (this.documentState) {
            case START_DOCUMENT: {
                throw new IllegalStateException("CityModel start element can only be written once.");
            }
            case END_DOCUMENT: {
                throw new IllegalStateException("CityModel start element cannot be written after CityModel end element.");
            }
            case INITIAL: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown document state '" + (Object)((Object)this.documentState) + "'");
            }
        }
        try {
            CityModel cityModel = null;
            if (this.cityModelInfo != null) {
                cityModel = this.cityModelInfo.toCityModel();
                cityModel.unsetGenericApplicationPropertyOfCityModel();
                cityModel.unsetGenericADEElement();
            } else {
                cityModel = new CityModel();
            }
            JAXBElement<?> jaxbElement = this.jaxbMarshaller.marshalJAXBElement(cityModel);
            if (jaxbElement != null) {
                Marshaller marshaller = this.createMarshaller(false);
                SAXFragmentWriter fragmentWriter = new SAXFragmentWriter(new QName(this.jaxbMarshaller.getModuleContext().getModule(CityGMLModuleType.CORE).getNamespaceURI(), "CityModel"), this.writer, SAXFragmentWriter.WriteMode.HEAD);
                if (this.transformerChainFactory == null) {
                    marshaller.marshal(jaxbElement, fragmentWriter);
                } else {
                    TransformerChain chain = this.transformerChainFactory.buildChain();
                    chain.tail().setResult(new SAXResult(fragmentWriter));
                    marshaller.marshal(jaxbElement, chain.head());
                }
            }
            this.documentState = DocumentState.START_DOCUMENT;
        }
        catch (JAXBException | TransformerConfigurationException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public void writeEndDocument() throws CityGMLWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("CityModel end element can only be written once.");
            }
            case INITIAL: {
                this.writeStartDocument();
            }
            case START_DOCUMENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown document state '" + (Object)((Object)this.documentState) + "'");
            }
        }
        try {
            CityModel cityModel = new CityModel();
            if (this.cityModelInfo != null) {
                if (this.cityModelInfo.isSetGenericApplicationPropertyOfCityModel()) {
                    cityModel.setGenericApplicationPropertyOfCityModel(this.cityModelInfo.getGenericApplicationPropertyOfCityModel());
                }
                if (this.cityModelInfo.isSetGenericADEElement()) {
                    cityModel.setGenericADEElement(this.cityModelInfo.getGenericADEElement());
                }
            }
            ModuleContext tmp = this.jaxbMarshaller.getModuleContext();
            this.jaxbMarshaller.setModuleContext(this.initModuleCtx);
            JAXBElement<?> jaxbElement = this.jaxbMarshaller.marshalJAXBElement(cityModel);
            if (jaxbElement != null) {
                SAXFragmentWriter fragmentWriter = new SAXFragmentWriter(new QName(this.jaxbMarshaller.getModuleContext().getModule(CityGMLModuleType.CORE).getNamespaceURI(), "CityModel"), this.writer, SAXFragmentWriter.WriteMode.TAIL);
                this.createMarshaller(true).marshal(jaxbElement, fragmentWriter);
            }
            this.jaxbMarshaller.setModuleContext(tmp);
            this.documentState = DocumentState.END_DOCUMENT;
        }
        catch (JAXBException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    private void writeModelMember(ModelObject object) throws CityGMLWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("model member cannot be written after CityModel end element.");
            }
            case INITIAL: {
                this.writeStartDocument();
                break;
            }
            case START_DOCUMENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown document state '" + (Object)((Object)this.documentState) + "'");
            }
        }
        try {
            Marshaller marshaller = this.createMarshaller(true);
            if (this.featureWriteMode == FeatureWriteMode.SPLIT_PER_COLLECTION_MEMBER) {
                for (FeatureProperty<? extends AbstractFeature> member : this.split(object)) {
                    JAXBElement<?> jaxbElement = this.jaxbMarshaller.marshalJAXBElement(member);
                    if (jaxbElement == null) continue;
                    if (this.transformerChainFactory == null) {
                        marshaller.marshal(jaxbElement, this.writer);
                        continue;
                    }
                    TransformerChain chain = this.transformerChainFactory.buildChain();
                    chain.tail().setResult(new SAXResult(this.writer));
                    chain.head().startDocument();
                    marshaller.marshal(jaxbElement, chain.head());
                    chain.head().endDocument();
                }
            } else {
                JAXBElement<?> jaxbElement;
                FeatureProperty<? extends AbstractFeature> member = this.wrap(object);
                if (member != null && (jaxbElement = this.jaxbMarshaller.marshalJAXBElement(member)) != null) {
                    if (this.transformerChainFactory == null) {
                        marshaller.marshal(jaxbElement, this.writer);
                    } else {
                        TransformerChain chain = this.transformerChainFactory.buildChain();
                        chain.tail().setResult(new SAXResult(this.writer));
                        chain.head().startDocument();
                        marshaller.marshal(jaxbElement, chain.head());
                        chain.head().endDocument();
                    }
                }
            }
        }
        catch (JAXBException | TransformerConfigurationException | SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    @Override
    public void writeFeatureMembers(List<ModelObject> features) throws CityGMLWriteException {
        switch (this.documentState) {
            case END_DOCUMENT: {
                throw new IllegalStateException("CityModel members cannot be written after document end.");
            }
            case INITIAL: {
                this.writeStartDocument();
                break;
            }
            case START_DOCUMENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown document state '" + (Object)((Object)this.documentState) + "'");
            }
        }
        FeatureArrayProperty members = new FeatureArrayProperty();
        ArrayList<FeatureProperty<? extends AbstractFeature>> featureArray = new ArrayList<FeatureProperty<? extends AbstractFeature>>();
        for (ModelObject modelObject : features) {
            if (!(modelObject instanceof AbstractFeature) && !(modelObject instanceof ADEComponent)) continue;
            if (this.featureWriteMode == FeatureWriteMode.SPLIT_PER_COLLECTION_MEMBER) {
                featureArray.addAll(this.split(modelObject));
                continue;
            }
            featureArray.add(this.wrap(modelObject));
        }
        for (FeatureProperty featureProperty : featureArray) {
            if (featureProperty == null) continue;
            if (featureProperty.isSetFeature()) {
                members.addFeature((AbstractFeature)featureProperty.getFeature());
                continue;
            }
            if (!featureProperty.isSetGenericADEElement()) continue;
            members.addGenericADEElement(featureProperty.getGenericADEElement());
        }
        try {
            JAXBElement<?> jaxbElement = this.jaxbMarshaller.marshalJAXBElement(members);
            if (jaxbElement != null) {
                Marshaller marshaller = this.createMarshaller(true);
                if (this.transformerChainFactory == null) {
                    marshaller.marshal(jaxbElement, this.writer);
                } else {
                    TransformerChain chain = this.transformerChainFactory.buildChain();
                    chain.tail().setResult(new SAXResult(this.writer));
                    chain.head().startDocument();
                    marshaller.marshal(jaxbElement, chain.head());
                    chain.head().endDocument();
                }
            }
        }
        catch (JAXBException | TransformerConfigurationException | SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    private FeatureProperty<? extends AbstractFeature> wrap(ModelObject object) {
        FeatureProperty member = null;
        if (object instanceof AbstractCityObject) {
            member = new CityObjectMember();
            ((CityObjectMember)member).setCityObject((AbstractCityObject)object);
        } else if (object instanceof Appearance) {
            member = new AppearanceMember();
            ((AppearanceMember)member).setAppearance((Appearance)object);
        } else if (object instanceof AbstractFeature) {
            member = new FeatureMember();
            ((FeatureMember)member).setFeature((AbstractFeature)object);
        } else if (object instanceof ADEGenericElement) {
            ADEGenericElement ade = (ADEGenericElement)object;
            member = this.isCityObject(ade) ? new CityObjectMember() : new FeatureMember();
            member.setGenericADEElement(ade);
        }
        return member;
    }

    private List<FeatureProperty<? extends AbstractFeature>> split(ModelObject object) {
        ArrayList<FeatureProperty<? extends AbstractFeature>> memberList = new ArrayList<FeatureProperty<? extends AbstractFeature>>();
        List<CityGML> results = this.featureSplitter.split(object);
        if (!results.isEmpty()) {
            for (CityGML result : results) {
                FeatureProperty<? extends AbstractFeature> member = this.wrap(result);
                if (member == null) continue;
                memberList.add(member);
            }
        } else {
            FeatureProperty<? extends AbstractFeature> member = this.wrap(object);
            if (member != null) {
                memberList.add(member);
            }
        }
        return memberList;
    }

    private Marshaller createMarshaller(boolean fragment) throws CityGMLWriteException {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            if (fragment) {
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            }
            if (this.useValidation) {
                marshaller.setSchema(this.validationSchemaHandler.getSchema());
                if (this.validationEventHandler != null) {
                    marshaller.setEventHandler(this.validationEventHandler);
                }
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
        catch (SAXException e) {
            throw new CityGMLWriteException("Caused by: ", e);
        }
    }

    private static enum DocumentState {
        INITIAL,
        START_DOCUMENT,
        END_DOCUMENT;

    }
}

