/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.appearance.AppearanceType;
import org.citygml4j.cityjson.extension.ExtensionType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.GeometryTemplatesType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.cityjson.geometry.VerticesList;
import org.citygml4j.cityjson.metadata.MetadataType;
import org.citygml4j.cityjson.util.PropertyHelper;

public class CityJSONAdapter
extends TypeAdapter<CityJSON> {
    private final Gson gson;
    private final CityJSONRegistry registry = CityJSONRegistry.getInstance();
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private List<String> predefinedProperties;

    public CityJSONAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, CityJSON value) throws IOException {
        if (value != null) {
            out.beginObject();
            out.name("type");
            out.value(value.getType());
            out.name("version");
            out.value(value.getVersion());
            if (value.metadata != null) {
                out.name("metadata");
                Streams.write(this.gson.toJsonTree(value.metadata, (Type)((Object)MetadataType.class)), out);
            }
            if (value.extensions != null) {
                out.name("extensions");
                Streams.write(this.gson.toJsonTree(value.extensions, new TypeToken<Map<String, ExtensionType>>(){}.getType()), out);
            }
            if (value.isSetExtensionProperties()) {
                JsonObject properties = this.gson.toJsonTree(value.getExtensionProperties()).getAsJsonObject();
                for (Map.Entry<String, JsonElement> entry : properties.entrySet()) {
                    out.name(entry.getKey());
                    Streams.write(entry.getValue(), out);
                }
            }
            if (value.cityObjects != null) {
                out.name("CityObjects");
                Streams.write(this.gson.toJsonTree(value.cityObjects, new TypeToken<Map<String, AbstractCityObjectType>>(){}.getType()), out);
            }
            if (value.vertices != null) {
                out.name("vertices");
                Streams.write(this.gson.toJsonTree(value.vertices, (Type)((Object)VerticesList.class)), out);
            }
            if (value.transform != null) {
                out.name("transform");
                Streams.write(this.gson.toJsonTree(value.transform, (Type)((Object)TransformType.class)), out);
            }
            if (value.appearance != null) {
                out.name("appearance");
                Streams.write(this.gson.toJsonTree(value.appearance, (Type)((Object)AppearanceType.class)), out);
            }
            if (value.geometryTemplates != null) {
                out.name("geometry-templates");
                Streams.write(this.gson.toJsonTree(value.geometryTemplates, (Type)((Object)GeometryTemplatesType.class)), out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    @Override
    public CityJSON read(JsonReader in) throws IOException {
        CityJSON cityJSON = null;
        if (this.predefinedProperties == null) {
            this.predefinedProperties = this.propertyHelper.getDeclaredProperties(CityJSON.class);
        }
        if (in.peek() != JsonToken.NULL) {
            cityJSON = new CityJSON();
            in.beginObject();
            block18: while (in.hasNext()) {
                String key;
                switch (key = in.nextName()) {
                    case "metadata": {
                        cityJSON.metadata = (MetadataType)this.gson.fromJson(in, (Type)((Object)MetadataType.class));
                        continue block18;
                    }
                    case "extensions": {
                        cityJSON.extensions = (Map)this.gson.fromJson(in, new TypeToken<Map<String, ExtensionType>>(){}.getType());
                        continue block18;
                    }
                    case "CityObjects": {
                        cityJSON.cityObjects = (Map)this.gson.fromJson(in, new TypeToken<Map<String, AbstractCityObjectType>>(){}.getType());
                        continue block18;
                    }
                    case "vertices": {
                        cityJSON.vertices = (VerticesList)this.gson.fromJson(in, (Type)((Object)VerticesList.class));
                        continue block18;
                    }
                    case "transform": {
                        cityJSON.transform = (TransformType)this.gson.fromJson(in, (Type)((Object)TransformType.class));
                        continue block18;
                    }
                    case "appearance": {
                        cityJSON.appearance = (AppearanceType)this.gson.fromJson(in, (Type)((Object)AppearanceType.class));
                        continue block18;
                    }
                    case "geometry-templates": {
                        cityJSON.geometryTemplates = (GeometryTemplatesType)this.gson.fromJson(in, (Type)((Object)GeometryTemplatesType.class));
                        continue block18;
                    }
                }
                if (!this.predefinedProperties.contains(key)) {
                    Type extensionAttributeType = this.registry.getExtensionPropertyClass(key, cityJSON);
                    Object value = extensionAttributeType != null ? this.gson.fromJson(in, extensionAttributeType) : this.propertyHelper.deserialize(Streams.parse(in));
                    if (value == null) continue;
                    cityJSON.addExtensionProperty(key, value);
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
        }
        return cityJSON;
    }
}

