/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.Map;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.CityJSONAdapter;
import org.citygml4j.cityjson.appearance.MaterialAdapter;
import org.citygml4j.cityjson.appearance.SolidCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SolidCollectionTextureObject;
import org.citygml4j.cityjson.appearance.SolidMaterialObject;
import org.citygml4j.cityjson.appearance.SolidTextureObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionTextureObject;
import org.citygml4j.cityjson.appearance.TextureAdapter;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.CityObjectTypeAdapter;
import org.citygml4j.cityjson.feature.CityObjectTypeFilter;
import org.citygml4j.cityjson.feature.CityObjectsAdapter;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryTypeAdapter;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.cityjson.geometry.SemanticsTypeAdapter;
import org.citygml4j.cityjson.geometry.VerticesList;
import org.citygml4j.cityjson.geometry.VerticesListAdapter;

public class CityJSONTypeAdapterFactory
implements TypeAdapterFactory {
    private TypeToken<?> cityObjects = new TypeToken<Map<String, AbstractCityObjectType>>(){};
    private TypeToken<?> semantics = TypeToken.get(SemanticsType.class);
    private TypeToken<?> solidTexture = new TypeToken<Map<String, SolidTextureObject>>(){};
    private TypeToken<?> surfaceCollectionTexture = new TypeToken<Map<String, SurfaceCollectionTextureObject>>(){};
    private TypeToken<?> solidCollectionTexture = new TypeToken<Map<String, SolidCollectionTextureObject>>(){};
    private TypeToken<?> solidMaterial = new TypeToken<Map<String, SolidMaterialObject>>(){};
    private TypeToken<?> surfaceCollectionMaterial = new TypeToken<Map<String, SurfaceCollectionMaterialObject>>(){};
    private TypeToken<?> solidCollectionMaterial = new TypeToken<Map<String, SolidCollectionMaterialObject>>(){};
    private CityObjectTypeFilter typeFilter;
    private boolean processUnknownExtensions;
    private boolean serializeVerticesAsInteger;

    public CityJSONTypeAdapterFactory withTypeFilter(CityObjectTypeFilter inputFilter) {
        this.typeFilter = inputFilter;
        return this;
    }

    public CityJSONTypeAdapterFactory processUnknownExtensions(boolean processUnknownExtensions) {
        this.processUnknownExtensions = processUnknownExtensions;
        return this;
    }

    public CityJSONTypeAdapterFactory serializeVerticesAsInteger(boolean serializeVerticesAsInteger) {
        this.serializeVerticesAsInteger = serializeVerticesAsInteger;
        return this;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (AbstractCityObjectType.class.isAssignableFrom(type.getRawType())) {
            return new CityObjectTypeAdapter(gson, this.typeFilter, this.processUnknownExtensions, this);
        }
        if (AbstractGeometryType.class.isAssignableFrom(type.getRawType())) {
            return new GeometryTypeAdapter(gson, this);
        }
        if (VerticesList.class.isAssignableFrom(type.getRawType())) {
            return new VerticesListAdapter(this.serializeVerticesAsInteger);
        }
        if (type.equals(this.semantics)) {
            return new SemanticsTypeAdapter(gson, this);
        }
        if (type.equals(this.surfaceCollectionTexture)) {
            return new TextureAdapter<SurfaceCollectionTextureObject>(gson, SurfaceCollectionTextureObject.class);
        }
        if (type.equals(this.solidTexture)) {
            return new TextureAdapter<SolidTextureObject>(gson, SolidTextureObject.class);
        }
        if (type.equals(this.solidCollectionTexture)) {
            return new TextureAdapter<SolidCollectionTextureObject>(gson, SolidCollectionTextureObject.class);
        }
        if (type.equals(this.surfaceCollectionMaterial)) {
            return new MaterialAdapter<SurfaceCollectionMaterialObject>(gson, SurfaceCollectionMaterialObject.class);
        }
        if (type.equals(this.solidMaterial)) {
            return new MaterialAdapter<SolidMaterialObject>(gson, SolidMaterialObject.class);
        }
        if (type.equals(this.solidCollectionMaterial)) {
            return new MaterialAdapter<SolidCollectionMaterialObject>(gson, SolidCollectionMaterialObject.class);
        }
        if (CityJSON.class.isAssignableFrom(type.getRawType())) {
            return new CityJSONAdapter(gson);
        }
        if (type.equals(this.cityObjects)) {
            return new CityObjectsAdapter(gson);
        }
        return null;
    }
}

