/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.appearance;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.citygml4j.cityjson.appearance.AbstractMaterialObject;

public class MaterialAdapter<T extends AbstractMaterialObject>
extends TypeAdapter<Map<String, T>> {
    private final Gson gson;
    private final Class<T> typeOfT;

    public MaterialAdapter(Gson gson, Class<T> typeOfT) {
        this.gson = gson;
        this.typeOfT = typeOfT;
    }

    @Override
    public void write(JsonWriter out, Map<String, T> value) throws IOException {
        if (value != null) {
            out.beginObject();
            for (Map.Entry<String, T> entry : value.entrySet()) {
                out.name(entry.getKey());
                Streams.write(this.gson.toJsonTree(entry.getValue(), this.typeOfT), out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    @Override
    public Map<String, T> read(JsonReader in) throws IOException {
        HashMap<String, AbstractMaterialObject> materials = null;
        if (in.peek() != JsonToken.NULL) {
            materials = new HashMap<String, AbstractMaterialObject>();
            in.beginObject();
            while (in.hasNext()) {
                String theme = in.nextName();
                AbstractMaterialObject material = (AbstractMaterialObject)this.gson.fromJson(in, this.typeOfT);
                material.theme = theme;
                materials.put(theme, material);
            }
            in.endObject();
        } else {
            in.nextNull();
        }
        return materials;
    }
}

