/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.Extension;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;

public abstract class AbstractCityObjectType
implements ExtensibleType,
Extension {
    String type;
    Attributes attributes;
    private List<Double> geographicalExtent;
    private Set<String> children;
    private Set<String> parents;
    private List<AbstractGeometryType> geometry = new ArrayList<AbstractGeometryType>();
    private transient String gmlId;
    private transient Map<String, Object> extensionProperties;
    private transient HashMap<String, Object> localProperties;

    public AbstractCityObjectType() {
    }

    public AbstractCityObjectType(String gmlId) {
        this.setGmlId(gmlId);
    }

    public abstract Attributes newAttributes();

    public abstract boolean isValidGeometryType(GeometryTypeName var1);

    protected final <T extends Attributes> T newAttributes(T attributes) {
        this.attributes = attributes != null ? attributes : new Attributes();
        return attributes;
    }

    public Attributes getAttributes() {
        return this.attributes != null ? this.attributes : this.newAttributes();
    }

    public final boolean isSetAttributes() {
        return this.attributes != null;
    }

    public final void unsetAttributes() {
        this.attributes = null;
    }

    public boolean isSetGmlId() {
        return this.gmlId != null;
    }

    public String getGmlId() {
        return this.gmlId;
    }

    public void setGmlId(String gmlId) {
        this.gmlId = gmlId != null && !gmlId.isEmpty() ? gmlId : "UUID_" + UUID.randomUUID().toString();
    }

    public final String getType() {
        return this.type;
    }

    public boolean isSetGeographicalExtent() {
        return this.geographicalExtent != null && this.geographicalExtent.size() >= 6;
    }

    public List<Double> getGeographicalExtent() {
        return this.isSetGeographicalExtent() ? this.geographicalExtent.subList(0, 6) : null;
    }

    public void setGeographicalExtent(List<Double> geographicalExtent) {
        if (geographicalExtent == null) {
            this.geographicalExtent = null;
        } else if (geographicalExtent.size() >= 6) {
            this.geographicalExtent = geographicalExtent.subList(0, 6);
        }
    }

    public void unsetGeographicalExtent() {
        this.geographicalExtent = null;
    }

    public boolean isSetChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void addChild(String child) {
        if (this.children == null) {
            this.children = new HashSet<String>();
        }
        this.children.add(child);
    }

    @Override
    public void addChild(AbstractCityObjectType child) {
        this.addChild(child.gmlId);
        child.addParent(this.gmlId);
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public void setChildren(Set<String> children) {
        this.children = children;
    }

    public void unsetChildren() {
        this.children = null;
    }

    public boolean isSetParents() {
        return this.parents != null && !this.parents.isEmpty();
    }

    public void addParent(String parent) {
        if (this.parents == null) {
            this.parents = new HashSet<String>();
        }
        this.parents.add(parent);
    }

    public void addParent(AbstractCityObjectType parent) {
        this.addParent(parent.gmlId);
        parent.addChild(this.gmlId);
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    public void unsetParents() {
        this.parents = null;
    }

    public boolean isSetGeometry() {
        return !this.geometry.isEmpty();
    }

    public void addGeometry(AbstractGeometryType geometry) {
        if (geometry != null && this.isValidGeometryType(geometry.getType())) {
            this.geometry.add(geometry);
        }
    }

    public List<AbstractGeometryType> getGeometry() {
        return this.geometry;
    }

    public void setGeometry(List<AbstractGeometryType> geometry) {
        if (geometry != null) {
            this.geometry = new ArrayList<AbstractGeometryType>(geometry);
            this.geometry.removeIf(g2 -> !this.isValidGeometryType(g2.getType()));
        }
    }

    public void removeGeometry(AbstractGeometryType geometry) {
        this.geometry.remove(geometry);
    }

    public void unsetGeometry() {
        this.geometry.clear();
    }

    public boolean isSetExtensionProperties() {
        return this.extensionProperties != null;
    }

    public void addExtensionProperty(String name, Object value) {
        if (this.extensionProperties == null) {
            this.extensionProperties = new HashMap<String, Object>();
        }
        this.extensionProperties.put(name, value);
    }

    public Map<String, Object> getExtensionProperties() {
        return this.extensionProperties;
    }

    public void setExtensionProperties(Map<String, Object> extensionProperties) {
        this.extensionProperties = extensionProperties;
    }

    public void removeExtensionProperty(String name) {
        if (this.extensionProperties != null) {
            this.extensionProperties.remove(name);
        }
    }

    public void unsetExtensionProperties() {
        this.extensionProperties = null;
    }

    public Object getLocalProperty(String name) {
        if (this.localProperties != null) {
            return this.localProperties.get(name);
        }
        return null;
    }

    public void setLocalProperty(String name, Object value) {
        if (this.localProperties == null) {
            this.localProperties = new HashMap();
        }
        this.localProperties.put(name, value);
    }

    public boolean hasLocalProperty(String name) {
        return this.localProperties != null && this.localProperties.containsKey(name);
    }

    public Object unsetLocalProperty(String name) {
        if (this.localProperties != null) {
            return this.localProperties.remove(name);
        }
        return null;
    }

    Class<? extends Attributes> getAttributesClass() {
        Attributes tmp = this.attributes;
        this.newAttributes();
        Class<Attributes> attributesClass = this.attributes != null ? this.attributes.getClass() : Attributes.class;
        this.attributes = tmp;
        return attributesClass;
    }
}

