/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.feature;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.CityObjectTypeFilter;
import org.citygml4j.cityjson.feature.GenericCityObjectType;
import org.citygml4j.cityjson.util.PropertyHelper;

public class CityObjectTypeAdapter
extends TypeAdapter<AbstractCityObjectType> {
    public static final String UNKNOWN_EXTENSION = "org.citygml4j.unknownExtension";
    private final Gson gson;
    private final TypeAdapterFactory factory;
    private final CityObjectTypeFilter typeFilter;
    private final boolean processUnknownExtensions;
    private final CityJSONRegistry registry = CityJSONRegistry.getInstance();
    private final Map<String, List<String>> predefinedProperties = new HashMap<String, List<String>>();
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public CityObjectTypeAdapter(Gson gson, CityObjectTypeFilter typeFilter, boolean processUnknownExtensions, TypeAdapterFactory factory) {
        this.gson = gson;
        this.typeFilter = typeFilter;
        this.processUnknownExtensions = processUnknownExtensions;
        this.factory = factory;
    }

    public CityObjectTypeAdapter(Gson gson, TypeAdapterFactory factory) {
        this(gson, null, false, factory);
    }

    @Override
    public void write(JsonWriter out, AbstractCityObjectType value) throws IOException {
        if (value != null) {
            if (value.type == null) {
                value.type = CityJSONRegistry.getInstance().getCityObjectType(value);
            }
            if (this.typeFilter != null && !this.typeFilter.accept(value.type)) {
                return;
            }
            TypeAdapter<?> delegate = this.gson.getDelegateAdapter(this.factory, TypeToken.get(value.getClass()));
            JsonElement element = delegate.toJsonTree(value);
            if (element != null && element.isJsonObject()) {
                JsonObject result = element.getAsJsonObject();
                if (value.isSetExtensionProperties()) {
                    JsonObject properties = this.gson.toJsonTree(value.getExtensionProperties()).getAsJsonObject();
                    for (Map.Entry<String, JsonElement> entry : properties.entrySet()) {
                        result.add(entry.getKey(), entry.getValue());
                    }
                }
                if (value.attributes != null) {
                    JsonObject object = result.getAsJsonObject("attributes");
                    if (value.attributes.isSetExtensionAttributes()) {
                        JsonObject attributes = this.gson.toJsonTree(value.attributes.getExtensionAttributes()).getAsJsonObject();
                        for (Map.Entry<String, JsonElement> entry : attributes.entrySet()) {
                            object.add(entry.getKey(), entry.getValue());
                        }
                    }
                    if (object.entrySet().isEmpty() || object.entrySet().stream().allMatch(e -> ((JsonElement)e.getValue()).isJsonNull())) {
                        result.getAsJsonObject().remove("attributes");
                    }
                }
            }
            Streams.write(element, out);
        } else {
            out.nullValue();
        }
    }

    @Override
    public AbstractCityObjectType read(JsonReader in) throws IOException {
        JsonObject object;
        JsonElement type;
        if (in.peek() != JsonToken.NULL && (type = (object = Streams.parse(in).getAsJsonObject()).get("type")) != null) {
            Class<? extends AbstractCityObjectType> typeOf = this.registry.getCityObjectClass(type.getAsString());
            boolean unknownExtension = false;
            if (typeOf == null && this.processUnknownExtensions) {
                typeOf = GenericCityObjectType.class;
                unknownExtension = true;
            }
            if (typeOf != null && (this.typeFilter == null || this.typeFilter.accept(type.getAsString()))) {
                AbstractCityObjectType cityObject = this.gson.getDelegateAdapter(this.factory, TypeToken.get(typeOf)).fromJsonTree(object);
                cityObject.type = type.getAsString();
                Map<String, Object> extensionProperties = this.deserialize(object.entrySet(), typeOf, cityObject);
                if (!extensionProperties.isEmpty()) {
                    cityObject.setExtensionProperties(extensionProperties);
                }
                if (cityObject.attributes != null) {
                    Map<String, Object> extensionAttributes;
                    JsonObject attributes = object.get("attributes").getAsJsonObject();
                    Class<? extends Attributes> attributesClass = cityObject.getAttributesClass();
                    if (attributesClass != Attributes.class) {
                        cityObject.attributes = this.gson.fromJson((JsonElement)attributes, attributesClass);
                    }
                    if (!(extensionAttributes = this.deserialize(attributes.entrySet(), attributesClass, cityObject)).isEmpty()) {
                        cityObject.attributes.setExtensionAttributes(extensionAttributes);
                    }
                }
                if (unknownExtension) {
                    cityObject.setLocalProperty(UNKNOWN_EXTENSION, true);
                }
                return cityObject;
            }
        }
        return null;
    }

    private Map<String, Object> deserialize(Set<Map.Entry<String, JsonElement>> entrySet, Class<?> typeClass, AbstractCityObjectType cityObject) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        List predefined = this.predefinedProperties.computeIfAbsent(typeClass.getTypeName(), v -> this.propertyHelper.getDeclaredProperties(typeClass));
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            Type extensionAttributeType;
            Object value;
            String key = entry.getKey();
            if (predefined.contains(key) || (value = (extensionAttributeType = this.registry.getExtensionPropertyClass(entry.getKey(), cityObject)) != null ? this.gson.fromJson(entry.getValue(), extensionAttributeType) : this.propertyHelper.deserialize(entry.getValue())) == null) continue;
            properties.put(key, value);
        }
        return properties;
    }
}

