/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.feature;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;

public class CityObjectsAdapter
extends TypeAdapter<Map<String, AbstractCityObjectType>> {
    private final Gson gson;

    public CityObjectsAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, Map<String, AbstractCityObjectType> value) throws IOException {
        if (value != null) {
            out.beginObject();
            for (Map.Entry<String, AbstractCityObjectType> entry : value.entrySet()) {
                out.name(entry.getKey());
                Streams.write(this.gson.toJsonTree(entry.getValue(), (Type)((Object)AbstractCityObjectType.class)), out);
            }
            out.endObject();
        } else {
            out.nullValue();
        }
    }

    @Override
    public Map<String, AbstractCityObjectType> read(JsonReader in) throws IOException {
        HashMap<String, AbstractCityObjectType> cityObjects = null;
        if (in.peek() != JsonToken.NULL) {
            cityObjects = new HashMap<String, AbstractCityObjectType>();
            in.beginObject();
            while (in.hasNext()) {
                String gmlId = in.nextName();
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    continue;
                }
                AbstractCityObjectType cityObject = (AbstractCityObjectType)this.gson.fromJson(in, (Type)((Object)AbstractCityObjectType.class));
                if (cityObject == null) continue;
                cityObject.setGmlId(gmlId);
                cityObjects.put(gmlId, cityObject);
            }
            in.endObject();
        }
        return cityObjects;
    }
}

