/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.metadata;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.feature.DateAdapter;
import org.citygml4j.cityjson.metadata.ConstraintsType;
import org.citygml4j.cityjson.metadata.ContactDetailsType;
import org.citygml4j.cityjson.metadata.DatasetTopicCategoryType;
import org.citygml4j.cityjson.metadata.FeatureDataType;
import org.citygml4j.cityjson.metadata.LineageType;
import org.citygml4j.cityjson.metadata.PresenceType;
import org.citygml4j.cityjson.metadata.SpatialRepresentationType;
import org.citygml4j.cityjson.metadata.TemporalExtentType;

public class MetadataType {
    private String citymodelIdentifier;
    private String datasetTitle;
    @JsonAdapter(value=DateAdapter.class)
    private LocalDate datasetReferenceDate;
    private String geographicLocation;
    private String datasetLanguage;
    private String datasetCharacterSet;
    private DatasetTopicCategoryType datasetTopicCategory;
    private String distributionFormatVersion;
    private SpatialRepresentationType spatialRepresentationType;
    private String referenceSystem;
    private String onlineResource;
    private String fileIdentifier;
    private ContactDetailsType datasetPointOfContact;
    private String metadataStandard;
    private String metadataStandardVersion;
    private String metadataLanguage;
    private String metadataCharacterSet;
    @JsonAdapter(value=DateAdapter.class)
    private LocalDate metadataDateStamp;
    private ContactDetailsType metadataPointOfContact;
    @SerializedName(value="lineage")
    private List<LineageType> lineages;
    private List<Double> geographicalExtent;
    private TemporalExtentType temporalExtent;
    @SerializedName(value="abstract")
    private String datasetAbstract;
    private String specificUsage;
    private List<String> keywords;
    private ConstraintsType constraints;
    private List<String> thematicModels;
    private PresenceType textures;
    private PresenceType materials;
    private Map<String, Integer> presentLoDs;
    private Map<String, FeatureDataType> cityfeatureMetadata;

    public boolean isSetCitymodelIdentifier() {
        return this.citymodelIdentifier != null;
    }

    public String getCitymodelIdentifier() {
        return this.citymodelIdentifier;
    }

    public void setCitymodelIdentifier(String citymodelIdentifier) {
        this.citymodelIdentifier = citymodelIdentifier;
    }

    public void unsetCitymodelIdentifier() {
        this.citymodelIdentifier = null;
    }

    public boolean isSetDatasetTitle() {
        return this.datasetTitle != null;
    }

    public String getDatasetTitle() {
        return this.datasetTitle;
    }

    public void setDatasetTitle(String datasetTitle) {
        this.datasetTitle = datasetTitle;
    }

    public void unsetDatasetTitle() {
        this.datasetTitle = null;
    }

    public boolean isSetDatasetReferenceDate() {
        return this.datasetReferenceDate != null;
    }

    public LocalDate getDatasetReferenceDate() {
        return this.datasetReferenceDate;
    }

    public void setDatasetReferenceDate(ZonedDateTime datasetReferenceDate) {
        this.datasetReferenceDate = datasetReferenceDate.toLocalDate();
    }

    public void setDatasetReferenceDate(LocalDateTime datasetReferenceDate) {
        this.datasetReferenceDate = datasetReferenceDate.toLocalDate();
    }

    public void setDatasetReferenceDate(LocalDate datasetReferenceDate) {
        this.datasetReferenceDate = datasetReferenceDate;
    }

    public void unsetDatasetReferenceDate() {
        this.datasetReferenceDate = null;
    }

    public boolean isSetGeographicLocation() {
        return this.geographicLocation != null;
    }

    public String getGeographicLocation() {
        return this.geographicLocation;
    }

    public void setGeographicLocation(String geographicLocation) {
        this.geographicLocation = geographicLocation;
    }

    public void unsetGeographicLocation() {
        this.geographicLocation = null;
    }

    public boolean isSetDatasetLanguage() {
        return this.datasetLanguage != null;
    }

    public String getDatasetLanguage() {
        return this.datasetLanguage;
    }

    public void setDatasetLanguage(String datasetLanguage) {
        this.datasetLanguage = datasetLanguage;
    }

    public void unsetDatasetLanguage() {
        this.datasetLanguage = null;
    }

    public boolean isSetDatasetCharacterSet() {
        return this.datasetCharacterSet != null;
    }

    public String getDatasetCharacterSet() {
        return this.datasetCharacterSet;
    }

    public void setDatasetCharacterSet(String datasetCharacterSet) {
        this.datasetCharacterSet = datasetCharacterSet;
    }

    public void unsetDatasetCharacterSet() {
        this.datasetCharacterSet = null;
    }

    public boolean isSetDatasetTopicCategory() {
        return this.datasetTopicCategory != null;
    }

    public DatasetTopicCategoryType getDatasetTopicCategory() {
        return this.datasetTopicCategory;
    }

    public void setDatasetTopicCategory(DatasetTopicCategoryType datasetTopicCategory) {
        this.datasetTopicCategory = datasetTopicCategory;
    }

    public void unsetDatasetTopicCategory() {
        this.datasetTopicCategory = null;
    }

    public boolean isSetDistributionFormatVersion() {
        return this.distributionFormatVersion != null;
    }

    public String getDistributionFormatVersion() {
        return this.distributionFormatVersion;
    }

    public void setDistributionFormatVersion(String distributionFormatVersion) {
        if (distributionFormatVersion != null && distributionFormatVersion.matches("^(\\d\\.)(\\d)$")) {
            this.distributionFormatVersion = distributionFormatVersion;
        }
    }

    public void unsetDistributionFormatVersion() {
        this.distributionFormatVersion = null;
    }

    public boolean isSetSpatialRepresentationType() {
        return this.spatialRepresentationType != null;
    }

    public SpatialRepresentationType getSpatialRepresentationType() {
        return this.spatialRepresentationType;
    }

    public void setSpatialRepresentationType(SpatialRepresentationType spatialRepresentationType) {
        this.spatialRepresentationType = spatialRepresentationType;
    }

    public void unsetSpatialRepresentationType() {
        this.spatialRepresentationType = null;
    }

    public boolean isSetReferenceSystem() {
        return this.referenceSystem != null;
    }

    public String getReferenceSystem() {
        return this.referenceSystem;
    }

    public void setReferenceSystem(int epsg) {
        if (epsg > 999 && epsg < 100000) {
            this.referenceSystem = "urn:ogc:def:crs:EPSG::" + epsg;
        }
    }

    public void unsetReferenceSystem() {
        this.referenceSystem = null;
    }

    public boolean isSetOnlineResource() {
        return this.onlineResource != null;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setOnlineResource(String onlineResource) {
        if (onlineResource != null && onlineResource.matches("^(https?|ftp)://.*")) {
            this.onlineResource = onlineResource;
        }
    }

    public void unsetOnlineResource() {
        this.onlineResource = null;
    }

    public boolean isSetFileIdentifier() {
        return this.fileIdentifier != null;
    }

    public String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public void setFileIdentifier(String fileIdentifier) {
        this.fileIdentifier = fileIdentifier;
    }

    public void unsetFileIdentifier() {
        this.fileIdentifier = null;
    }

    public boolean isSetDatasetPointOfContact() {
        return this.datasetPointOfContact != null;
    }

    public ContactDetailsType getDatasetPointOfContact() {
        return this.datasetPointOfContact;
    }

    public void setDatasetPointOfContact(ContactDetailsType datasetPointOfContact) {
        this.datasetPointOfContact = datasetPointOfContact;
    }

    public void unsetDatasetPointOfContact() {
        this.datasetPointOfContact = null;
    }

    public boolean isSetMetadataStandard() {
        return this.metadataStandard != null;
    }

    public String getMetadataStandard() {
        return this.metadataStandard;
    }

    public void setMetadataStandard(String metadataStandard) {
        this.metadataStandard = metadataStandard;
    }

    public void unsetMetadataStandard() {
        this.metadataStandard = null;
    }

    public boolean isSetMetadataStandardVersion() {
        return this.metadataStandardVersion != null;
    }

    public String getMetadataStandardVersion() {
        return this.metadataStandardVersion;
    }

    public void setMetadataStandardVersion(String metadataStandardVersion) {
        this.metadataStandardVersion = metadataStandardVersion;
    }

    public void unsetMetadataStandardVersion() {
        this.metadataStandardVersion = null;
    }

    public boolean isSetMetadataLanguage() {
        return this.metadataLanguage != null;
    }

    public String getMetadataLanguage() {
        return this.metadataLanguage;
    }

    public void setMetadataLanguage(String metadataLanguage) {
        this.metadataLanguage = metadataLanguage;
    }

    public void unsetMetadataLanguage() {
        this.metadataLanguage = null;
    }

    public boolean isSetMetadataCharacterSet() {
        return this.metadataCharacterSet != null;
    }

    public String getMetadataCharacterSet() {
        return this.metadataCharacterSet;
    }

    public void setMetadataCharacterSet(String metadataCharacterSet) {
        this.metadataCharacterSet = metadataCharacterSet;
    }

    public void unsetMetadataCharacterSet() {
        this.metadataCharacterSet = null;
    }

    public boolean isSetMetadataDateStamp() {
        return this.metadataDateStamp != null;
    }

    public LocalDate getMetadataDateStamp() {
        return this.metadataDateStamp;
    }

    public void setMetadataDateStamp(ZonedDateTime metadataDateStamp) {
        this.metadataDateStamp = metadataDateStamp.toLocalDate();
    }

    public void setMetadataDateStamp(LocalDateTime metadataDateStamp) {
        this.metadataDateStamp = metadataDateStamp.toLocalDate();
    }

    public void setMetadataDateStamp(LocalDate metadataDateStamp) {
        this.metadataDateStamp = metadataDateStamp;
    }

    public void unsetMetadataDateStamp() {
        this.metadataDateStamp = null;
    }

    public boolean isSetMetadataPointOfContact() {
        return this.metadataPointOfContact != null;
    }

    public ContactDetailsType getMetadataPointOfContact() {
        return this.metadataPointOfContact;
    }

    public void setMetadataPointOfContact(ContactDetailsType metadataPointOfContact) {
        this.metadataPointOfContact = metadataPointOfContact;
    }

    public void unsetMetadataPointOfContact() {
        this.metadataPointOfContact = null;
    }

    public boolean isSetLineages() {
        return this.lineages != null && !this.lineages.isEmpty();
    }

    public List<LineageType> getLineages() {
        return this.lineages;
    }

    public void addLineage(LineageType lineage) {
        if (this.lineages == null) {
            this.lineages = new ArrayList<LineageType>();
        }
        this.lineages.add(lineage);
    }

    public void setLineages(List<LineageType> lineages) {
        this.lineages = lineages;
    }

    public void unsetLineages() {
        this.lineages = null;
    }

    public boolean isSetGeographicalExtent() {
        return this.geographicalExtent != null && this.geographicalExtent.size() >= 6;
    }

    public List<Double> getGeographicalExtent() {
        return this.isSetGeographicalExtent() ? this.geographicalExtent.subList(0, 6) : null;
    }

    public void setGeographicalExtent(List<Double> geographicalExtent) {
        if (geographicalExtent == null) {
            this.geographicalExtent = null;
        } else if (geographicalExtent.size() >= 6) {
            this.geographicalExtent = geographicalExtent.subList(0, 6);
        }
    }

    public void unsetGeographicalExtent() {
        this.geographicalExtent = null;
    }

    public boolean isSetTemporalExtent() {
        return this.temporalExtent != null;
    }

    public TemporalExtentType getTemporalExtent() {
        return this.temporalExtent;
    }

    public void setTemporalExtent(TemporalExtentType temporalExtent) {
        this.temporalExtent = temporalExtent;
    }

    public void unsetTemporalExtent() {
        this.temporalExtent = null;
    }

    public boolean isSetAbstract() {
        return this.datasetAbstract != null;
    }

    public String getAbstract() {
        return this.datasetAbstract;
    }

    public void setAbstract(String datasetAbstract) {
        this.datasetAbstract = datasetAbstract;
    }

    public void unsetAbstract() {
        this.datasetAbstract = null;
    }

    public boolean isSetSpecificUsage() {
        return this.specificUsage != null;
    }

    public String getSpecificUsage() {
        return this.specificUsage;
    }

    public void setSpecificUsage(String specificUsage) {
        this.specificUsage = specificUsage;
    }

    public void unsetSpecificUsage() {
        this.specificUsage = null;
    }

    public boolean isSetKeywords() {
        return this.keywords != null;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addKeyWord(String keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keyword);
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void removeKeyword(String keyword) {
        if (this.keywords != null) {
            this.keywords.remove(keyword);
        }
    }

    public void unsetsetKeywords() {
        this.keywords = null;
    }

    public boolean isSetConstraints() {
        return this.constraints != null;
    }

    public ConstraintsType getConstraints() {
        return this.constraints;
    }

    public void setConstraints(ConstraintsType constraints) {
        this.constraints = constraints;
    }

    public void unsetConstraints() {
        this.constraints = null;
    }

    public boolean isSetThematicModels() {
        return this.thematicModels != null;
    }

    public List<String> getThematicModels() {
        return this.thematicModels;
    }

    public void addThematicModel(String thematicModel) {
        if (this.thematicModels == null) {
            this.thematicModels = new ArrayList<String>();
        }
        this.thematicModels.add(thematicModel);
    }

    public void setThematicModels(List<String> thematicModels) {
        this.thematicModels = thematicModels;
    }

    public void unsetThematicModels() {
        this.thematicModels = null;
    }

    public boolean isSetTextures() {
        return this.textures != null;
    }

    public PresenceType getTextures() {
        return this.textures;
    }

    public void setTextures(PresenceType textures) {
        this.textures = textures;
    }

    public void unsetTextures() {
        this.textures = null;
    }

    public boolean isSetMaterials() {
        return this.materials != null;
    }

    public PresenceType getMaterials() {
        return this.materials;
    }

    public void setMaterials(PresenceType materials) {
        this.materials = materials;
    }

    public void unsetMaterials() {
        this.materials = null;
    }

    public boolean isSetPresentLoDs() {
        return this.presentLoDs != null && !this.presentLoDs.isEmpty();
    }

    public void addPresentLoD(String lod) {
        if (lod != null && lod.matches("^[0-9](\\.[0-9])?$")) {
            if (this.presentLoDs == null) {
                this.presentLoDs = new HashMap<String, Integer>();
            }
            this.presentLoDs.merge(lod, 1, Integer::sum);
        }
    }

    public void addPresentLoD(Number lod) {
        this.addPresentLoD(String.valueOf(lod));
    }

    public Map<String, Integer> getPresentLoDs() {
        return this.presentLoDs;
    }

    public void setPresentLoDs(Map<String, Integer> presentLoDs) {
        this.presentLoDs = presentLoDs;
    }

    public void unsetPresentLoDs() {
        this.presentLoDs = null;
    }

    public boolean isSetCityFeatureMetadata() {
        return this.cityfeatureMetadata != null && !this.cityfeatureMetadata.isEmpty();
    }

    public void addCityFeatureMetadata(String type, FeatureDataType featureMetadata) {
        if (this.cityfeatureMetadata == null) {
            this.cityfeatureMetadata = new HashMap<String, FeatureDataType>();
        }
        this.cityfeatureMetadata.put(type, featureMetadata);
    }

    public Map<String, FeatureDataType> getCityFeatureMetadata() {
        return this.cityfeatureMetadata;
    }

    public void setCityFeatureMetadata(Map<String, FeatureDataType> cityfeatureMetadata) {
        this.cityfeatureMetadata = cityfeatureMetadata;
    }

    public void unsetCityFeatureMetadata() {
        this.cityfeatureMetadata = null;
    }
}

